/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.threadcommand;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ThreadStateHeader
implements StructConverter {
    private int flavor;
    private int count;

    static ThreadStateHeader createThreadStateHeader(FactoryBundledWithBinaryReader reader) throws IOException {
        ThreadStateHeader threadStateHeader = (ThreadStateHeader)reader.getFactory().create(ThreadStateHeader.class, new Object[0]);
        threadStateHeader.initThreadStateHeader(reader);
        return threadStateHeader;
    }

    private void initThreadStateHeader(FactoryBundledWithBinaryReader reader) throws IOException {
        this.flavor = reader.readNextInt();
        this.count = reader.readNextInt();
    }

    public int getFlavor() {
        return this.flavor;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("thread_state_hdr", 0);
        struct.add(DWORD, "flavor", null);
        struct.add(DWORD, "count", null);
        return struct;
    }
}

