/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.macho.commands.DyldChainedFixupHeader;
import ghidra.app.util.bin.format.macho.commands.DyldChainedImport;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;

public class DyldChainedImports
implements StructConverter {
    private int imports_count;
    private int imports_format;
    private long imports_offset;
    private DyldChainedImport[] chainedImports;

    static DyldChainedImports createDyldChainedImports(FactoryBundledWithBinaryReader reader, DyldChainedFixupHeader cfh) throws IOException {
        DyldChainedImports dyldChainedImports = (DyldChainedImports)reader.getFactory().create(DyldChainedImports.class, new Object[0]);
        dyldChainedImports.initDyldChainedStartsInImage(reader, cfh);
        return dyldChainedImports;
    }

    private void initDyldChainedStartsInImage(FactoryBundledWithBinaryReader reader, DyldChainedFixupHeader cfh) throws IOException {
        long ptrIndex;
        this.imports_offset = ptrIndex = reader.getPointerIndex();
        this.imports_count = cfh.getImports_count();
        this.imports_format = cfh.getImports_format();
        ArrayList<DyldChainedImport> starts = new ArrayList<DyldChainedImport>();
        for (int i = 0; i < this.imports_count; ++i) {
            starts.add(DyldChainedImport.createDyldChainedImport(reader, cfh, this.imports_format));
        }
        this.chainedImports = (DyldChainedImport[])starts.toArray(DyldChainedImport[]::new);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        DataType chainedImportDt = this.chainedImports[0].toDataType();
        ArrayDataType dt = new ArrayDataType(chainedImportDt, this.imports_count, chainedImportDt.getLength());
        return dt;
    }

    public int getImportsCount() {
        return this.imports_count;
    }

    public long getImportsOffset() {
        return this.imports_offset;
    }

    public DyldChainedImport[] getChainedImports() {
        return this.chainedImports;
    }

    public DyldChainedImport getChainedImport(int ordinal) {
        if (ordinal < 0 || ordinal >= this.imports_count) {
            return null;
        }
        return this.chainedImports[ordinal];
    }

    public void initSymbols(FactoryBundledWithBinaryReader reader, DyldChainedFixupHeader dyldChainedFixupHeader) throws IOException {
        long ptrIndex = reader.getPointerIndex();
        for (DyldChainedImport dyldChainedImport : this.chainedImports) {
            reader.setPointerIndex(ptrIndex + dyldChainedImport.getNameOffset());
            dyldChainedImport.initString(reader);
        }
    }
}

