/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.extend;

import ghidra.app.util.bin.format.MemoryLoadable;
import ghidra.app.util.bin.format.elf.ElfDefaultGotPltMarkup;
import ghidra.app.util.bin.format.elf.ElfDynamicType;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfProgramHeader;
import ghidra.app.util.bin.format.elf.ElfProgramHeaderType;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.app.util.bin.format.elf.ElfSectionHeaderType;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NoValueException;
import ghidra.util.task.TaskMonitor;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class ElfLoadAdapter {
    public final void addDynamicTypes(Map<Integer, ElfDynamicType> dynamicTypeMap) {
        for (Field field : this.getClass().getDeclaredFields()) {
            String name = null;
            try {
                if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(ElfDynamicType.class)) continue;
                ElfDynamicType type = (ElfDynamicType)field.get(this);
                name = type.name;
                ElfDynamicType.addDynamicType(type, dynamicTypeMap);
            }
            catch (DuplicateNameException e) {
                Msg.error((Object)this, (Object)("Invalid ElfDynamicType(" + name + ") defined by " + this.getClass().getName()), (Throwable)e);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new AssertException((Throwable)e);
            }
        }
    }

    public final void addProgramHeaderTypes(Map<Integer, ElfProgramHeaderType> programHeaderTypeMap) {
        for (Field field : this.getClass().getDeclaredFields()) {
            String name = null;
            try {
                if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(ElfProgramHeaderType.class)) continue;
                ElfProgramHeaderType type = (ElfProgramHeaderType)field.get(this);
                name = type.name;
                ElfProgramHeaderType.addProgramHeaderType(type, programHeaderTypeMap);
            }
            catch (DuplicateNameException e) {
                Msg.error((Object)this, (Object)("Invalid ElfProgramHeaderType(" + name + ") defined by " + this.getClass().getName()), (Throwable)e);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new AssertException((Throwable)e);
            }
        }
    }

    public final void addSectionHeaderTypes(HashMap<Integer, ElfSectionHeaderType> sectionHeaderTypeMap) {
        for (Field field : this.getClass().getDeclaredFields()) {
            String name = null;
            try {
                if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(ElfSectionHeaderType.class)) continue;
                ElfSectionHeaderType type = (ElfSectionHeaderType)field.get(this);
                name = type.name;
                ElfSectionHeaderType.addSectionHeaderType(type, sectionHeaderTypeMap);
            }
            catch (DuplicateNameException e) {
                Msg.error((Object)this, (Object)("Invalid ElfSectionHeaderType(" + name + ") defined by " + this.getClass().getName()), (Throwable)e);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new AssertException((Throwable)e);
            }
        }
    }

    public AddressSpace getPreferredSegmentAddressSpace(ElfLoadHelper elfLoadHelper, ElfProgramHeader elfProgramHeader) {
        Program program = elfLoadHelper.getProgram();
        if (elfProgramHeader.isExecute()) {
            return program.getAddressFactory().getDefaultAddressSpace();
        }
        return program.getLanguage().getDefaultDataSpace();
    }

    public Address getPreferredSegmentAddress(ElfLoadHelper elfLoadHelper, ElfProgramHeader elfProgramHeader) {
        Program program = elfLoadHelper.getProgram();
        AddressSpace space = this.getPreferredSegmentAddressSpace(elfLoadHelper, elfProgramHeader);
        long addrWordOffset = elfProgramHeader.getVirtualAddress();
        if (space == program.getAddressFactory().getDefaultAddressSpace()) {
            addrWordOffset += elfLoadHelper.getImageBaseWordAdjustmentOffset();
        }
        return space.getTruncatedAddress(addrWordOffset, true);
    }

    public int getDefaultAlignment(ElfLoadHelper elfLoadHelper) {
        Program program = elfLoadHelper.getProgram();
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        int unitSize = space.getAddressableUnitSize();
        if (unitSize != 1) {
            return unitSize;
        }
        return elfLoadHelper.getElfHeader().is64Bit() ? 8 : 4;
    }

    public AddressSpace getPreferredSectionAddressSpace(ElfLoadHelper elfLoadHelper, ElfSectionHeader elfSectionHeader) {
        Program program = elfLoadHelper.getProgram();
        if (elfSectionHeader.isExecutable()) {
            return program.getAddressFactory().getDefaultAddressSpace();
        }
        return program.getLanguage().getDefaultDataSpace();
    }

    public Address getPreferredSectionAddress(ElfLoadHelper elfLoadHelper, ElfSectionHeader elfSectionHeader) {
        Program program = elfLoadHelper.getProgram();
        AddressSpace space = this.getPreferredSectionAddressSpace(elfLoadHelper, elfSectionHeader);
        long addrWordOffset = elfSectionHeader.getAddress();
        if (space == program.getAddressFactory().getDefaultAddressSpace()) {
            addrWordOffset += elfLoadHelper.getImageBaseWordAdjustmentOffset();
        }
        return space.getTruncatedAddress(addrWordOffset, true);
    }

    public boolean canHandle(ElfHeader elf) {
        return false;
    }

    public boolean canHandle(ElfLoadHelper elfLoadHelper) {
        return false;
    }

    public String getDataTypeSuffix() {
        return null;
    }

    public long getAdjustedMemoryOffset(long elfOffset, AddressSpace space) {
        return elfOffset;
    }

    public void processElf(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
    }

    public void processGotPlt(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
        ElfDefaultGotPltMarkup gotPltMarkup = new ElfDefaultGotPltMarkup(elfLoadHelper);
        gotPltMarkup.process(monitor);
    }

    public Address creatingFunction(ElfLoadHelper elfLoadHelper, Address functionAddress) {
        return functionAddress;
    }

    public Address calculateSymbolAddress(ElfLoadHelper elfLoadHelper, ElfSymbol elfSymbol) throws NoValueException {
        return null;
    }

    public Address evaluateElfSymbol(ElfLoadHelper elfLoadHelper, ElfSymbol elfSymbol, Address address, boolean isExternal) {
        return address;
    }

    public Boolean isSegmentWritable(ElfProgramHeader segment) {
        return (segment.getFlags() & 2) != 0;
    }

    public Boolean isSegmentReadable(ElfProgramHeader segment) {
        return (segment.getFlags() & 4) != 0;
    }

    public Boolean isSegmentExecutable(ElfProgramHeader segment) {
        return (segment.getFlags() & 1) != 0;
    }

    public Boolean isSectionWritable(ElfSectionHeader section) {
        return (section.getFlags() & 1L) != 0L;
    }

    public Boolean isSectionExecutable(ElfSectionHeader section) {
        return (section.getFlags() & 4L) != 0L;
    }

    public Boolean isSectionAllocated(ElfSectionHeader section) {
        return (section.getFlags() & 2L) != 0L;
    }

    public long getAdjustedLoadSize(ElfProgramHeader elfProgramHeader) {
        return elfProgramHeader.getFileSize();
    }

    public long getAdjustedMemorySize(ElfProgramHeader elfProgramHeader) {
        return elfProgramHeader.getMemorySize();
    }

    public int getLinkageBlockAlignment() {
        return 4096;
    }

    public int getPreferredExternalBlockSize() {
        return 131072;
    }

    public int getExternalBlockReserveSize() {
        return 65536;
    }

    public long getAdjustedSize(ElfSectionHeader section) {
        return section.getSize();
    }

    public InputStream getFilteredLoadInputStream(ElfLoadHelper elfLoadHelper, MemoryLoadable loadable, Address start, long dataLength, InputStream dataInput) {
        return dataInput;
    }

    public boolean hasFilteredLoadInputStream(ElfLoadHelper elfLoadHelper, MemoryLoadable loadable, Address start) {
        return false;
    }

    public Class<? extends ElfRelocation> getRelocationClass(ElfHeader elfHeader) {
        return null;
    }
}

