/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.dnd.GClipboard;
import ghidra.app.cmd.module.CreateFolderCommand;
import ghidra.app.cmd.module.CreateFragmentCmd;
import ghidra.app.cmd.module.MergeFolderCmd;
import ghidra.app.plugin.core.programtree.PasteManager;
import ghidra.app.plugin.core.programtree.ProgramDnDTree;
import ghidra.app.plugin.core.programtree.ProgramNode;
import ghidra.app.plugin.core.programtree.ProgramTreeAction;
import ghidra.app.plugin.core.programtree.ProgramTreePlugin;
import ghidra.app.plugin.core.programtree.TreeTransferable;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.NotEmptyException;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

class ProgramTreeActionManager
implements ClipboardOwner {
    private Clipboard tempClipboard;
    private ProgramDnDTree tree;
    private ProgramNode root;
    private Program program;
    private DockingAction cutAction;
    private DockingAction copyAction;
    private DockingAction pasteAction;
    private DockingAction createFolderAction;
    private DockingAction createFragmentAction;
    private DockingAction mergeAction;
    private DockingAction deleteAction;
    private DockingAction expandAction;
    private DockingAction renameAction;
    private DockingAction collapseAction;
    private DockingAction goToViewAction;
    private DockingAction removeViewAction;
    private DockingAction replaceViewAction;
    private DockingAction[] actions;
    private PasteManager pasteMgr;
    private ArrayList<TreePath> viewList;
    private SelectionListener selectionListener;
    private ProgramTreePlugin plugin;
    private boolean replacingView;

    ProgramTreeActionManager(ProgramTreePlugin plugin) {
        this.plugin = plugin;
        this.tempClipboard = new Clipboard("ProgramTree");
        this.selectionListener = new SelectionListener();
        this.pasteMgr = new PasteManager(this);
        this.createActions(plugin.getName());
    }

    void setProgramTreeView(String treeName, ProgramDnDTree tree) {
        if (this.tree != null) {
            this.tree.removeTreeSelectionListener(this.selectionListener);
        }
        this.tree = tree;
        this.pasteMgr.setProgramTreeView(tree);
        if (tree != null) {
            DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
            this.root = (ProgramNode)treeModel.getRoot();
            this.viewList = tree.getViewList();
            tree.addTreeSelectionListener(this.selectionListener);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.checkClipboard(false);
    }

    void setProgram(Program program) {
        this.program = program;
        this.tempClipboard.setContents(null, this);
        if (this.viewList != null) {
            this.viewList.clear();
        }
    }

    String getLastGroupPasted() {
        return this.pasteMgr.getLastGroupPasted();
    }

    boolean actionsCreated() {
        return this.cutAction != null;
    }

    DockingAction[] getActions() {
        return this.actions;
    }

    void adjustSingleActions(ProgramNode node) {
        if (this.program == null) {
            this.disableActions();
            return;
        }
        try {
            TreePath path = node.getTreePath();
            this.pasteAction.setEnabled(this.isPasteOk(node));
            this.renameAction.setEnabled(true);
            this.goToViewAction.setEnabled(true);
            this.replaceViewAction.setEnabled(true);
            this.removeViewAction.setEnabled(true);
            if (node == this.root) {
                this.copyAction.setEnabled(false);
                this.cutAction.setEnabled(false);
                this.deleteAction.setEnabled(false);
                this.expandAction.setEnabled(!this.allPathsExpanded(path));
                this.collapseAction.setEnabled(!this.allPathsCollapsed(path));
                this.createFolderAction.setEnabled(true);
                this.createFragmentAction.setEnabled(true);
                this.mergeAction.setEnabled(false);
                return;
            }
            this.copyAction.setEnabled(true);
            this.cutAction.setEnabled(true);
            this.setDeleteActionEnabled();
            if (node.isFragment()) {
                this.createFolderAction.setEnabled(false);
                this.createFragmentAction.setEnabled(false);
                this.expandAction.setEnabled(false);
                this.mergeAction.setEnabled(false);
                this.collapseAction.setEnabled(false);
            } else {
                this.createFolderAction.setEnabled(true);
                this.createFragmentAction.setEnabled(true);
                this.expandAction.setEnabled(!this.allPathsExpanded(path));
                this.mergeAction.setEnabled(true);
                this.collapseAction.setEnabled(!this.allPathsCollapsed(path));
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    void adjustMultiActions() {
        this.cutAction.setEnabled(false);
        this.copyAction.setEnabled(false);
        this.deleteAction.setEnabled(false);
        this.replaceViewAction.setEnabled(false);
        try {
            if (this.validMultiSelection()) {
                this.copyAction.setEnabled(true);
                this.cutAction.setEnabled(true);
                this.setDeleteActionEnabled();
                this.replaceViewAction.setEnabled(true);
                this.enableViewActions();
            }
            this.enableMergeAction();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    void disableActions() {
        this.goToViewAction.setEnabled(false);
        this.removeViewAction.setEnabled(false);
        this.replaceViewAction.setEnabled(false);
        this.cutAction.setEnabled(false);
        this.copyAction.setEnabled(false);
        this.pasteAction.setEnabled(false);
        this.deleteAction.setEnabled(false);
        this.renameAction.setEnabled(false);
        this.expandAction.setEnabled(false);
        this.collapseAction.setEnabled(false);
        this.createFolderAction.setEnabled(false);
        this.createFragmentAction.setEnabled(false);
        this.mergeAction.setEnabled(false);
    }

    private void createActions(String owner) {
        ArrayList<DockingAction> list = new ArrayList<DockingAction>();
        this.goToViewAction = new ProgramTreeAction("Go To start of folder/fragment in View", owner, new String[]{"Go To in View"}, KeyStroke.getKeyStroke(71, 2)){

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.addToView();
            }
        };
        this.goToViewAction.setEnabled(false);
        this.goToViewAction.setPopupMenuData(new MenuData(new String[]{"Go To in View"}, null, "aview"));
        list.add(this.goToViewAction);
        this.removeViewAction = new ProgramTreeAction("Remove folder/fragment from View", owner, new String[]{"Remove From View"}, KeyStroke.getKeyStroke(88, 2)){

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.removeFromView();
            }
        };
        this.removeViewAction.setEnabled(false);
        this.removeViewAction.setPopupMenuData(new MenuData(new String[]{"Remove from View"}, null, "aview"));
        list.add(this.removeViewAction);
        this.replaceViewAction = new ProgramTreeAction("Replace View", owner, new String[]{"Replace View"}, KeyStroke.getKeyStroke(82, 2)){

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.replaceView();
            }
        };
        this.replaceViewAction.setEnabled(false);
        this.replaceViewAction.setPopupMenuData(new MenuData(new String[]{"Replace View"}, null, "aview"));
        list.add(this.replaceViewAction);
        this.cutAction = new ProgramTreeAction("Cut folder/fragment", owner, new String[]{"Cut"}, null){

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.cut();
            }
        };
        this.cutAction.setEnabled(false);
        this.cutAction.setPopupMenuData(new MenuData(new String[]{"Cut"}, null, "edit"));
        list.add(this.cutAction);
        this.copyAction = new ProgramTreeAction("Copy folder/fragment", owner, new String[]{"Copy"}, null){

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.copy();
            }
        };
        this.copyAction.setEnabled(false);
        this.copyAction.setPopupMenuData(new MenuData(new String[]{"Copy"}, null, "edit"));
        list.add(this.copyAction);
        this.pasteAction = new ProgramTreeAction("Paste folder/fragment", owner, new String[]{"Paste"}, null, 0){

            public void actionPerformed(ActionContext context) {
                TreePath path = ProgramTreeActionManager.this.tree.getSelectionPath();
                ProgramNode node = (ProgramNode)path.getLastPathComponent();
                ProgramTreeActionManager.this.pasteMgr.paste(node);
            }
        };
        this.pasteAction.setEnabled(false);
        this.pasteAction.setPopupMenuData(new MenuData(new String[]{"Paste"}, null, "edit"));
        list.add(this.pasteAction);
        this.createFolderAction = new ProgramTreeAction("Create Folder", owner, new String[]{"Create Folder"}, null, 0){

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.createFolder();
            }
        };
        this.createFolderAction.setEnabled(false);
        this.createFolderAction.setPopupMenuData(new MenuData(new String[]{"Create Folder"}, null, "createGroup"));
        list.add(this.createFolderAction);
        this.createFragmentAction = new ProgramTreeAction("Create Fragment", owner, new String[]{"Create Fragment"}, null, 0){

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.createFragment((ProgramNode)ProgramTreeActionManager.this.tree.getLastSelectedPathComponent());
            }
        };
        this.createFragmentAction.setEnabled(false);
        this.createFragmentAction.setPopupMenuData(new MenuData(new String[]{"Create Fragment"}, null, "createGroup"));
        list.add(this.createFragmentAction);
        this.mergeAction = new ProgramTreeAction("Merge folder/fragment with Parent", owner, new String[]{"Merge with Parent"}, null, 0){

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.merge();
            }
        };
        this.mergeAction.setEnabled(false);
        this.mergeAction.setPopupMenuData(new MenuData(new String[]{"Merge with Parent"}, null, "merge"));
        list.add(this.mergeAction);
        this.deleteAction = new ProgramTreeAction("Delete folder/fragment", owner, new String[]{"Delete"}, null){

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.delete();
            }
        };
        this.deleteAction.setEnabled(false);
        this.deleteAction.setPopupMenuData(new MenuData(new String[]{"Delete"}, null, "delete"));
        this.deleteAction.setKeyBindingData(new KeyBindingData(127, 0));
        list.add(this.deleteAction);
        this.renameAction = new ProgramTreeAction("Rename folder/fragment", owner, new String[]{"Rename"}, null, 0){

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.tree.rename();
            }
        };
        this.renameAction.setEnabled(false);
        this.renameAction.setPopupMenuData(new MenuData(new String[]{"Rename"}, null, "delete"));
        list.add(this.renameAction);
        this.expandAction = new ProgramTreeAction("Expand All folders/fragments", owner, new String[]{"Expand ALL"}, null, 0){

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.expand();
            }
        };
        this.expandAction.setEnabled(false);
        this.expandAction.setPopupMenuData(new MenuData(new String[]{"Expand All"}, null, "expand"));
        list.add(this.expandAction);
        this.collapseAction = new ProgramTreeAction("Collapse All folders/fragments", owner, new String[]{"Collapse ALL"}, null, 0){

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.collapse();
            }
        };
        this.collapseAction.setEnabled(false);
        this.collapseAction.setPopupMenuData(new MenuData(new String[]{"Collapse All"}, null, "expand"));
        list.add(this.collapseAction);
        this.actions = new DockingAction[list.size()];
        this.actions = list.toArray(this.actions);
    }

    Clipboard getCutClipboard() {
        return this.tempClipboard;
    }

    void removeFromClipboard(Clipboard clipboard, ProgramNode node) {
        try {
            List<ProgramNode> list = this.getProgramNodeListFromClipboard();
            int listSize = 0;
            if (list != null) {
                listSize = list.size();
                list.remove(node);
            }
            node.setDeleted(false);
            this.tree.reloadNode(node);
            if (listSize == 0) {
                if (clipboard == GClipboard.getSystemClipboard()) {
                    this.doClearSystemClipboard(clipboard);
                } else {
                    clipboard.setContents(null, this);
                }
            }
        }
        catch (UnsupportedFlavorException e) {
            Msg.showError((Object)this, null, (String)("Cut from Clipboard " + clipboard.getName() + " Failed"), (Object)"Data flavor in clipboard is not supported.", (Throwable)e);
        }
        catch (IOException e) {
            Msg.showError((Object)this, null, (String)("Cut from Clipboard " + clipboard.getName() + " Failed"), (Object)"Data is no longer available for paste operation", (Throwable)e);
        }
        catch (Exception e) {
            String message = e.getMessage();
            Msg.showError((Object)this, null, (String)("Cut from Clipboard " + clipboard.getName() + " Failed"), (Object)(message == null ? e.getClass().getSimpleName() : message), (Throwable)e);
        }
    }

    void enablePasteAction(boolean enabled) {
        this.pasteAction.setEnabled(enabled);
    }

    boolean clipboardContains(ProgramNode node) {
        try {
            List<ProgramNode> list = this.getProgramNodeListFromClipboard();
            if (list == null) {
                return false;
            }
            return list.contains(node);
        }
        catch (UnsupportedFlavorException e) {
            throw new AssertException("Data flavor in clipboard is not supported.");
        }
        catch (IOException e) {
            Msg.showError((Object)this, null, (String)"Clipboard Check Failed", (Object)"Data is no longer available for paste operation", (Throwable)e);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private List<ProgramNode> getProgramNodeListFromClipboard() throws UnsupportedFlavorException, IOException {
        List<ProgramNode> nodeList = Collections.emptyList();
        Transferable t = this.tempClipboard.getContents(this);
        if (t == null) {
            return nodeList;
        }
        if (!t.isDataFlavorSupported(TreeTransferable.localTreeNodeFlavor)) {
            return nodeList;
        }
        List list = (List)t.getTransferData(TreeTransferable.localTreeNodeFlavor);
        return list;
    }

    void checkClipboard(boolean applyCutChanges) {
        try {
            List<ProgramNode> list = this.getProgramNodeListFromClipboard();
            if (list == null) {
                return;
            }
            for (ProgramNode node : list) {
                if (this.tree.getModel().getRoot() == node.getRoot()) {
                    if (applyCutChanges) {
                        ProgramModule parentModule = node.getParentModule();
                        Group group = node.getGroup();
                        try {
                            parentModule.removeChild(group.getName());
                        }
                        catch (NotEmptyException e) {
                            node.setDeleted(false);
                            this.tree.reloadNode(node);
                        }
                        catch (ConcurrentModificationException concurrentModificationException) {}
                        continue;
                    }
                    try {
                        Group g = node.getGroup();
                        g.getName();
                        node.setDeleted(false);
                        this.tree.reloadNode(node);
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {}
                    continue;
                }
                break;
            }
        }
        catch (UnsupportedFlavorException e) {
            throw new AssertException("Data flavor in clipboard is not supported.");
        }
        catch (IOException e) {
            Msg.showError((Object)this, null, (String)"Cut from Clipboard Failed", (Object)"Data is no longer available for paste operation", (Throwable)e);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.tempClipboard.setContents(null, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void clearSystemClipboard() {
        try {
            Clipboard systemClipboard = GClipboard.getSystemClipboard();
            if (!systemClipboard.isDataFlavorAvailable(TreeTransferable.localTreeNodeFlavor)) {
                return;
            }
            Object data = systemClipboard.getData(TreeTransferable.localTreeNodeFlavor);
            if (data == null) {
                return;
            }
            this.doClearSystemClipboard(systemClipboard);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doClearSystemClipboard(Clipboard systemClipboard) {
        TreeTransferable dummyContents = new TreeTransferable(new ProgramNode[0]);
        systemClipboard.setContents(dummyContents, (clipboard, contents) -> {});
    }

    boolean isReplacingView() {
        return this.replacingView;
    }

    private boolean validMultiSelection() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths == null) {
            return false;
        }
        TreePath rootPath = this.root.getTreePath();
        for (TreePath element : paths) {
            if (!element.equals(rootPath)) continue;
            return false;
        }
        for (TreePath path : paths) {
            ProgramNode node = (ProgramNode)path.getLastPathComponent();
            if (!node.getAllowsChildren() || this.validPathSelection(node, paths)) continue;
            return false;
        }
        return true;
    }

    private void enableViewActions() {
        this.goToViewAction.setEnabled(true);
        this.removeViewAction.setEnabled(true);
    }

    private boolean validPathSelection(ProgramNode node, TreePath[] selectedPaths) {
        int nchild = node.getChildCount();
        int numberSelected = 0;
        block0: for (int i = 0; i < nchild; ++i) {
            ProgramNode child = (ProgramNode)node.getChildAt(i);
            TreePath childPath = child.getTreePath();
            for (TreePath element : selectedPaths) {
                if (!childPath.equals(element)) continue;
                ++numberSelected;
                continue block0;
            }
        }
        return numberSelected == 0 || numberSelected == nchild;
    }

    private void addToView() {
        TreePath[] paths;
        TreePath path = this.tree.getSelectionPath();
        if (this.tree.getSelectionCount() > 1) {
            path = this.tree.getLeadSelectionPath();
        }
        for (TreePath element : paths = this.tree.getSelectionPaths()) {
            this.updateViewList(element);
        }
        ProgramNode node = (ProgramNode)path.getLastPathComponent();
        ProgramFragment f = node.getFragment();
        Address addr = null;
        if (f != null && !f.isEmpty()) {
            addr = f.getMinAddress();
        } else if (f == null) {
            ProgramModule module = node.getModule();
            addr = module.getFirstAddress();
        }
        this.tree.fireTreeViewChanged();
        if (addr != null) {
            this.tree.goTo(addr);
        }
    }

    private void removeFromView() {
        if (this.tree.getSelectionCount() == 1) {
            TreePath path = this.tree.getSelectionPath();
            if (this.viewList.contains(path)) {
                this.removePathFromView(path, true);
            } else {
                this.removeChildFromView((ProgramNode)path.getLastPathComponent());
                this.tree.fireTreeViewChanged();
            }
        } else {
            this.removeRangeFromView();
        }
    }

    private void removePathFromView(TreePath path, boolean fireEvent) {
        if (this.viewList.contains(path)) {
            this.tree.removeFromView(path);
            if (fireEvent) {
                this.tree.fireTreeViewChanged();
            }
        }
    }

    private void removeChildFromView(ProgramNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            ProgramNode child = (ProgramNode)node.getChildAt(i);
            if (child.getAllowsChildren()) {
                this.removeChildFromView(child);
                continue;
            }
            this.removePathFromView(child.getTreePath(), false);
        }
    }

    private void replaceView() {
        this.replacingView = true;
        try {
            this.tree.setViewPaths(this.tree.getSelectionPaths());
        }
        finally {
            this.replacingView = false;
        }
    }

    private void cut() {
        this.checkClipboard(false);
        if (this.tree.getSelectionCount() == 1) {
            TreePath[] paths = new TreePath[]{this.tree.getSelectionPath()};
            this.setClipboardContents(GClipboard.getSystemClipboard(), paths);
            this.setClipboardContents(this.tempClipboard, paths);
            this.setNodesDeleted(paths);
        } else {
            this.cutRange();
        }
    }

    private void copy() {
        this.checkClipboard(false);
        if (this.tree.getSelectionCount() == 1) {
            this.setClipboardContents(GClipboard.getSystemClipboard(), new TreePath[]{this.tree.getSelectionPath()});
        } else {
            this.copyRange();
        }
    }

    private void setNodesDeleted(TreePath[] paths) {
        for (TreePath element : paths) {
            ProgramNode node = (ProgramNode)element.getLastPathComponent();
            node.setDeleted(true);
            this.tree.reloadNode(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete() {
        int transactionID = this.tree.startTransaction("Delete");
        if (transactionID < 0) {
            return;
        }
        boolean success = false;
        try {
            ProgramNode programNode = this.root;
            synchronized (programNode) {
                try {
                    success = this.deleteRange();
                }
                catch (Exception e) {
                    Msg.showError((Object)this, null, null, null, (Throwable)e);
                }
            }
        }
        finally {
            this.tree.endTransaction(transactionID, success);
        }
    }

    private void expand() {
        TreePath path = this.tree.getLeadSelectionPath();
        this.tree.expandNode((ProgramNode)this.tree.getLastSelectedPathComponent());
        this.expandAction.setEnabled(!this.allPathsExpanded(path));
        this.collapseAction.setEnabled(!this.allPathsCollapsed(path));
    }

    private void collapse() {
        TreePath path = this.tree.getLeadSelectionPath();
        this.collapseNode((ProgramNode)this.tree.getLastSelectedPathComponent());
        this.expandAction.setEnabled(!this.allPathsExpanded(path));
        this.collapseAction.setEnabled(!this.allPathsCollapsed(path));
    }

    private void collapseNode(ProgramNode node) {
        int nchild = node.getChildCount();
        for (int i = 0; i < nchild; ++i) {
            ProgramNode child = (ProgramNode)node.getChildAt(i);
            if (child.equals(node) || child.isLeaf()) continue;
            this.collapseNode(child);
        }
        this.tree.collapsePath(node.getTreePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void merge() {
        ProgramNode programNode = this.root;
        synchronized (programNode) {
            ArrayList<ProgramNode> list = this.tree.getSortedSelection();
            CompoundCmd compCmd = new CompoundCmd("Merge with Parent");
            String treeName = this.tree.getTreeName();
            for (ProgramNode node : list) {
                this.tree.removeSelectionPath(node.getTreePath());
                ProgramNode parentNode = (ProgramNode)node.getParent();
                if (!node.isModule() || parentNode == null) continue;
                compCmd.add((Command)new MergeFolderCmd(treeName, node.getName(), parentNode.getName()));
            }
            if (!this.plugin.getTool().execute((Command)compCmd, (DomainObject)this.program)) {
                this.plugin.getTool().setStatusInfo(compCmd.getStatusMsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFragment(ProgramNode node) {
        ProgramNode programNode = this.root;
        synchronized (programNode) {
            String errMsg = null;
            Program program = this.program;
            synchronized (program) {
                String name = this.tree.getNewFragmentName();
                String treeName = this.tree.getTreeName();
                CreateFragmentCmd cmd = new CreateFragmentCmd(treeName, name, node.getName());
                if (this.tree.getTool().execute((Command)cmd, (DomainObject)this.program)) {
                    ProgramFragment f = this.program.getListing().getFragment(treeName, name);
                    this.initiateCellEditor(node, (Group)f);
                } else {
                    errMsg = cmd.getStatusMsg();
                }
            }
            if (errMsg != null) {
                Msg.showError((Object)this, (Component)this.tree, (String)"Create Fragment Failed", (Object)errMsg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFolder() {
        String errorMsg = null;
        ProgramNode programNode = this.root;
        synchronized (programNode) {
            Program program = this.program;
            synchronized (program) {
                ProgramNode node = (ProgramNode)this.tree.getLastSelectedPathComponent();
                node.visit();
                String name = this.tree.getNewFolderName();
                String treeName = this.tree.getTreeName();
                CreateFolderCommand cmd = new CreateFolderCommand(treeName, name, node.getName());
                if (this.tree.getTool().execute((Command)cmd, (DomainObject)this.program)) {
                    ProgramModule m = this.program.getListing().getModule(treeName, name);
                    this.initiateCellEditor(node, (Group)m);
                } else {
                    errorMsg = cmd.getStatusMsg();
                }
            }
        }
        if (errorMsg != null) {
            Msg.showError((Object)this, (Component)this.tree, (String)"Create Folder Failed", (Object)errorMsg);
        }
    }

    private void initiateCellEditor(ProgramNode parent, Group group) {
        if (!parent.wasVisited()) {
            this.tree.visitNode(parent);
        }
        int nchild = parent.getChildCount();
        for (int i = 0; i < nchild; ++i) {
            ProgramNode child = (ProgramNode)parent.getChildAt(i);
            if (child.getGroup() != group) continue;
            this.tree.setEditable(true);
            this.tree.startEditingAtPath(child.getTreePath());
            break;
        }
    }

    private void cutRange() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths.length == 0) {
            return;
        }
        this.setClipboardContents(GClipboard.getSystemClipboard(), paths);
        this.setClipboardContents(this.tempClipboard, paths);
        this.setNodesDeleted(paths);
    }

    private void copyRange() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths.length == 0) {
            return;
        }
        this.setClipboardContents(GClipboard.getSystemClipboard(), paths);
    }

    private boolean deleteRange() {
        TreePath[] paths = this.tree.getSelectionPaths();
        boolean changesMade = false;
        StringBuffer sb = new StringBuffer();
        for (TreePath element : paths) {
            ProgramNode node = (ProgramNode)element.getLastPathComponent();
            if (!this.tree.removeGroup(node, sb)) continue;
            changesMade = true;
        }
        if (sb.length() > 0) {
            sb.insert(0, "Failed to delete the following:\n");
            Msg.showWarn(this.getClass(), (Component)this.tree, (String)"Delete Failed", (Object)sb.toString());
        }
        return changesMade;
    }

    private void removeRangeFromView() {
        TreePath[] selPaths;
        for (TreePath element : selPaths = this.tree.getSelectionPaths()) {
            this.tree.removeFromView(element);
        }
        if (selPaths.length > 0) {
            this.tree.fireTreeViewChanged();
        }
    }

    private void setClipboardContents(Clipboard clipboard, TreePath[] paths) {
        ProgramNode[] nodes = new ProgramNode[paths.length];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = (ProgramNode)paths[i].getLastPathComponent();
        }
        TreeTransferable contents = new TreeTransferable(nodes);
        clipboard.setContents(contents, this);
    }

    private boolean allPathsExpanded(TreePath path) {
        ProgramNode node = (ProgramNode)path.getLastPathComponent();
        if (node.isLeaf()) {
            return true;
        }
        if (this.tree.isCollapsed(path)) {
            return false;
        }
        boolean allLeaves = true;
        int nchild = node.getChildCount();
        for (int i = 0; i < nchild; ++i) {
            ProgramNode child = (ProgramNode)node.getChildAt(i);
            if (child.isLeaf()) continue;
            allLeaves = false;
            if (!this.tree.isExpanded(child.getTreePath())) {
                return false;
            }
            if (this.allPathsExpanded(child.getTreePath())) continue;
            return false;
        }
        if (allLeaves) {
            return this.tree.isExpanded(node.getTreePath());
        }
        return true;
    }

    private boolean allPathsCollapsed(TreePath path) {
        ProgramNode node = (ProgramNode)path.getLastPathComponent();
        if (this.tree.isExpanded(path)) {
            return false;
        }
        boolean allLeaves = true;
        int nchild = node.getChildCount();
        for (int i = 0; i < nchild; ++i) {
            ProgramNode child = (ProgramNode)node.getChildAt(i);
            if (child.isLeaf()) continue;
            allLeaves = false;
            if (!this.tree.isCollapsed(child.getTreePath())) {
                return false;
            }
            if (this.allPathsCollapsed(child.getTreePath())) continue;
            return false;
        }
        if (allLeaves) {
            return this.tree.isCollapsed(node.getTreePath());
        }
        return true;
    }

    private boolean isPasteOk(ProgramNode destNode) {
        boolean isCutOperation = false;
        Clipboard systemClipboard = GClipboard.getSystemClipboard();
        if (!systemClipboard.isDataFlavorAvailable(TreeTransferable.localTreeNodeFlavor)) {
            return false;
        }
        try {
            Transferable temp = this.tempClipboard.getContents(this);
            isCutOperation = temp != null;
        }
        catch (Exception e) {
            return false;
        }
        try {
            List list = (List)systemClipboard.getData(TreeTransferable.localTreeNodeFlavor);
            if (list == null) {
                return false;
            }
            boolean pasteEnabled = false;
            for (ProgramNode pasteNode : list) {
                boolean pasteAllowed = this.pasteMgr.isPasteAllowed(destNode, pasteNode, isCutOperation);
                if (isCutOperation && !pasteAllowed) {
                    return false;
                }
                if (!isCutOperation && pasteAllowed) {
                    return true;
                }
                pasteEnabled |= pasteAllowed;
            }
            return pasteEnabled;
        }
        catch (UnsupportedFlavorException e) {
            throw new AssertException("Data flavor in clipboard is not supported.");
        }
        catch (IOException e) {
            Msg.showError((Object)this, null, (String)"Cut from Clipboard Failed", (Object)"Data is no longer available for paste operation", (Throwable)e);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            Msg.showError((Object)this, null, (String)"Check Clipboard Failed", (Object)msg, (Throwable)e);
        }
        return false;
    }

    private void updateViewList(TreePath path) {
        ProgramNode node = (ProgramNode)path.getLastPathComponent();
        if (!this.tree.hasAncestorsInView(node) && !this.viewList.contains(path)) {
            for (int i = 0; i < this.viewList.size(); ++i) {
                TreePath viewPath = this.viewList.get(i);
                if (!path.isDescendant(viewPath)) continue;
                this.tree.removeFromView(viewPath);
                --i;
            }
            this.tree.addToView(path);
        }
    }

    private void selectionChanged() {
        int count = this.tree.getSelectionCount();
        this.disableActions();
        if (count == 1) {
            this.adjustSingleActions((ProgramNode)this.tree.getSelectionPath().getLastPathComponent());
        } else if (this.validMultiSelection()) {
            this.copyAction.setEnabled(true);
            this.cutAction.setEnabled(true);
            this.deleteAction.setEnabled(true);
            this.replaceViewAction.setEnabled(true);
            this.enableViewActions();
        }
        this.enableMergeAction();
    }

    private void setDeleteActionEnabled() {
        TreePath[] paths;
        this.deleteAction.setEnabled(false);
        for (TreePath element : paths = this.tree.getSelectionPaths()) {
            ProgramNode node = (ProgramNode)element.getLastPathComponent();
            if (node.isFragment()) {
                ProgramFragment f = node.getFragment();
                if (!f.isEmpty() && (f.isEmpty() || node.getFragment().getNumParents() <= 1)) continue;
                this.deleteAction.setEnabled(true);
                break;
            }
            ProgramModule m = node.getModule();
            if (m.getNumChildren() != 0 && m.getNumParents() <= 1) continue;
            this.deleteAction.setEnabled(true);
            break;
        }
    }

    private void enableMergeAction() {
        this.mergeAction.setEnabled(false);
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        for (TreePath element : paths) {
            ProgramNode node = (ProgramNode)element.getLastPathComponent();
            if (!node.isModule()) continue;
            this.mergeAction.setEnabled(true);
            return;
        }
    }

    private class SelectionListener
    implements TreeSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (ProgramTreeActionManager.this.program == null) {
                return;
            }
            ProgramTreeActionManager.this.selectionChanged();
        }
    }
}

