/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import ghidra.app.plugin.core.programtree.DragNDropTree;
import ghidra.app.plugin.core.programtree.ProgramNode;
import ghidra.program.model.listing.Group;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import resources.ResourceManager;

class DnDTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final String DOCS = "images/openBookBlue.png";
    private static final String DISABLED_DOCS = "DisabledDocument.gif";
    static final String FRAGMENT = "images/codeNotInView.gif";
    private static final String EMPTY_FRAGMENT = "images/emptyFragment.gif";
    private static final String DISABLED_FRAGMENT = "DisabledFragment";
    private static final String DISABLED_VIEWED_FRAGMENT = "DisabledViewedFragment";
    private static final String DISABLED_EMPTY_FRAGMENT = "DisabledEmptyFragment";
    private static final String DISABLED_VIEWED_EMPTY_FRAGMENT = "DisabledViewedEmptyFragment";
    private static final String DISABLED_VIEWED_OPEN_FOLDER = "DisabledViewedOpenFolder";
    private static final String DISABLED_VIEWED_CLOSED_FOLDER = "DisabledViewedClosedFolder";
    private static final String DISABLED_VIEWED_CLOSED_FOLDER_WITH_DESC = "DisabledViewedClosedFolderWithDescendants";
    private static final String DISABLED_CLOSED_FOLDER = "DisabledClosedFolder";
    private static final String DISABLED_OPEN_FOLDER = "DisabledOpenedFolder";
    static final String VIEWED_FRAGMENT = "images/codeInView.gif";
    static final String VIEWED_EMPTY_FRAGMENT = "images/emptyFragmentInView.gif";
    static final String VIEWED_CLOSED_FOLDER = "images/closedFolderInView.png";
    static final String VIEWED_OPEN_FOLDER = "images/openFolderInView.png";
    static final String VIEWED_CLOSED_FOLDER_WITH_DESC = "images/closedDescendantsInView.png";
    static final String CLOSED_FOLDER = "images/closedFolder.png";
    static final String OPEN_FOLDER = "images/openFolder.png";
    private Map<String, Icon> iconMap;
    private Color defaultSelectionColor;
    private Color defaultNonSelectionColor = this.getBackgroundNonSelectionColor();
    private Color selectionForDragColor;
    private Color nonSelectionForDragColor;
    private int rowForFeedback = -1;

    DnDTreeCellRenderer() {
        this.defaultSelectionColor = this.getBackgroundSelectionColor();
        this.setHTMLRenderingEnabled(false);
        this.loadImages();
    }

    public void setHTMLRenderingEnabled(boolean enable) {
        this.putClientProperty("html.disable", !enable);
    }

    void setSelectionForDrag(Color color) {
        this.selectionForDragColor = color;
    }

    void setNonSelectionForDrag(Color color) {
        this.nonSelectionForDragColor = color;
    }

    void setRowForFeedback(int row) {
        this.rowForFeedback = row;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean isFocused) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, isFocused);
        ProgramNode node = (ProgramNode)value;
        Group group = node.getGroup();
        Icon icon = null;
        boolean isInView = node.isInView();
        icon = group == null && !node.isRoot() ? (node.isDeleted() ? this.iconMap.get(DISABLED_DOCS) : this.iconMap.get(DOCS)) : (node.isFragment() ? this.getFragmentIcon(node, isInView) : this.getFolderIcon(expanded, leaf, node, isInView));
        if (icon != null) {
            this.setIcon(icon);
        }
        this.setSelectionColors(sel, row, node, (DragNDropTree)tree);
        return this;
    }

    private void setSelectionColors(boolean selected, int row, ProgramNode node, DragNDropTree dtree) {
        if (dtree.getDrawFeedbackState()) {
            if (row == this.rowForFeedback) {
                if (!selected) {
                    this.setBackgroundNonSelectionColor(this.nonSelectionForDragColor);
                } else {
                    this.setBackgroundSelectionColor(this.selectionForDragColor);
                }
            } else {
                this.setBackgroundSelectionColor(this.defaultSelectionColor);
                this.setBackgroundNonSelectionColor(this.defaultNonSelectionColor);
            }
            this.setToolTipText(null);
        } else {
            this.setBackgroundSelectionColor(this.defaultSelectionColor);
            this.setBackgroundNonSelectionColor(this.defaultNonSelectionColor);
            this.setToolTipText(dtree.getToolTipText(node));
        }
    }

    private Icon getFolderIcon(boolean expanded, boolean leaf, ProgramNode node, boolean isInView) {
        Icon icon = null;
        icon = leaf && node.isRoot() ? (isInView ? this.iconMap.get(VIEWED_CLOSED_FOLDER) : this.iconMap.get(CLOSED_FOLDER)) : (leaf ? this.processLeafNode(node, isInView) : (node.isDeleted() ? this.processDeletedNode(expanded, node, isInView) : (expanded ? (isInView ? this.iconMap.get(VIEWED_OPEN_FOLDER) : this.iconMap.get(OPEN_FOLDER)) : (isInView ? this.iconMap.get(VIEWED_CLOSED_FOLDER) : (node.hasDescendantsInView() ? this.iconMap.get(VIEWED_CLOSED_FOLDER_WITH_DESC) : this.iconMap.get(CLOSED_FOLDER))))));
        return icon;
    }

    private Icon processDeletedNode(boolean expanded, ProgramNode node, boolean isInView) {
        Icon icon = null;
        icon = expanded ? (isInView ? this.iconMap.get(DISABLED_VIEWED_OPEN_FOLDER) : this.iconMap.get(DISABLED_OPEN_FOLDER)) : (isInView ? this.iconMap.get(DISABLED_VIEWED_CLOSED_FOLDER) : (node.hasDescendantsInView() ? this.iconMap.get(DISABLED_VIEWED_CLOSED_FOLDER_WITH_DESC) : this.iconMap.get(DISABLED_CLOSED_FOLDER)));
        return icon;
    }

    private Icon processLeafNode(ProgramNode node, boolean isInView) {
        Icon icon = null;
        icon = node.isDeleted() ? (isInView ? this.iconMap.get(DISABLED_VIEWED_CLOSED_FOLDER) : this.iconMap.get(DISABLED_VIEWED_CLOSED_FOLDER)) : (isInView ? this.iconMap.get(VIEWED_CLOSED_FOLDER) : this.iconMap.get(CLOSED_FOLDER));
        return icon;
    }

    private Icon getFragmentIcon(ProgramNode node, boolean isInView) {
        boolean isEmpty = false;
        try {
            isEmpty = node.getFragment().isEmpty();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        Icon icon = node.isDeleted() ? (isInView ? (isEmpty ? this.iconMap.get(DISABLED_VIEWED_EMPTY_FRAGMENT) : this.iconMap.get(DISABLED_VIEWED_FRAGMENT)) : (isEmpty ? this.iconMap.get(DISABLED_EMPTY_FRAGMENT) : this.iconMap.get(DISABLED_FRAGMENT))) : (node.isInView() ? (isEmpty ? this.iconMap.get(VIEWED_EMPTY_FRAGMENT) : this.iconMap.get(VIEWED_FRAGMENT)) : (isEmpty ? this.iconMap.get(EMPTY_FRAGMENT) : this.iconMap.get(FRAGMENT)));
        return icon;
    }

    private void loadImages() {
        this.iconMap = new HashMap<String, Icon>();
        String[] filenames = new String[]{DOCS, FRAGMENT, EMPTY_FRAGMENT, VIEWED_FRAGMENT, VIEWED_EMPTY_FRAGMENT, VIEWED_CLOSED_FOLDER, VIEWED_OPEN_FOLDER, VIEWED_CLOSED_FOLDER_WITH_DESC, CLOSED_FOLDER, OPEN_FOLDER};
        String[] disabledFilenames = new String[]{DISABLED_DOCS, DISABLED_FRAGMENT, DISABLED_EMPTY_FRAGMENT, DISABLED_VIEWED_EMPTY_FRAGMENT, DISABLED_VIEWED_FRAGMENT, DISABLED_VIEWED_CLOSED_FOLDER, DISABLED_VIEWED_OPEN_FOLDER, DISABLED_VIEWED_CLOSED_FOLDER_WITH_DESC, DISABLED_CLOSED_FOLDER, DISABLED_OPEN_FOLDER};
        for (int i = 0; i < filenames.length; ++i) {
            ImageIcon icon = ResourceManager.loadImage((String)filenames[i]);
            if (icon == null) continue;
            this.iconMap.put(filenames[i], icon);
            Icon disabledIcon = DnDTreeCellRenderer.getDisabledIcon(filenames[i], icon);
            this.iconMap.put(disabledFilenames[i], disabledIcon);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (dim != null) {
            return new Dimension(dim.width, dim.height + 2);
        }
        return dim;
    }

    static Icon getDisabledIcon(String imageName, ImageIcon icon) {
        Image cutImage = icon.getImage();
        BufferedImage bufferedImage = new BufferedImage(cutImage.getWidth(null), cutImage.getHeight(null), 2);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.drawImage(cutImage, 0, 0, null);
        g2d.setColor(new Color(255, 255, 255, 128));
        g2d.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        return ResourceManager.getImageIconFromImage((String)imageName, (Image)bufferedImage);
    }
}

