/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.widgets.table.GTableTextCellEditor;
import ghidra.app.plugin.core.compositeeditor.ComponentCellEditorListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

class ComponentCellEditor
extends GTableTextCellEditor {
    private KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            int keycode = e.getKeyCode();
            switch (keycode) {
                case 9: {
                    if (e.isShiftDown()) {
                        ComponentCellEditor.this.move(2);
                    } else {
                        ComponentCellEditor.this.move(1);
                    }
                    e.consume();
                    break;
                }
                case 40: {
                    ComponentCellEditor.this.move(4);
                    e.consume();
                    break;
                }
                case 38: {
                    ComponentCellEditor.this.move(3);
                    e.consume();
                    break;
                }
            }
        }
    };
    ComponentCellEditorListener listener;

    public ComponentCellEditor(JTextField field) {
        super(field);
        field.addKeyListener(this.keyListener);
    }

    private void move(int direction) {
        if (this.listener != null) {
            JTextField textField = (JTextField)this.getComponent();
            this.listener.moveCellEditor(direction, textField.getText());
        }
    }

    void setComponentCellEditorListener(ComponentCellEditorListener listener) {
        this.listener = listener;
    }

    void removeComponentCellEditorListener() {
        this.listener = null;
    }
}

