/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractSymbolInternals;

public class ThreadStorageSymbolInternals
extends AbstractSymbolInternals {
    protected RecordNumber typeRecordNumber;
    protected long offset;
    protected int segment;
    protected String name;

    public static ThreadStorageSymbolInternals parse32(PdbByteReader reader, AbstractPdb pdb) throws PdbException {
        ThreadStorageSymbolInternals result = new ThreadStorageSymbolInternals(pdb);
        result.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        result.offset = reader.parseVarSizedOffset(32);
        result.segment = pdb.parseSegment(reader);
        result.name = reader.parseString(pdb, StringParseType.StringUtf8Nt);
        reader.align4();
        return result;
    }

    public static ThreadStorageSymbolInternals parse3216(PdbByteReader reader, AbstractPdb pdb) throws PdbException {
        ThreadStorageSymbolInternals result = new ThreadStorageSymbolInternals(pdb);
        result.offset = reader.parseVarSizedOffset(32);
        result.segment = pdb.parseSegment(reader);
        result.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 16);
        result.name = reader.parseString(pdb, StringParseType.StringUtf8St);
        reader.align4();
        return result;
    }

    public static ThreadStorageSymbolInternals parse32St(PdbByteReader reader, AbstractPdb pdb) throws PdbException {
        ThreadStorageSymbolInternals result = new ThreadStorageSymbolInternals(pdb);
        result.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        result.offset = reader.parseVarSizedOffset(32);
        result.segment = pdb.parseSegment(reader);
        result.name = reader.parseString(pdb, StringParseType.StringUtf8St);
        reader.align4();
        return result;
    }

    public ThreadStorageSymbolInternals(AbstractPdb pdb) {
        super(pdb);
    }

    public long getOffset() {
        return this.offset;
    }

    public int getSegment() {
        return this.segment;
    }

    public RecordNumber getTypeRecordNumber() {
        return this.typeRecordNumber;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format(": [%04X:%08X], Type: %s, %s", this.segment, this.offset, this.pdb.getTypeRecord(this.typeRecordNumber), this.name));
    }
}

