/*
 * Decompiled with CFR 0.152.
 */
package ghidra.async;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class AsyncFence {
    private final ArrayList<CompletableFuture<?>> participants = new ArrayList();
    private CompletableFuture<Void> ready;

    public synchronized AsyncFence include(CompletableFuture<?> future) {
        if (this.ready != null) {
            throw new IllegalStateException("Fence already ready");
        }
        this.participants.add(future);
        return this;
    }

    public synchronized CompletableFuture<Void> ready() {
        if (this.ready == null) {
            this.ready = CompletableFuture.allOf(this.participants.toArray(new CompletableFuture[this.participants.size()]));
        }
        return this.ready;
    }

    public Set<CompletableFuture<?>> getPending() {
        return this.participants.stream().filter(f -> !f.isDone()).collect(Collectors.toSet());
    }
}

