/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.extension.datatype.finder;

import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTypeToken;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.extension.datatype.finder.DecompilerReference;
import ghidra.app.extension.datatype.finder.DecompilerVariable;
import ghidra.app.extension.datatype.finder.DecompilerVariableType;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferenceContext;
import ghidra.app.services.DataTypeReference;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Function;
import ghidra.util.exception.AssertException;
import java.util.List;

public abstract class VariableDR
extends DecompilerReference {
    protected DecompilerVariable declaration;

    protected VariableDR(ClangLine line, ClangTypeToken type) {
        super(line, (ClangToken)type);
        this.declaration = new DecompilerVariableType((ClangToken)type);
    }

    void setVariable(ClangVariableToken token) {
        this.variable = new DecompilerVariableType((ClangToken)token);
    }

    public DecompilerVariable getDeclaration() {
        return this.declaration;
    }

    @Override
    public DecompilerVariable getVariable() {
        return this.variable;
    }

    @Override
    public void accumulateMatches(DataType dt, String fieldName, List<DataTypeReference> results) {
        if (this.variable == null) {
            throw new AssertException("Decompiler variable declaration is missing a name");
        }
        DataType dataType = this.getDataType();
        if (!VariableDR.isEqual(dataType, dt)) {
            return;
        }
        LocationReferenceContext context = this.getContext();
        Function function = this.getFunction();
        Address address = this.getAddress();
        if (fieldName == null) {
            results.add(new DataTypeReference(dataType, null, this.getFunction(), address, context));
            return;
        }
        String name = this.variable.getName();
        if (name.equals(fieldName)) {
            results.add(new DataTypeReference(dataType, fieldName, function, address, context));
        }
    }
}

