/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.analyzer;

import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.android.cdex.CDexConstants;
import ghidra.file.formats.android.dex.analyzer.DexAnalysisState;
import ghidra.file.formats.android.dex.format.DexConstants;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.format.FieldIDItem;
import ghidra.file.formats.android.dex.format.FilledArrayDataPayload;
import ghidra.file.formats.android.dex.format.StringDataItem;
import ghidra.file.formats.android.dex.format.StringIDItem;
import ghidra.file.formats.android.dex.format.TypeIDItem;
import ghidra.file.formats.android.dex.util.DexUtil;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.task.TaskMonitor;
import java.util.List;
import java.util.StringTokenizer;

public class DexMarkupInstructionsAnalyzer
extends FileFormatAnalyzer {
    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMaximum(set == null ? program.getMemory().getSize() : set.getNumAddresses());
        monitor.setProgress(0L);
        DexAnalysisState analysisState = DexAnalysisState.getState(program);
        DexHeader header = analysisState.getHeader();
        MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), program.getMinAddress());
        BinaryReader reader = new BinaryReader((ByteProvider)provider, true);
        Listing listing = program.getListing();
        InstructionIterator instructionIterator = listing.getInstructions(set, true);
        while (instructionIterator.hasNext()) {
            Scalar scalar;
            Instruction instruction = instructionIterator.next();
            monitor.checkCanceled();
            monitor.incrementProgress(1L);
            monitor.setMessage("DEX: Instruction markup ... " + instruction.getMinAddress());
            String mnemonicString = instruction.getMnemonicString();
            if (mnemonicString.startsWith("invoke_super_quick") || mnemonicString.startsWith("invoke_virtual_quick") || mnemonicString.startsWith("invoke_object_init_range") || mnemonicString.indexOf("quick") > 0) continue;
            if (mnemonicString.startsWith("const_string")) {
                scalar = instruction.getScalar(1);
                this.processString(program, instruction, 1, header, (int)scalar.getUnsignedValue(), log);
                continue;
            }
            if (mnemonicString.equals("const_class")) {
                scalar = instruction.getScalar(1);
                this.processClass(program, instruction, 1, header, (int)scalar.getUnsignedValue(), log);
                continue;
            }
            if (mnemonicString.equals("instance_of")) {
                scalar = instruction.getScalar(2);
                this.processClass(program, instruction, 2, header, (int)scalar.getUnsignedValue(), log);
                continue;
            }
            if (mnemonicString.equals("check_cast")) {
                scalar = instruction.getScalar(1);
                this.processClass(program, instruction, 1, header, (int)scalar.getUnsignedValue(), log);
                continue;
            }
            if (mnemonicString.startsWith("invoke")) {
                scalar = instruction.getScalar(0);
                this.processMethod(program, instruction, 0, header, (int)scalar.getUnsignedValue(), log);
                continue;
            }
            if (mnemonicString.equals("new_instance")) {
                scalar = instruction.getScalar(1);
                this.processClass(program, instruction, 1, header, (int)scalar.getUnsignedValue(), log);
                continue;
            }
            if (mnemonicString.equals("new_array")) {
                scalar = instruction.getScalar(2);
                this.processClass(program, instruction, 2, header, (int)scalar.getUnsignedValue(), log);
                continue;
            }
            if (mnemonicString.startsWith("iget")) {
                scalar = instruction.getScalar(2);
                this.processField(program, instruction, 2, header, (int)scalar.getUnsignedValue(), log);
                continue;
            }
            if (mnemonicString.startsWith("iput")) {
                scalar = instruction.getScalar(2);
                this.processField(program, instruction, 2, header, (int)scalar.getUnsignedValue(), log);
                continue;
            }
            if (mnemonicString.startsWith("sget")) {
                scalar = instruction.getScalar(1);
                this.processField(program, instruction, 1, header, (int)scalar.getUnsignedValue(), log);
                continue;
            }
            if (mnemonicString.startsWith("sput")) {
                scalar = instruction.getScalar(1);
                this.processField(program, instruction, 1, header, (int)scalar.getUnsignedValue(), log);
                continue;
            }
            if (mnemonicString.startsWith("filled_new_array")) {
                scalar = instruction.getScalar(0);
                this.processClass(program, instruction, 0, header, (int)scalar.getUnsignedValue(), log);
                continue;
            }
            if (!mnemonicString.startsWith("fill_array_data")) continue;
            scalar = instruction.getScalar(1);
            Address address = instruction.getMinAddress().add(scalar.getUnsignedValue() * 2L);
            if (program.getMemory().getShort(address) != 768) {
                log.appendMsg("invalid filled array at " + address);
                continue;
            }
            reader.setPointerIndex(address.getOffset());
            FilledArrayDataPayload payload = new FilledArrayDataPayload(reader);
            DataType dataType = payload.toDataType();
            this.createData(program, address, dataType);
            program.getReferenceManager().addMemoryReference(instruction.getMinAddress(), address, RefType.DATA, SourceType.ANALYSIS, 1);
        }
        return true;
    }

    public boolean canAnalyze(Program program) {
        MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), program.getMinAddress());
        return DexConstants.isDexFile((ByteProvider)provider) || CDexConstants.isCDEX(program);
    }

    @Override
    public AnalyzerType getAnalysisType() {
        return AnalyzerType.INSTRUCTION_ANALYZER;
    }

    public boolean getDefaultEnablement(Program program) {
        return true;
    }

    public String getDescription() {
        return "Android DEX/CDEX Instruction Markup";
    }

    public String getName() {
        return "Android DEX/CDEX Instruction Markup";
    }

    @Override
    public AnalysisPriority getPriority() {
        return new AnalysisPriority(4);
    }

    public boolean isPrototype() {
        return false;
    }

    private String getClassName(Program program, DexHeader header, int classTypeIndex, MessageLog log) {
        TypeIDItem typeItem = header.getTypes().get(classTypeIndex);
        StringIDItem stringItem = header.getStrings().get(typeItem.getDescriptorIndex());
        return stringItem.getStringDataItem().getString();
    }

    private String format(String className, String methodName) {
        StringBuilder builder = new StringBuilder();
        if (className.startsWith("L") && className.endsWith(";")) {
            String str = className.substring(1, className.length() - 1);
            StringTokenizer tokenizer = new StringTokenizer(str, "/");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                builder.append(token + "::");
            }
        }
        builder.append(methodName);
        return builder.toString();
    }

    private void setEquate(Program program, Address address, int operand, String equateName, int equateValue) {
        EquateTable equateTable = program.getEquateTable();
        Equate equate = equateTable.getEquate(equateName);
        if (equate == null) {
            try {
                equate = equateTable.createEquate(equateName, (long)equateValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (equate == null) {
            return;
        }
        if (equate.getValue() != (long)equateValue) {
            this.setEquate(program, address, operand, equateName + "_" + equateValue, equateValue);
            return;
        }
        equate.addReference(address, operand);
    }

    private void processMethod(Program program, Instruction instruction, int operand, DexHeader header, int methodIndex, MessageLog log) {
        if (methodIndex < 0 || methodIndex > header.getMethodIdsSize()) {
            log.appendMsg("method index not found: " + methodIndex);
            return;
        }
        Address methodIndexAddress = header.getMethodAddress(program, methodIndex);
        if (methodIndexAddress != Address.NO_ADDRESS) {
            program.getReferenceManager().addMemoryReference(instruction.getMinAddress(), methodIndexAddress, (RefType)RefType.UNCONDITIONAL_CALL, SourceType.ANALYSIS, operand);
        }
    }

    private void processClass(Program program, Instruction instruction, int operand, DexHeader header, int classTypeIndex, MessageLog log) {
        if (classTypeIndex < 0 || classTypeIndex > header.getTypes().size()) {
            log.appendMsg("class type index not found: " + classTypeIndex);
            return;
        }
        TypeIDItem typeItem = header.getTypes().get(classTypeIndex);
        StringIDItem stringItem = header.getStrings().get(typeItem.getDescriptorIndex());
        String className = stringItem.getStringDataItem().getString();
        this.setEquate(program, instruction.getMinAddress(), operand, className, classTypeIndex);
        program.getListing().setComment(instruction.getMinAddress(), 0, className);
    }

    private void processString(Program program, Instruction instruction, int operand, DexHeader header, int stringIndex, MessageLog log) {
        List<StringIDItem> strings = header.getStrings();
        if (stringIndex < 0 || stringIndex > strings.size()) {
            log.appendMsg("string index not found: " + stringIndex);
            return;
        }
        StringIDItem stringIDItem = strings.get(stringIndex);
        StringDataItem stringDataItem = stringIDItem.getStringDataItem();
        if (stringDataItem == null) {
            log.appendMsg("string data item is null: " + stringIndex);
            return;
        }
        AddressSpace defaultAddressSpace = program.getAddressFactory().getDefaultAddressSpace();
        Address stringAddr = defaultAddressSpace.getAddress((long)DexUtil.adjustOffset(stringIDItem.getStringDataOffset(), header));
        program.getReferenceManager().addMemoryReference(instruction.getMinAddress(), stringAddr, RefType.DATA, SourceType.ANALYSIS, operand);
    }

    private void processField(Program program, Instruction instruction, int operand, DexHeader header, int fieldIndex, MessageLog log) {
        List<FieldIDItem> fields = header.getFields();
        if (fieldIndex < 0 || fieldIndex > fields.size()) {
            log.appendMsg("field index not found: " + fieldIndex);
            return;
        }
        FieldIDItem fieldIDItem = fields.get(fieldIndex);
        StringIDItem stringItem = header.getStrings().get(fieldIDItem.getNameIndex());
        String fieldName = stringItem.getStringDataItem().getString();
        String className = this.getClassName(program, header, fieldIDItem.getClassIndex(), log);
        String valueName = this.format(className, fieldName);
        this.setEquate(program, instruction.getMinAddress(), operand, fieldName, fieldIndex);
        program.getListing().setComment(instruction.getMinAddress(), 0, valueName);
    }
}

