/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.art;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.art.ArtConstants;
import ghidra.file.formats.android.art.ArtHeader;
import ghidra.file.formats.android.art.UnsupportedArtVersionException;
import ghidra.file.formats.android.art.android10.ArtHeader_10;
import ghidra.file.formats.android.art.android11.ArtHeader_11;
import ghidra.file.formats.android.art.android12.ArtHeader_12;
import ghidra.file.formats.android.art.kitkat.ArtHeader_KitKat;
import ghidra.file.formats.android.art.lollipop.ArtHeader_Lollipop;
import ghidra.file.formats.android.art.lollipop.ArtHeader_LollipopMR1WFC;
import ghidra.file.formats.android.art.marshmallow.ArtHeader_Marshmallow;
import ghidra.file.formats.android.art.nougat.ArtHeader_Nougat;
import ghidra.file.formats.android.art.nougat.ArtHeader_NougatMR2Pixel;
import ghidra.file.formats.android.art.oreo.ArtHeader_Oreo;
import ghidra.file.formats.android.art.oreo.ArtHeader_OreoMR1;
import ghidra.file.formats.android.art.pie.ArtHeader_Pie;
import java.io.IOException;

public final class ArtFactory {
    public static final ArtHeader newArtHeader(BinaryReader reader) throws IOException, UnsupportedArtVersionException {
        String magic = new String(reader.readByteArray(0L, "art\n".length()));
        String version = reader.readAsciiString(4L, 4);
        if (magic.equals("art\n") && ArtConstants.isSupportedVersion(version)) {
            switch (version) {
                case "005": {
                    return new ArtHeader_KitKat(reader);
                }
                case "009": {
                    return new ArtHeader_Lollipop(reader);
                }
                case "012": {
                    return new ArtHeader_LollipopMR1WFC(reader);
                }
                case "017": {
                    return new ArtHeader_Marshmallow(reader);
                }
                case "029": {
                    return new ArtHeader_Nougat(reader);
                }
                case "030": {
                    return new ArtHeader_NougatMR2Pixel(reader);
                }
                case "043": {
                    return new ArtHeader_Oreo(reader);
                }
                case "044": {
                    return new ArtHeader_Oreo(reader);
                }
                case "046": {
                    return new ArtHeader_OreoMR1(reader);
                }
                case "056": {
                    return new ArtHeader_Pie(reader);
                }
                case "074": {
                    return new ArtHeader_10(reader);
                }
                case "085": {
                    return new ArtHeader_11(reader);
                }
                case "099": {
                    return new ArtHeader_12(reader);
                }
            }
        }
        throw new UnsupportedArtVersionException(magic, version);
    }
}

