/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.gdb;

import ghidra.app.plugin.core.debug.mapping.DebuggerMappingOffer;
import ghidra.app.plugin.core.debug.mapping.DebuggerMappingOpinion;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerMappingOffer;
import ghidra.dbg.target.TargetEnvironment;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.ExternalLanguageCompilerSpecQuery;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.util.DefaultLanguageService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class DefaultGdbDebuggerMappingOpinion
implements DebuggerMappingOpinion {
    public static final String EXTERNAL_TOOL = "gnu";
    public static final CompilerSpecID PREFERRED_CSPEC_ID = new CompilerSpecID("gcc");
    private static final Map<Pair<String, Endian>, List<LanguageCompilerSpecPair>> CACHE = new HashMap<Pair<String, Endian>, List<LanguageCompilerSpecPair>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LanguageCompilerSpecPair> getCompilerSpecsForGnu(String arch, Endian endian) {
        Map<Pair<String, Endian>, List<LanguageCompilerSpecPair>> map = CACHE;
        synchronized (map) {
            return CACHE.computeIfAbsent((Pair<String, Endian>)Pair.of((Object)arch, (Object)endian), p -> {
                LanguageService langServ = DefaultLanguageService.getLanguageService();
                return langServ.getLanguageCompilerSpecPairs(new ExternalLanguageCompilerSpecQuery(arch, EXTERNAL_TOOL, endian, null, PREFERRED_CSPEC_ID));
            });
        }
    }

    public static boolean isGdb(TargetEnvironment env) {
        if (env == null) {
            return false;
        }
        return env.getDebugger().toLowerCase().contains("gdb");
    }

    public static boolean isLinux(TargetEnvironment env) {
        if (env == null) {
            return false;
        }
        return env.getOperatingSystem().contains("Linux");
    }

    protected Set<DebuggerMappingOffer> offersForLanguageAndCSpec(TargetObject target, String arch, Endian endian, LanguageCompilerSpecPair lcsp) {
        return Set.of(new GdbDefaultOffer(target, 10, "Default GDB for " + arch, lcsp, Set.of()));
    }

    @Override
    public Set<DebuggerMappingOffer> offersForEnv(TargetEnvironment env, TargetProcess process, boolean includeOverrides) {
        if (!DefaultGdbDebuggerMappingOpinion.isGdb(env)) {
            return Set.of();
        }
        Endian endian = DebuggerMappingOpinion.getEndian(env);
        String arch = env.getArchitecture();
        return DefaultGdbDebuggerMappingOpinion.getCompilerSpecsForGnu(arch, endian).stream().flatMap(lcsp -> this.offersForLanguageAndCSpec((TargetObject)process, arch, endian, (LanguageCompilerSpecPair)lcsp).stream()).collect(Collectors.toSet());
    }

    protected static class GdbDefaultOffer
    extends DefaultDebuggerMappingOffer {
        public GdbDefaultOffer(TargetObject target, int confidence, String description, LanguageCompilerSpecPair lcsp, Collection<String> extraRegNames) {
            super(target, confidence, description, lcsp.languageID, lcsp.compilerSpecID, extraRegNames);
        }
    }
}

