/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.mapping;

import ghidra.app.plugin.core.debug.mapping.DebuggerMemoryMapper;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.SpecialAddress;
import ghidra.program.model.lang.Language;

public class DefaultDebuggerMemoryMapper
implements DebuggerMemoryMapper {
    protected final AddressFactory traceAddressFactory;
    protected final AddressFactory targetAddressFactory;

    public DefaultDebuggerMemoryMapper(Language traceLanguage, DebuggerObjectModel targetModel) {
        this.traceAddressFactory = traceLanguage.getAddressFactory();
        this.targetAddressFactory = targetModel.getAddressFactory();
    }

    protected static boolean isInFactory(AddressSpace space, AddressFactory factory) {
        return factory.getAddressSpace(space.getName()) == space;
    }

    protected static boolean isInFactory(Address addr, AddressFactory factory) {
        return DefaultDebuggerMemoryMapper.isInFactory(addr.getAddressSpace(), factory);
    }

    protected static Address toSameNamedSpace(Address addr, AddressFactory factory) {
        return factory.getAddressSpace(addr.getAddressSpace().getName()).getAddress(addr.getOffset());
    }

    @Override
    public Address traceToTarget(Address traceAddr) {
        assert (DefaultDebuggerMemoryMapper.isInFactory(traceAddr, this.traceAddressFactory));
        return DefaultDebuggerMemoryMapper.toSameNamedSpace(traceAddr, this.targetAddressFactory);
    }

    @Override
    public AddressRange traceToTarget(AddressRange traceRange) {
        return new AddressRangeImpl(this.traceToTarget(traceRange.getMinAddress()), this.traceToTarget(traceRange.getMaxAddress()));
    }

    @Override
    public Address targetToTrace(Address targetAddr) {
        if (targetAddr == SpecialAddress.NO_ADDRESS) {
            return null;
        }
        assert (DefaultDebuggerMemoryMapper.isInFactory(targetAddr, this.targetAddressFactory));
        return DefaultDebuggerMemoryMapper.toSameNamedSpace(targetAddr, this.traceAddressFactory);
    }

    @Override
    public AddressRange targetToTrace(AddressRange targetRange) {
        return new AddressRangeImpl(this.targetToTrace(targetRange.getMinAddress()), this.targetToTrace(targetRange.getMaxAddress()));
    }
}

