/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memory;

import docking.Tool;
import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.byteviewer.AbstractByteViewerPlugin;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponentProvider;
import ghidra.app.plugin.core.byteviewer.ProgramByteViewerComponentProvider;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceLocationPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceSelectionPluginEvent;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.LocationTrackingSpec;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerMemoryBytesProvider;
import ghidra.app.services.ClipboardService;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.ProgramManager;
import ghidra.framework.options.AutoOptions;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.annotation.AutoOptionConsumed;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jdom.Element;

@PluginInfo(shortDescription="View bytes of trace (possibly live) memory", description="Provides the memory bytes display window. Functions similarly to the main program bytes display window, but for traces. If the trace is the destination of a live recording, the view(s) retrieve live memory on demand.", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceActivatedPluginEvent.class, TraceClosedPluginEvent.class}, eventsProduced={TraceLocationPluginEvent.class, TraceSelectionPluginEvent.class}, servicesRequired={DebuggerModelService.class, ClipboardService.class})
public class DebuggerMemoryBytesPlugin
extends AbstractByteViewerPlugin<DebuggerMemoryBytesProvider> {
    private static final String KEY_CONNECTED_PROVIDER = "connectedProvider";
    private static final String KEY_DISCONNECTED_COUNT = "disconnectedCount";
    private static final String PREFIX_DISCONNECTED_PROVIDER = "disconnectedProvider";
    protected DockingAction actionNewMemory;
    @AutoServiceConsumed
    private ProgramManager programManager;
    private AutoService.Wiring autoServiceWiring;
    @AutoOptionConsumed(name={"Colors.Stale Memory"})
    private Color staleMemoryColor;
    @AutoOptionConsumed(name={"Colors.Error Memory"})
    private Color errorMemoryColor;
    @AutoOptionConsumed(name={"Colors.Tracking Markers"})
    private Color trackingColor;
    private AutoOptions.Wiring autoOptionsWiring;
    private DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;

    public DebuggerMemoryBytesPlugin(PluginTool tool) {
        super(tool);
        this.autoServiceWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);
        this.autoOptionsWiring = AutoOptions.wireOptions((Plugin)this);
        this.createActions();
    }

    protected DebuggerMemoryBytesProvider createProvider(boolean isConnected) {
        return new DebuggerMemoryBytesProvider(this.tool, this, isConnected);
    }

    private void createActions() {
        this.actionNewMemory = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.NewMemoryAction.builder((Plugin)this).enabled(true)).onAction(c -> this.createNewDisconnectedProvider())).buildAndInstall((Tool)this.tool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerMemoryBytesProvider createViewerIfMissing(LocationTrackingSpec spec, boolean followsCurrentThread) {
        List list = this.disconnectedProviders;
        synchronized (list) {
            for (DebuggerMemoryBytesProvider provider : this.disconnectedProviders) {
                if (provider.getTrackingSpec() != spec || provider.isFollowsCurrentThread() != followsCurrentThread) continue;
                return provider;
            }
            DebuggerMemoryBytesProvider provider = (DebuggerMemoryBytesProvider)this.createNewDisconnectedProvider();
            provider.setTrackingSpec(spec);
            provider.setFollowsCurrentThread(followsCurrentThread);
            provider.goToCoordinates(this.current);
            return provider;
        }
    }

    protected void updateLocation(ProgramByteViewerComponentProvider programByteViewerComponentProvider, ProgramLocationPluginEvent event, boolean export) {
    }

    protected void fireProgramLocationPluginEvent(ProgramByteViewerComponentProvider programByteViewerComponentProvider, ProgramLocationPluginEvent pluginEvent) {
    }

    public void updateSelection(ByteViewerComponentProvider provider, ProgramSelectionPluginEvent event, Program program) {
    }

    public void highlightChanged(ByteViewerComponentProvider provider, ProgramSelection highlight) {
    }

    protected void allProviders(Consumer<DebuggerMemoryBytesProvider> action) {
        action.accept((DebuggerMemoryBytesProvider)this.connectedProvider);
        for (DebuggerMemoryBytesProvider provider : this.disconnectedProviders) {
            action.accept(provider);
        }
    }

    public void processEvent(PluginEvent event) {
        PluginEvent ev;
        if (event instanceof TraceActivatedPluginEvent) {
            ev = (TraceActivatedPluginEvent)event;
            this.current = ev.getActiveCoordinates();
            this.allProviders(p -> p.coordinatesActivated(this.current));
        }
        if (event instanceof TraceClosedPluginEvent) {
            ev = (TraceClosedPluginEvent)event;
            if (this.current.getTrace() == ev.getTrace()) {
                this.current = DebuggerCoordinates.NOWHERE;
            }
            this.allProviders(arg_0 -> DebuggerMemoryBytesPlugin.lambda$processEvent$2((TraceClosedPluginEvent)ev, arg_0));
        }
    }

    @AutoServiceConsumed
    public void setTraceManager(DebuggerTraceManagerService traceManager) {
        DebuggerMemoryBytesProvider provider = (DebuggerMemoryBytesProvider)this.connectedProvider;
        if (provider == null || traceManager == null) {
            return;
        }
        this.current = traceManager.getCurrent();
        provider.coordinatesActivated(this.current);
    }

    public Object getTransientState() {
        return new Object[0];
    }

    public void restoreTransientState(Object objectState) {
    }

    public void writeDataState(SaveState saveState) {
        SaveState connectedProviderState = new SaveState();
        ((DebuggerMemoryBytesProvider)this.connectedProvider).writeDataState(connectedProviderState);
        saveState.putXmlElement(KEY_CONNECTED_PROVIDER, connectedProviderState.saveToXml());
        List disconnected = this.disconnectedProviders.stream().filter(p -> p.isFollowsCurrentThread()).collect(Collectors.toList());
        for (DebuggerMemoryBytesProvider p2 : this.disconnectedProviders) {
            if (disconnected.contains((Object)p2)) continue;
            disconnected.add(p2);
        }
        int disconnectedCount = disconnected.size();
        saveState.putInt(KEY_DISCONNECTED_COUNT, disconnectedCount);
        for (int index = 0; index < disconnectedCount; ++index) {
            DebuggerMemoryBytesProvider provider = (DebuggerMemoryBytesProvider)((Object)disconnected.get(index));
            String stateName = PREFIX_DISCONNECTED_PROVIDER + index;
            SaveState providerState = new SaveState();
            provider.writeDataState(providerState);
            saveState.putXmlElement(stateName, providerState.saveToXml());
        }
    }

    protected void ensureProviders(int count, boolean followCurrentThread, SaveState configState) {
        while (this.disconnectedProviders.size() < count) {
            int index = this.disconnectedProviders.size();
            String stateName = PREFIX_DISCONNECTED_PROVIDER + index;
            DebuggerMemoryBytesProvider provider = (DebuggerMemoryBytesProvider)this.createNewDisconnectedProvider();
            provider.setFollowsCurrentThread(false);
            Element providerElement = configState.getXmlElement(stateName);
            if (providerElement != null) {
                SaveState providerState = new SaveState(providerElement);
                provider.readConfigState(providerState);
                continue;
            }
            provider.setTrackingSpec(LocationTrackingSpec.fromConfigName("TRACK_NONE"));
        }
    }

    public void readDataState(SaveState saveState) {
        Element connectedProviderElement = saveState.getXmlElement(KEY_CONNECTED_PROVIDER);
        if (connectedProviderElement != null) {
            SaveState connectedProviderState = new SaveState(connectedProviderElement);
            ((DebuggerMemoryBytesProvider)this.connectedProvider).readDataState(connectedProviderState);
        }
        int disconnectedCount = saveState.getInt(KEY_DISCONNECTED_COUNT, 0);
        this.ensureProviders(disconnectedCount, false, saveState);
        List disconnected = this.disconnectedProviders;
        for (int index = 0; index < disconnectedCount; ++index) {
            String stateName = PREFIX_DISCONNECTED_PROVIDER + index;
            Element providerElement = saveState.getXmlElement(stateName);
            if (providerElement == null) continue;
            SaveState providerState = new SaveState(providerElement);
            DebuggerMemoryBytesProvider provider = (DebuggerMemoryBytesProvider)((Object)disconnected.get(index));
            provider.readDataState(providerState);
        }
    }

    public void writeConfigState(SaveState saveState) {
        SaveState connectedProviderState = new SaveState();
        ((DebuggerMemoryBytesProvider)this.connectedProvider).writeConfigState(connectedProviderState);
        saveState.putXmlElement(KEY_CONNECTED_PROVIDER, connectedProviderState.saveToXml());
        List disconnected = this.disconnectedProviders.stream().filter(p -> p.isFollowsCurrentThread()).collect(Collectors.toList());
        int disconnectedCount = disconnected.size();
        saveState.putInt(KEY_DISCONNECTED_COUNT, disconnectedCount);
        for (int index = 0; index < disconnectedCount; ++index) {
            DebuggerMemoryBytesProvider provider = (DebuggerMemoryBytesProvider)((Object)disconnected.get(index));
            String stateName = PREFIX_DISCONNECTED_PROVIDER + index;
            SaveState providerState = new SaveState();
            provider.writeConfigState(providerState);
            saveState.putXmlElement(stateName, providerState.saveToXml());
        }
    }

    public void readConfigState(SaveState saveState) {
        Element connectedProviderElement = saveState.getXmlElement(KEY_CONNECTED_PROVIDER);
        if (connectedProviderElement != null) {
            SaveState connectedProviderState = new SaveState(connectedProviderElement);
            ((DebuggerMemoryBytesProvider)this.connectedProvider).readConfigState(connectedProviderState);
        }
        int disconnectedCount = saveState.getInt(KEY_DISCONNECTED_COUNT, 0);
        this.ensureProviders(disconnectedCount, true, saveState);
    }

    private static /* synthetic */ void lambda$processEvent$2(TraceClosedPluginEvent ev, DebuggerMemoryBytesProvider p) {
        p.traceClosed(ev.getTrace());
    }
}

