/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.job;

import edu.uci.ics.jung.visualization.VisualizationServer;
import ghidra.graph.job.AbstractAnimator;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.interpolation.PropertySetter;

public class TwinkleVertexAnimator<V extends VisualVertex, E extends VisualEdge<V>>
extends AbstractAnimator {
    private final VisualizationServer<V, E> viewer;
    private final V vertex;
    private final boolean useAnimation;
    private double startEmphasis;

    public TwinkleVertexAnimator(VisualizationServer<V, E> viewer, V vertex, boolean useAnimation) {
        this.viewer = viewer;
        this.vertex = vertex;
        this.useAnimation = useAnimation;
    }

    @Override
    protected Animator createAnimator() {
        if (!this.useAnimation) {
            return null;
        }
        this.startEmphasis = this.vertex.getEmphasis();
        Animator newAnimator = PropertySetter.createAnimator((int)500, (Object)this, (String)"currentEmphasis", (Object[])new Double[]{0.0, 0.5});
        newAnimator.setAcceleration(0.0f);
        newAnimator.setDeceleration(0.0f);
        newAnimator.setRepeatCount(4.0);
        newAnimator.setRepeatBehavior(Animator.RepeatBehavior.REVERSE);
        return newAnimator;
    }

    @Override
    protected void finished() {
        this.vertex.setEmphasis(this.startEmphasis);
    }

    public void setCurrentEmphasis(double currentEmphasis) {
        this.vertex.setEmphasis(currentEmphasis);
        this.viewer.repaint();
    }

    public V getVertex() {
        return this.vertex;
    }
}

