/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.iface2;

import agent.dbgeng.dbgeng.DebugProcessId;
import agent.dbgeng.dbgeng.DebugSystemObjects;
import agent.dbgeng.manager.DbgEventsListenerAdapter;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.manager.DbgState;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.model.iface1.DbgModelSelectableObject;
import agent.dbgeng.model.iface1.DbgModelTargetAccessConditioned;
import agent.dbgeng.model.iface1.DbgModelTargetAttachable;
import agent.dbgeng.model.iface1.DbgModelTargetAttacher;
import agent.dbgeng.model.iface1.DbgModelTargetDeletable;
import agent.dbgeng.model.iface1.DbgModelTargetDetachable;
import agent.dbgeng.model.iface1.DbgModelTargetExecutionStateful;
import agent.dbgeng.model.iface1.DbgModelTargetInterruptible;
import agent.dbgeng.model.iface1.DbgModelTargetKillable;
import agent.dbgeng.model.iface1.DbgModelTargetLauncher;
import agent.dbgeng.model.iface1.DbgModelTargetResumable;
import agent.dbgeng.model.iface1.DbgModelTargetSteppable;
import agent.dbgeng.model.iface2.DbgModelTargetMemoryContainer;
import agent.dbgeng.model.iface2.DbgModelTargetModuleContainer;
import agent.dbgeng.model.iface2.DbgModelTargetThreadContainer;
import ghidra.dbg.target.TargetAggregate;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.util.PathUtils;
import java.util.concurrent.CompletableFuture;

public interface DbgModelTargetProcess
extends TargetAggregate,
TargetProcess,
DbgModelTargetExecutionStateful,
DbgModelTargetAccessConditioned,
DbgModelTargetAttacher,
DbgModelTargetAttachable,
DbgModelTargetLauncher,
DbgModelTargetDeletable,
DbgModelTargetDetachable,
DbgModelTargetKillable,
DbgModelTargetResumable,
DbgModelTargetSteppable,
DbgModelTargetInterruptible,
DbgEventsListenerAdapter,
DbgModelSelectableObject {
    public void processStarted(Long var1);

    public DbgModelTargetThreadContainer getThreads();

    public DbgModelTargetModuleContainer getModules();

    public DbgModelTargetMemoryContainer getMemory();

    public void threadStateChangedSpecific(DbgThread var1, DbgState var2);

    default public DbgProcess getProcess() {
        DbgManagerImpl manager = this.getManager();
        DebugSystemObjects so = manager.getSystemObjects();
        try {
            String index = PathUtils.parseIndex((String)this.getName());
            Integer pid = Integer.decode(index);
            DebugProcessId id = so.getProcessIdBySystemId(pid);
            if (id == null) {
                id = so.getCurrentProcessId();
            }
            return manager.getProcessComputeIfAbsent(id, pid);
        }
        catch (IllegalArgumentException e) {
            return manager.getCurrentProcess();
        }
    }

    @Override
    default public CompletableFuture<Void> setActive() {
        DbgManagerImpl manager = this.getManager();
        DbgProcess process = this.getProcess();
        if (process == null) {
            process = manager.getEventProcess();
        }
        return manager.setActiveProcess(process);
    }
}

