/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.impl;

import agent.dbgeng.dbgeng.DbgEng;
import agent.dbgeng.dbgeng.DebugAdvanced;
import agent.dbgeng.dbgeng.DebugBreakpoint;
import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.dbgeng.DebugClientReentrant;
import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.dbgeng.DebugDataSpaces;
import agent.dbgeng.dbgeng.DebugEventInformation;
import agent.dbgeng.dbgeng.DebugExceptionRecord64;
import agent.dbgeng.dbgeng.DebugModuleInfo;
import agent.dbgeng.dbgeng.DebugProcessId;
import agent.dbgeng.dbgeng.DebugProcessInfo;
import agent.dbgeng.dbgeng.DebugRegisters;
import agent.dbgeng.dbgeng.DebugSessionId;
import agent.dbgeng.dbgeng.DebugSymbols;
import agent.dbgeng.dbgeng.DebugSystemObjects;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.gadp.impl.AbstractClientThreadExecutor;
import agent.dbgeng.gadp.impl.DbgEngClientThreadExecutor;
import agent.dbgeng.impl.dbgeng.DbgEngUtil;
import agent.dbgeng.jna.dbgeng.WinNTExtra;
import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgCommand;
import agent.dbgeng.manager.DbgEvent;
import agent.dbgeng.manager.DbgEventsListener;
import agent.dbgeng.manager.DbgManager;
import agent.dbgeng.manager.DbgModuleMemory;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.manager.DbgSession;
import agent.dbgeng.manager.DbgState;
import agent.dbgeng.manager.DbgStateListener;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.breakpoint.DbgBreakpointInfo;
import agent.dbgeng.manager.breakpoint.DbgBreakpointType;
import agent.dbgeng.manager.cmd.DbgAddProcessCommand;
import agent.dbgeng.manager.cmd.DbgAddSessionCommand;
import agent.dbgeng.manager.cmd.DbgAttachKernelCommand;
import agent.dbgeng.manager.cmd.DbgCommandError;
import agent.dbgeng.manager.cmd.DbgConsoleExecCommand;
import agent.dbgeng.manager.cmd.DbgDeleteBreakpointsCommand;
import agent.dbgeng.manager.cmd.DbgDisableBreakpointsCommand;
import agent.dbgeng.manager.cmd.DbgEnableBreakpointsCommand;
import agent.dbgeng.manager.cmd.DbgInsertBreakpointCommand;
import agent.dbgeng.manager.cmd.DbgLaunchProcessCommand;
import agent.dbgeng.manager.cmd.DbgListAvailableProcessesCommand;
import agent.dbgeng.manager.cmd.DbgListBreakpointsCommand;
import agent.dbgeng.manager.cmd.DbgListProcessesCommand;
import agent.dbgeng.manager.cmd.DbgOpenDumpCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.cmd.DbgRemoveProcessCommand;
import agent.dbgeng.manager.cmd.DbgRemoveSessionCommand;
import agent.dbgeng.manager.cmd.DbgRequestActivationCommand;
import agent.dbgeng.manager.cmd.DbgRequestFocusCommand;
import agent.dbgeng.manager.cmd.DbgSetActiveProcessCommand;
import agent.dbgeng.manager.cmd.DbgSetActiveSessionCommand;
import agent.dbgeng.manager.cmd.DbgSetActiveThreadCommand;
import agent.dbgeng.manager.evt.AbstractDbgEvent;
import agent.dbgeng.manager.evt.DbgBreakpointCreatedEvent;
import agent.dbgeng.manager.evt.DbgBreakpointDeletedEvent;
import agent.dbgeng.manager.evt.DbgBreakpointEvent;
import agent.dbgeng.manager.evt.DbgBreakpointModifiedEvent;
import agent.dbgeng.manager.evt.DbgCommandDoneEvent;
import agent.dbgeng.manager.evt.DbgConsoleOutputEvent;
import agent.dbgeng.manager.evt.DbgDebuggeeStateChangeEvent;
import agent.dbgeng.manager.evt.DbgExceptionEvent;
import agent.dbgeng.manager.evt.DbgModuleLoadedEvent;
import agent.dbgeng.manager.evt.DbgModuleUnloadedEvent;
import agent.dbgeng.manager.evt.DbgProcessCreatedEvent;
import agent.dbgeng.manager.evt.DbgProcessExitedEvent;
import agent.dbgeng.manager.evt.DbgProcessSelectedEvent;
import agent.dbgeng.manager.evt.DbgPromptChangedEvent;
import agent.dbgeng.manager.evt.DbgRunningEvent;
import agent.dbgeng.manager.evt.DbgSessionSelectedEvent;
import agent.dbgeng.manager.evt.DbgStateChangedEvent;
import agent.dbgeng.manager.evt.DbgStoppedEvent;
import agent.dbgeng.manager.evt.DbgSystemErrorEvent;
import agent.dbgeng.manager.evt.DbgSystemsEvent;
import agent.dbgeng.manager.evt.DbgThreadCreatedEvent;
import agent.dbgeng.manager.evt.DbgThreadExitedEvent;
import agent.dbgeng.manager.evt.DbgThreadSelectedEvent;
import agent.dbgeng.manager.impl.DbgDebugEventCallbacksAdapter;
import agent.dbgeng.manager.impl.DbgDebugInputCallbacks;
import agent.dbgeng.manager.impl.DbgDebugOutputCallbacks;
import agent.dbgeng.manager.impl.DbgProcessImpl;
import agent.dbgeng.manager.impl.DbgSessionImpl;
import agent.dbgeng.manager.impl.DbgThreadImpl;
import agent.dbgeng.model.iface1.DbgModelTargetActiveScope;
import agent.dbgeng.model.iface1.DbgModelTargetFocusScope;
import agent.dbgeng.model.iface2.DbgModelTargetObject;
import agent.dbgeng.model.iface2.DbgModelTargetThread;
import com.sun.jna.platform.win32.COM.COMException;
import ghidra.async.AsyncClaimQueue;
import ghidra.async.AsyncReference;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.comm.util.BitmaskSet;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.HandlerMap;
import ghidra.lifecycle.Internal;
import ghidra.util.Msg;
import ghidra.util.TriConsumer;
import ghidra.util.datastruct.ListenerSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.tuple.Pair;

public class DbgManagerImpl
implements DbgManager {
    private String dbgSrvTransport;
    private final AsyncClaimQueue<DebugThreadId> claimsBreakpointAdded = new AsyncClaimQueue();
    private final AsyncClaimQueue<BreakId> claimsBreakpointRemoved = new AsyncClaimQueue();
    public DebugClient.DebugStatus status;
    public final Set<DebugClient.DebugStatus> statiAccessible = Collections.unmodifiableSet(EnumSet.of(DebugClient.DebugStatus.NO_DEBUGGEE, DebugClient.DebugStatus.BREAK));
    private final Map<Integer, BreakpointTag> breaksById = new LinkedHashMap<Integer, BreakpointTag>();
    protected AbstractClientThreadExecutor engThread;
    protected DebugClientReentrant reentrantClient;
    private List<DbgPendingCommand<?>> activeCmds = new ArrayList();
    protected final Map<DebugSessionId, DbgSessionImpl> sessions = new LinkedHashMap<DebugSessionId, DbgSessionImpl>();
    protected DbgSessionImpl curSession = null;
    private final Map<DebugSessionId, DbgSession> unmodifiableSessions = Collections.unmodifiableMap(this.sessions);
    protected final Map<DebugProcessId, DbgProcessImpl> processes = new LinkedHashMap<DebugProcessId, DbgProcessImpl>();
    private final Map<DebugProcessId, DbgProcess> unmodifiableProcesses = Collections.unmodifiableMap(this.processes);
    protected final Map<DebugThreadId, DbgThreadImpl> threads = new LinkedHashMap<DebugThreadId, DbgThreadImpl>();
    private final Map<DebugThreadId, DbgThread> unmodifiableThreads = Collections.unmodifiableMap(this.threads);
    private final Map<Long, DbgBreakpointInfo> breakpoints = new LinkedHashMap<Long, DbgBreakpointInfo>();
    private final Map<Long, DbgBreakpointInfo> unmodifiableBreakpoints = Collections.unmodifiableMap(this.breakpoints);
    private final NavigableMap<Long, DbgModuleMemory> memory = new TreeMap<Long, DbgModuleMemory>();
    private final NavigableMap<Long, DbgModuleMemory> unmodifiableMemory = Collections.unmodifiableNavigableMap(this.memory);
    protected final AsyncReference<DbgState, DbgCause> state = new AsyncReference((Object)DbgState.NOT_STARTED);
    private final HandlerMap<DbgEvent<?>, Void, DebugClient.DebugStatus> handlerMap = new HandlerMap();
    private final Map<Class<?>, DebugClient.DebugStatus> statusMap = new LinkedHashMap();
    private final Map<String, DebugClient.DebugStatus> statusByNameMap = new LinkedHashMap<String, DebugClient.DebugStatus>();
    private final ListenerSet<DbgEventsListener> listenersEvent = new ListenerSet(DbgEventsListener.class);
    private DebugEventInformation lastEventInformation;
    private DbgSession currentSession;
    private DbgProcess currentProcess;
    private DbgThread currentThread;
    private DbgSession eventSession;
    private DbgProcess eventProcess;
    private DbgThread eventThread;
    private volatile boolean waiting = false;
    private boolean kernelMode = false;
    private boolean ignoreEventThread = false;
    private CompletableFuture<String> continuation;
    private long processCount = 0L;

    public DbgManagerImpl() {
        this.state.filter(this::stateFilter);
        this.state.addChangeListener(this::trackRunningInterpreter);
        this.defaultHandlers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbgThreadImpl getThread(DebugThreadId tid) {
        Map<DebugThreadId, DbgThreadImpl> map = this.threads;
        synchronized (map) {
            return this.threads.get(tid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbgThreadImpl getThreadComputeIfAbsent(DebugThreadId id, DbgProcessImpl process, int tid) {
        Map<DebugThreadId, DbgThreadImpl> map = this.threads;
        synchronized (map) {
            if (!this.threads.containsKey(id)) {
                DbgThreadImpl thread = new DbgThreadImpl(this, process, id, tid);
                thread.add();
            }
            return this.threads.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThread(DebugThreadId id) {
        Map<DebugThreadId, DbgThreadImpl> map = this.threads;
        synchronized (map) {
            if (this.threads.remove(id) == null) {
                throw new IllegalArgumentException("There is no thread with id " + id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public void removeProcess(DebugProcessId id, DbgCause cause) {
        Map<DebugProcessId, DbgProcessImpl> map = this.processes;
        synchronized (map) {
            DbgProcessImpl proc = this.processes.remove(id);
            if (proc == null) {
                throw new IllegalArgumentException("There is no process with id " + id);
            }
            HashSet<DebugThreadId> toRemove = new HashSet<DebugThreadId>();
            for (DebugThreadId tid : this.threads.keySet()) {
                DbgThreadImpl thread = this.threads.get(tid);
                if (!thread.getProcess().getId().equals(id)) continue;
                toRemove.add(tid);
            }
            for (DebugThreadId tid : toRemove) {
                this.removeThread(tid);
            }
            ((DbgEventsListener)this.getEventListeners().fire).processRemoved(id, cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbgProcessImpl getProcess(DebugProcessId id) {
        Map<DebugProcessId, DbgProcessImpl> map = this.processes;
        synchronized (map) {
            DbgProcessImpl result = this.processes.get(id);
            if (result == null) {
                throw new IllegalArgumentException("There is no process with id " + id);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbgProcessImpl getProcessComputeIfAbsent(DebugProcessId id, int pid) {
        Map<DebugProcessId, DbgProcessImpl> map = this.processes;
        synchronized (map) {
            if (!this.processes.containsKey(id)) {
                DbgProcessImpl process = new DbgProcessImpl(this, id, pid);
                process.add();
            }
            return this.processes.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public void removeSession(DebugSessionId id, DbgCause cause) {
        Map<DebugSessionId, DbgSessionImpl> map = this.sessions;
        synchronized (map) {
            if (this.sessions.remove(id) == null) {
                throw new IllegalArgumentException("There is no session with id " + id);
            }
            ((DbgEventsListener)this.getEventListeners().fire).sessionRemoved(id, cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbgSession getSession(DebugSessionId id) {
        Map<DebugSessionId, DbgSessionImpl> map = this.sessions;
        synchronized (map) {
            DbgSession result = this.sessions.get(id);
            if (result == null) {
                throw new IllegalArgumentException("There is no session with id " + id);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbgSessionImpl getSessionComputeIfAbsent(DebugSessionId id) {
        Map<DebugSessionId, DbgSessionImpl> map = this.sessions;
        synchronized (map) {
            if (!this.sessions.containsKey(id) && id.id >= 0) {
                DbgSessionImpl session = new DbgSessionImpl(this, id);
                session.add();
            }
            return this.sessions.get(id);
        }
    }

    @Override
    public Map<DebugThreadId, DbgThread> getKnownThreads() {
        return this.unmodifiableThreads;
    }

    @Override
    public Map<DebugProcessId, DbgProcess> getKnownProcesses() {
        return this.unmodifiableProcesses;
    }

    @Override
    public Map<DebugSessionId, DbgSession> getKnownSessions() {
        return this.unmodifiableSessions;
    }

    @Override
    public Map<Long, DbgBreakpointInfo> getKnownBreakpoints() {
        return this.unmodifiableBreakpoints;
    }

    @Override
    public Map<Long, DbgModuleMemory> getKnownMemoryRegions() {
        return this.unmodifiableMemory;
    }

    private DbgBreakpointInfo addKnownBreakpoint(DbgBreakpointInfo bkpt, boolean expectExisting) {
        DbgBreakpointInfo old = this.breakpoints.put(bkpt.getNumber(), bkpt);
        if (expectExisting && old == null) {
            Msg.warn((Object)this, (Object)("Breakpoint " + bkpt.getNumber() + " is not known"));
        } else if (!expectExisting && old != null) {
            Msg.warn((Object)this, (Object)("Breakpoint " + bkpt.getNumber() + " is already known"));
        }
        return old;
    }

    private DbgBreakpointInfo getKnownBreakpoint(long number) {
        DbgBreakpointInfo info = this.breakpoints.get(number);
        if (info == null) {
            Msg.warn((Object)this, (Object)("Breakpoint " + number + " is not known"));
        }
        return info;
    }

    private DbgBreakpointInfo removeKnownBreakpoint(long number) {
        DbgBreakpointInfo del = this.breakpoints.remove(number);
        if (del == null) {
            Msg.warn((Object)this, (Object)("Breakpoint " + number + " is not known"));
        }
        return del;
    }

    @Override
    public CompletableFuture<DbgBreakpointInfo> insertBreakpoint(String loc, DbgBreakpointType type) {
        return this.execute(new DbgInsertBreakpointCommand(this, loc, type));
    }

    @Override
    public CompletableFuture<DbgBreakpointInfo> insertBreakpoint(long loc, int len, DbgBreakpointType type) {
        return this.execute(new DbgInsertBreakpointCommand(this, loc, len, type));
    }

    @Override
    public CompletableFuture<Void> disableBreakpoints(long ... numbers) {
        return this.execute(new DbgDisableBreakpointsCommand(this, numbers));
    }

    @Override
    public CompletableFuture<Void> enableBreakpoints(long ... numbers) {
        return this.execute(new DbgEnableBreakpointsCommand(this, numbers));
    }

    @Override
    public CompletableFuture<Void> deleteBreakpoints(long ... numbers) {
        return this.execute(new DbgDeleteBreakpointsCommand(this, numbers));
    }

    @Override
    public CompletableFuture<Map<Long, DbgBreakpointInfo>> listBreakpoints() {
        return this.execute(new DbgListBreakpointsCommand(this));
    }

    private void checkStarted() {
        if (this.state.get() == DbgState.NOT_STARTED) {
            throw new IllegalStateException("dbgeng has not been started or has not finished starting");
        }
    }

    @Override
    public CompletableFuture<Void> start(String[] args) {
        this.state.set((Object)DbgState.STARTING, (Object)DbgCause.Causes.UNCLAIMED);
        boolean create = true;
        if (args.length == 0) {
            this.engThread = new DbgEngClientThreadExecutor(() -> DbgEng.debugCreate().createClient());
        } else {
            String remoteOptions = String.join((CharSequence)" ", args);
            this.engThread = new DbgEngClientThreadExecutor(() -> DbgEng.debugConnect(remoteOptions).createClient());
            create = false;
        }
        this.engThread.setManager(this);
        AtomicReference<Boolean> creat = new AtomicReference<Boolean>(create);
        return AsyncUtils.sequence((TypeSpec)TypeSpec.VOID).then((Executor)this.engThread, seq -> {
            this.doExecute((Boolean)creat.get());
            seq.exit();
        }).finish().exceptionally(exc -> {
            Msg.error((Object)this, (Object)"start failed");
            return null;
        });
    }

    protected void doExecute(Boolean create) {
        DebugClient dbgeng = this.engThread.getClient();
        this.reentrantClient = dbgeng;
        this.status = dbgeng.getControl().getExecutionStatus();
        if (create.booleanValue()) {
            dbgeng.endSession(DebugClient.DebugEndSessionFlags.DEBUG_END_ACTIVE_TERMINATE);
        }
        this.status = dbgeng.getControl().getExecutionStatus();
        dbgeng.setOutputCallbacks(new DbgDebugOutputCallbacks(this));
        dbgeng.setEventCallbacks(new DbgDebugEventCallbacksAdapter(this));
        dbgeng.setInputCallbacks(new DbgDebugInputCallbacks(this));
        dbgeng.flushCallbacks();
        if (!create.booleanValue()) {
            dbgeng.connectSession(0);
        }
        if (this.dbgSrvTransport != null && !"none".equalsIgnoreCase(this.dbgSrvTransport)) {
            dbgeng.startServer(this.dbgSrvTransport);
        }
    }

    @Override
    public boolean isRunning() {
        return !this.engThread.isShutdown() && !this.engThread.isTerminated();
    }

    @Override
    public void terminate() {
        this.engThread.execute(100, dbgeng -> {
            Msg.debug((Object)this, (Object)"Disconnecting DebugClient from session");
            dbgeng.endSession(DebugClient.DebugEndSessionFlags.DEBUG_END_DISCONNECT);
            dbgeng.setOutputCallbacks(null);
        });
        this.engThread.shutdown();
        try {
            this.engThread.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws Exception {
        this.terminate();
    }

    @Override
    public <T> CompletableFuture<T> execute(DbgCommand<? extends T> cmd) {
        assert (cmd != null);
        this.checkStarted();
        DbgPendingCommand pcmd = new DbgPendingCommand(cmd);
        if (this.engThread.isCurrentThread()) {
            try {
                this.addCommand(cmd, pcmd);
            }
            catch (Throwable exc2) {
                pcmd.completeExceptionally(exc2);
            }
        } else {
            CompletableFuture.runAsync(() -> this.addCommand(cmd, pcmd), this.engThread).exceptionally(exc -> {
                pcmd.completeExceptionally((Throwable)exc);
                return null;
            });
        }
        return pcmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void addCommand(DbgCommand<? extends T> cmd, DbgPendingCommand<T> pcmd) {
        DbgManagerImpl dbgManagerImpl = this;
        synchronized (dbgManagerImpl) {
            if (!cmd.validInState((DbgState)((Object)this.state.get()))) {
                throw new DbgCommandError("Command " + cmd + " is not valid while " + this.state.get());
            }
            this.activeCmds.add(pcmd);
        }
        cmd.invoke();
        this.processEvent(new DbgCommandDoneEvent(cmd));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugClient.DebugStatus processEvent(DbgEvent<?> evt) {
        DbgState newState;
        if (this.state.get() == DbgState.STARTING) {
            this.state.set((Object)DbgState.STOPPED, (Object)DbgCause.Causes.UNCLAIMED);
        }
        if ((newState = evt.newState()) != null && !(evt instanceof DbgCommandDoneEvent)) {
            Msg.debug((Object)this, (Object)(evt + " transitions state to " + newState));
            this.state.set((Object)newState, (Object)evt.getCause());
        }
        boolean cmdFinished = false;
        ArrayList toRemove = new ArrayList();
        for (DbgPendingCommand<?> dbgPendingCommand : this.activeCmds) {
            cmdFinished = dbgPendingCommand.handle(evt);
            if (!cmdFinished) continue;
            dbgPendingCommand.finish();
            toRemove.add(dbgPendingCommand);
        }
        for (DbgPendingCommand<Object> dbgPendingCommand : toRemove) {
            this.activeCmds.remove(dbgPendingCommand);
        }
        DbgManagerImpl dbgManagerImpl = this;
        synchronized (dbgManagerImpl) {
            DebugClient.DebugStatus ret;
            boolean bl = this.isWaiting();
            this.waiting = false;
            DebugClient.DebugStatus debugStatus = ret = evt.isStolen() ? null : (DebugClient.DebugStatus)((Object)this.handlerMap.handle(evt, null));
            if (ret == null) {
                ret = DebugClient.DebugStatus.NO_CHANGE;
            }
            this.waiting = ret.equals((Object)DebugClient.DebugStatus.NO_DEBUGGEE) ? false : bl;
            return ret;
        }
    }

    @Override
    public void addStateListener(DbgStateListener listener) {
        this.state.addChangeListener((TriConsumer)listener);
    }

    @Override
    public void removeStateListener(DbgStateListener listener) {
        this.state.removeChangeListener((TriConsumer)listener);
    }

    public ListenerSet<DbgEventsListener> getEventListeners() {
        return this.listenersEvent;
    }

    @Override
    public void addEventsListener(DbgEventsListener listener) {
        this.getEventListeners().add((Object)listener);
    }

    @Override
    public void removeEventsListener(DbgEventsListener listener) {
        this.getEventListeners().remove((Object)listener);
    }

    private DbgState stateFilter(DbgState cur, DbgState set, DbgCause cause) {
        if (set == null) {
            return cur;
        }
        return set;
    }

    private void trackRunningInterpreter(DbgState oldSt, DbgState st, DbgCause cause) {
        if (st == DbgState.RUNNING && cause instanceof DbgPendingCommand) {
            DbgPendingCommand pcmd = (DbgPendingCommand)cause;
            DbgCommand command = pcmd.getCommand();
            Msg.debug((Object)this, (Object)("Entered " + st + " from " + command));
        }
    }

    private void defaultHandlers() {
        this.handlerMap.put(DbgBreakpointEvent.class, this::processBreakpoint);
        this.handlerMap.put(DbgExceptionEvent.class, this::processException);
        this.handlerMap.put(DbgThreadCreatedEvent.class, this::processThreadCreated);
        this.handlerMap.put(DbgThreadExitedEvent.class, this::processThreadExited);
        this.handlerMap.put(DbgThreadSelectedEvent.class, this::processThreadSelected);
        this.handlerMap.put(DbgProcessCreatedEvent.class, this::processProcessCreated);
        this.handlerMap.put(DbgProcessExitedEvent.class, this::processProcessExited);
        this.handlerMap.put(DbgProcessSelectedEvent.class, this::processProcessSelected);
        this.handlerMap.put(DbgModuleLoadedEvent.class, this::processModuleLoaded);
        this.handlerMap.put(DbgModuleUnloadedEvent.class, this::processModuleUnloaded);
        this.handlerMap.put(DbgStateChangedEvent.class, this::processStateChanged);
        this.handlerMap.put(DbgSessionSelectedEvent.class, this::processSessionSelected);
        this.handlerMap.put(DbgSystemsEvent.class, this::processSystemsEvent);
        this.handlerMap.putVoid(DbgDebuggeeStateChangeEvent.class, this::processDebuggeeStateChanged);
        this.handlerMap.putVoid(DbgSystemErrorEvent.class, this::processSystemErrorEvent);
        this.handlerMap.putVoid(DbgCommandDoneEvent.class, this::processDefault);
        this.handlerMap.putVoid(DbgStoppedEvent.class, this::processDefault);
        this.handlerMap.putVoid(DbgRunningEvent.class, this::processDefault);
        this.handlerMap.putVoid(DbgConsoleOutputEvent.class, this::processConsoleOutput);
        this.handlerMap.putVoid(DbgPromptChangedEvent.class, this::processPromptChanged);
        this.handlerMap.putVoid(DbgBreakpointCreatedEvent.class, this::processBreakpointCreated);
        this.handlerMap.putVoid(DbgBreakpointModifiedEvent.class, this::processBreakpointModified);
        this.handlerMap.putVoid(DbgBreakpointDeletedEvent.class, this::processBreakpointDeleted);
        this.statusMap.put(DbgBreakpointEvent.class, DebugClient.DebugStatus.BREAK);
        this.statusMap.put(DbgExceptionEvent.class, DebugClient.DebugStatus.NO_CHANGE);
        this.statusMap.put(DbgProcessCreatedEvent.class, DebugClient.DebugStatus.BREAK);
        this.statusMap.put(DbgStateChangedEvent.class, DebugClient.DebugStatus.NO_CHANGE);
        this.statusMap.put(DbgStoppedEvent.class, DebugClient.DebugStatus.BREAK);
    }

    private DebugThreadId updateState() {
        DebugClient dbgeng = this.engThread.getClient();
        DebugSystemObjects so = dbgeng.getSystemObjects();
        DebugThreadId etid = so.getEventThread();
        DebugProcessId epid = so.getEventProcess();
        DebugSessionId esid = so.getCurrentSystemId();
        DebugControl control = dbgeng.getControl();
        int execType = WinNTExtra.Machine.IMAGE_FILE_MACHINE_AMD64.val;
        try {
            execType = control.getExecutingProcessorType();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lastEventInformation = control.getLastEventInformation();
        this.lastEventInformation.setSession(esid);
        this.lastEventInformation.setExecutingProcessorType(execType);
        this.currentSession = this.eventSession = this.getSessionComputeIfAbsent(esid);
        this.currentProcess = this.eventProcess = this.getProcessComputeIfAbsent(epid, so.getCurrentProcessSystemId());
        this.currentThread = this.eventThread = this.getThreadComputeIfAbsent(etid, (DbgProcessImpl)this.eventProcess, so.getCurrentThreadSystemId());
        if (this.eventThread != null) {
            ((DbgThreadImpl)this.eventThread).setInfo(this.lastEventInformation);
        }
        return etid;
    }

    protected <T> DebugClient.DebugStatus processDefault(AbstractDbgEvent<T> evt, Void v) {
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processBreakpoint(DbgBreakpointEvent evt, Void v) {
        this.updateState();
        DebugBreakpoint bp = (DebugBreakpoint)evt.getInfo();
        DbgBreakpointInfo info = new DbgBreakpointInfo(bp, this.getEventProcess(), this.getEventThread());
        ((DbgEventsListener)this.getEventListeners().fire).threadSelected(this.eventThread, null, evt.getCause());
        ((DbgEventsListener)this.getEventListeners().fire).breakpointHit(info, evt.getCause());
        String key = Integer.toHexString(bp.getId());
        if (this.statusByNameMap.containsKey(key)) {
            return this.statusByNameMap.get(key);
        }
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processException(DbgExceptionEvent evt, Void v) {
        DebugThreadId eventId = this.updateState();
        ((DbgEventsListener)this.getEventListeners().fire).eventSelected(evt, evt.getCause());
        ((DbgEventsListener)this.getEventListeners().fire).threadSelected(this.eventThread, null, evt.getCause());
        DebugExceptionRecord64 info = (DebugExceptionRecord64)evt.getInfo();
        String key = Integer.toHexString(info.code);
        if (this.statusByNameMap.containsKey(key)) {
            return this.statusByNameMap.get(key);
        }
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processThreadCreated(DbgThreadCreatedEvent evt, Void v) {
        DebugClient dbgeng = this.engThread.getClient();
        DebugSystemObjects so = dbgeng.getSystemObjects();
        DebugThreadId eventId = this.updateState();
        DbgProcessImpl process = this.getCurrentProcess();
        int tid = so.getCurrentThreadSystemId();
        DbgThreadImpl thread = this.getThreadComputeIfAbsent(eventId, process, tid);
        ((DbgEventsListener)this.getEventListeners().fire).eventSelected(evt, evt.getCause());
        ((DbgEventsListener)this.getEventListeners().fire).threadCreated(thread, DbgCause.Causes.UNCLAIMED);
        ((DbgEventsListener)this.getEventListeners().fire).threadSelected(thread, null, evt.getCause());
        String key = Integer.toHexString(eventId.id);
        if (this.statusByNameMap.containsKey(key)) {
            return this.statusByNameMap.get(key);
        }
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processThreadExited(DbgThreadExitedEvent evt, Void v) {
        DebugThreadId eventId = this.updateState();
        DbgProcessImpl process = this.getCurrentProcess();
        DbgThreadImpl thread = this.getCurrentThread();
        if (thread != null) {
            thread.remove();
        }
        process.threadExited(eventId);
        ((DbgEventsListener)this.getEventListeners().fire).eventSelected(evt, evt.getCause());
        ((DbgEventsListener)this.getEventListeners().fire).threadExited(eventId, process, evt.getCause());
        String key = Integer.toHexString(eventId.id);
        if (this.statusByNameMap.containsKey(key)) {
            return this.statusByNameMap.get(key);
        }
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processThreadSelected(DbgThreadSelectedEvent evt, Void v) {
        DebugThreadId eventId = this.updateState();
        this.currentThread = evt.getThread();
        this.currentThread.setState(evt.getState(), evt.getCause(), evt.getReason());
        ((DbgEventsListener)this.getEventListeners().fire).threadSelected(this.currentThread, evt.getFrame(), evt.getCause());
        String key = Integer.toHexString(eventId.id);
        if (this.statusByNameMap.containsKey(key)) {
            return this.statusByNameMap.get(key);
        }
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processProcessCreated(DbgProcessCreatedEvent evt, Void v) {
        DebugThreadId eventId = this.updateState();
        DebugClient dbgeng = this.engThread.getClient();
        DebugSystemObjects so = dbgeng.getSystemObjects();
        DebugProcessInfo info = (DebugProcessInfo)evt.getInfo();
        long handle = info.handle;
        DebugProcessId id = so.getProcessIdByHandle(handle);
        int pid = so.getCurrentProcessSystemId();
        DbgProcessImpl proc = this.getProcessComputeIfAbsent(id, pid);
        ((DbgEventsListener)this.getEventListeners().fire).eventSelected(evt, evt.getCause());
        ((DbgEventsListener)this.getEventListeners().fire).processAdded(proc, evt.getCause());
        ((DbgEventsListener)this.getEventListeners().fire).processSelected(proc, evt.getCause());
        handle = info.initialThreadInfo.handle;
        DebugThreadId idt = so.getThreadIdByHandle(handle);
        int tid = so.getCurrentThreadSystemId();
        DbgThreadImpl thread = this.getThreadComputeIfAbsent(idt, proc, tid);
        ((DbgEventsListener)this.getEventListeners().fire).threadCreated(thread, evt.getCause());
        ((DbgEventsListener)this.getEventListeners().fire).threadSelected(thread, null, evt.getCause());
        String key = Integer.toHexString(id.id);
        if (this.statusByNameMap.containsKey(key)) {
            return this.statusByNameMap.get(key);
        }
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processProcessExited(DbgProcessExitedEvent evt, Void v) {
        DebugThreadId eventId = this.updateState();
        DbgThreadImpl thread = this.getCurrentThread();
        DbgProcessImpl process = this.getCurrentProcess();
        process.setExitCode((long)((Integer)evt.getInfo()));
        ((DbgEventsListener)this.getEventListeners().fire).eventSelected(evt, evt.getCause());
        ((DbgEventsListener)this.getEventListeners().fire).threadExited(eventId, process, evt.getCause());
        ((DbgEventsListener)this.getEventListeners().fire).processExited(process, evt.getCause());
        for (DebugBreakpoint bpt : this.getBreakpoints()) {
            this.breaksById.remove(bpt.getId());
        }
        if (thread != null) {
            thread.remove();
        }
        process.remove(evt.getCause());
        ((DbgEventsListener)this.getEventListeners().fire).processRemoved(process.getId(), evt.getCause());
        String key = Integer.toHexString(process.getId().id);
        if (this.statusByNameMap.containsKey(key)) {
            return this.statusByNameMap.get(key);
        }
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processProcessSelected(DbgProcessSelectedEvent evt, Void v) {
        DebugThreadId eventId = this.updateState();
        this.currentProcess = evt.getProcess();
        ((DbgEventsListener)this.getEventListeners().fire).processSelected(this.currentProcess, evt.getCause());
        String key = Integer.toHexString(eventId.id);
        if (this.statusByNameMap.containsKey(key)) {
            return this.statusByNameMap.get(key);
        }
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processModuleLoaded(DbgModuleLoadedEvent evt, Void v) {
        this.updateState();
        DbgProcessImpl process = this.getCurrentProcess();
        DebugModuleInfo info = (DebugModuleInfo)evt.getInfo();
        process.moduleLoaded(info);
        ((DbgEventsListener)this.getEventListeners().fire).eventSelected(evt, evt.getCause());
        ((DbgEventsListener)this.getEventListeners().fire).moduleLoaded(process, info, evt.getCause());
        String key = info.getModuleName();
        if (this.statusByNameMap.containsKey(key)) {
            return this.statusByNameMap.get(key);
        }
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processModuleUnloaded(DbgModuleUnloadedEvent evt, Void v) {
        this.updateState();
        DbgProcessImpl process = this.getCurrentProcess();
        DebugModuleInfo info = (DebugModuleInfo)evt.getInfo();
        process.moduleUnloaded(info);
        ((DbgEventsListener)this.getEventListeners().fire).eventSelected(evt, evt.getCause());
        ((DbgEventsListener)this.getEventListeners().fire).moduleUnloaded(process, info, evt.getCause());
        String key = info.getModuleName();
        if (this.statusByNameMap.containsKey(key)) {
            return this.statusByNameMap.get(key);
        }
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processStateChanged(DbgStateChangedEvent evt, Void v) {
        BitmaskSet flags = (BitmaskSet)evt.getInfo();
        long argument = evt.getArgument();
        if (flags.contains((Object)DebugClient.ChangeEngineState.EXECUTION_STATUS)) {
            if (DebugClient.DebugStatus.isInsideWait(argument)) {
                return DebugClient.DebugStatus.NO_CHANGE;
            }
            this.status = DebugClient.DebugStatus.fromArgument(argument);
            if (this.status.equals((Object)DebugClient.DebugStatus.NO_DEBUGGEE)) {
                this.waiting = false;
                return DebugClient.DebugStatus.NO_DEBUGGEE;
            }
            if (!this.threads.isEmpty()) {
                this.eventThread = this.getCurrentThread();
                DbgState dbgState = null;
                if (this.eventThread != null) {
                    if (this.status.threadState.equals((Object)DebugClient.ExecutionState.STOPPED)) {
                        dbgState = DbgState.STOPPED;
                        this.processEvent(new DbgStoppedEvent(this.eventThread.getId()));
                        this.processEvent(new DbgPromptChangedEvent(this.getControl().getPromptText()));
                    }
                    if (this.status.threadState.equals((Object)DebugClient.ExecutionState.RUNNING)) {
                        dbgState = DbgState.RUNNING;
                        ((DbgEventsListener)this.getEventListeners().fire).memoryChanged(this.currentProcess, 0L, 0, evt.getCause());
                        this.processEvent(new DbgRunningEvent(this.eventThread.getId()));
                    }
                    if (!this.threads.containsValue(this.eventThread)) {
                        dbgState = DbgState.EXIT;
                    }
                    if (dbgState != null && dbgState != DbgState.EXIT) {
                        this.processEvent(new DbgThreadSelectedEvent(dbgState, this.eventThread, evt.getFrame(this.eventThread)));
                    }
                    return DebugClient.DebugStatus.NO_CHANGE;
                }
            }
            if (this.status.equals((Object)DebugClient.DebugStatus.BREAK)) {
                this.waiting = false;
                this.processEvent(new DbgStoppedEvent(this.getSystemObjects().getCurrentThreadId()));
                DbgProcessImpl process = this.getCurrentProcess();
                if (process != null) {
                    this.processEvent(new DbgProcessSelectedEvent(process));
                }
                this.processEvent(new DbgPromptChangedEvent(this.getControl().getPromptText()));
                return DebugClient.DebugStatus.BREAK;
            }
            if (this.status.equals((Object)DebugClient.DebugStatus.GO)) {
                this.waiting = true;
                this.processEvent(new DbgRunningEvent(this.getSystemObjects().getCurrentThreadId()));
                return DebugClient.DebugStatus.GO;
            }
            this.waiting = false;
            return DebugClient.DebugStatus.NO_CHANGE;
        }
        if (flags.contains((Object)DebugClient.ChangeEngineState.BREAKPOINTS)) {
            long bptId = evt.getArgument();
            this.processEvent(new DbgBreakpointModifiedEvent(bptId));
        }
        if (flags.contains((Object)DebugClient.ChangeEngineState.CURRENT_THREAD)) {
            long id = evt.getArgument();
            for (DebugThreadId key : this.getThreads()) {
                if ((long)key.id != id) continue;
                DbgThreadImpl thread = this.getThread(key);
                if (thread != null) {
                    ((DbgEventsListener)this.getEventListeners().fire).threadSelected(thread, null, evt.getCause());
                }
                this.processEvent(new DbgPromptChangedEvent(this.getControl().getPromptText()));
                break;
            }
        }
        if (flags.contains((Object)DebugClient.ChangeEngineState.SYSTEMS)) {
            this.processEvent(new DbgSystemsEvent(argument));
        }
        return DebugClient.DebugStatus.NO_CHANGE;
    }

    protected DebugClient.DebugStatus processSessionSelected(DbgSessionSelectedEvent evt, Void v) {
        DebugThreadId eventId = this.updateState();
        this.currentSession = evt.getSession();
        ((DbgEventsListener)this.getEventListeners().fire).sessionSelected(this.currentSession, evt.getCause());
        String key = Integer.toHexString(eventId.id);
        if (this.statusByNameMap.containsKey(key)) {
            return this.statusByNameMap.get(key);
        }
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processSystemsEvent(DbgSystemsEvent evt, Void v) {
        this.waiting = true;
        Long info = (Long)evt.getInfo();
        this.processCount = info.intValue() >= 0 ? ++this.processCount : --this.processCount;
        DebugProcessId id = new DebugProcessId(info.intValue());
        String key = Integer.toHexString(id.id);
        if (this.statusByNameMap.containsKey(key)) {
            return this.statusByNameMap.get(key);
        }
        return this.statusMap.get(evt.getClass());
    }

    protected void processDebuggeeStateChanged(DbgDebuggeeStateChangeEvent evt, Void v) {
        if (evt.getFlags().contains((Object)DebugClient.ChangeDebuggeeState.DATA)) {
            ((DbgEventsListener)this.getEventListeners().fire).memoryChanged(this.currentProcess, 0L, 0, evt.getCause());
        }
    }

    protected void processSystemErrorEvent(DbgSystemErrorEvent evt, Void v) {
        ((DbgEventsListener)this.getEventListeners().fire).eventSelected(evt, evt.getCause());
        String error = "SystemError " + evt.getError() + ":" + evt.getLevel();
        ((DbgEventsListener)this.getEventListeners().fire).consoleOutput(error, 0);
    }

    protected void processConsoleOutput(DbgConsoleOutputEvent evt, Void v) {
        ((DbgEventsListener)this.getEventListeners().fire).eventSelected(evt, evt.getCause());
        ((DbgEventsListener)this.getEventListeners().fire).consoleOutput((String)evt.getInfo(), evt.getMask());
    }

    protected void processPromptChanged(DbgPromptChangedEvent evt, Void v) {
        ((DbgEventsListener)this.getEventListeners().fire).promptChanged(evt.getPrompt());
    }

    protected void processBreakpointCreated(DbgBreakpointCreatedEvent evt, Void v) {
        this.doBreakpointCreated(evt.getBreakpointInfo(), evt.getCause());
    }

    protected void processBreakpointModified(DbgBreakpointModifiedEvent evt, Void v) {
        DbgBreakpointInfo breakpointInfo = evt.getBreakpointInfo();
        if (breakpointInfo == null) {
            long bptId = evt.getId();
            if (bptId == DbgEngUtil.DEBUG_ANY_ID.longValue()) {
                this.changeBreakpoints();
            } else {
                DebugBreakpoint bpt = this.getControl().getBreakpointById((int)bptId);
                if (bpt == null && bptId != DbgEngUtil.DEBUG_ANY_ID.longValue()) {
                    this.doBreakpointDeleted(bptId, evt.getCause());
                    return;
                }
                DbgBreakpointInfo knownBreakpoint = this.getKnownBreakpoint(bptId);
                if (knownBreakpoint == null) {
                    breakpointInfo = new DbgBreakpointInfo(bpt, this.getCurrentProcess());
                    if (breakpointInfo.getOffset() != null) {
                        this.doBreakpointCreated(breakpointInfo, evt.getCause());
                    }
                    return;
                }
                breakpointInfo = knownBreakpoint;
                breakpointInfo.setBreakpoint(bpt);
                this.doBreakpointModified(breakpointInfo, evt.getCause());
            }
        }
    }

    protected void processBreakpointDeleted(DbgBreakpointDeletedEvent evt, Void v) {
        this.doBreakpointDeleted(evt.getNumber(), evt.getCause());
    }

    @Internal
    public void doBreakpointCreated(DbgBreakpointInfo newInfo, DbgCause cause) {
        this.addKnownBreakpoint(newInfo, false);
        ((DbgEventsListener)this.getEventListeners().fire).breakpointCreated(newInfo, cause);
    }

    @Internal
    public void doBreakpointModified(DbgBreakpointInfo newInfo, DbgCause cause) {
        DbgBreakpointInfo oldInfo = this.addKnownBreakpoint(newInfo, true);
        ((DbgEventsListener)this.getEventListeners().fire).breakpointModified(newInfo, oldInfo, cause);
    }

    @Internal
    public void doBreakpointDeleted(long number, DbgCause cause) {
        DbgBreakpointInfo oldInfo = this.removeKnownBreakpoint(number);
        if (oldInfo == null) {
            return;
        }
        ((DbgEventsListener)this.getEventListeners().fire).breakpointDeleted(oldInfo, cause);
    }

    protected void doBreakpointModifiedSameLocations(DbgBreakpointInfo newInfo, DbgBreakpointInfo oldInfo, DbgCause cause) {
        if (Objects.equals(newInfo, oldInfo)) {
            return;
        }
        ((DbgEventsListener)this.getEventListeners().fire).breakpointModified(newInfo, oldInfo, cause);
    }

    @Internal
    public void doBreakpointDisabled(long number, DbgCause cause) {
        DbgBreakpointInfo oldInfo = this.getKnownBreakpoint(number);
        if (oldInfo == null) {
            return;
        }
        DbgBreakpointInfo newInfo = oldInfo.withEnabled(false);
        this.doBreakpointModifiedSameLocations(newInfo, oldInfo, cause);
    }

    @Internal
    public void doBreakpointEnabled(long number, DbgCause cause) {
        DbgBreakpointInfo oldInfo = this.getKnownBreakpoint(number);
        if (oldInfo == null) {
            return;
        }
        DbgBreakpointInfo newInfo = oldInfo.withEnabled(true);
        this.doBreakpointModifiedSameLocations(newInfo, oldInfo, cause);
    }

    private long orZero(Long l) {
        if (l == null) {
            return 0L;
        }
        return l;
    }

    private void changeBreakpoints() {
        HashSet<Integer> retained = new HashSet<Integer>();
        DebugSystemObjects so = this.getSystemObjects();
        try (SavedFocus focus = new SavedFocus(so);){
            for (DebugProcessId pid : so.getProcesses()) {
                try {
                    Msg.debug((Object)this, (Object)("BREAKPOINTS: Changing current process to " + pid));
                    so.setCurrentProcessId(pid);
                }
                catch (COMException e) {
                    Msg.debug((Object)this, (Object)e.getMessage());
                    continue;
                }
                List<DebugThreadId> tids = so.getThreads();
                for (DebugBreakpoint bpt : this.getControl().getBreakpoints()) {
                    BitmaskSet<DebugBreakpoint.BreakFlags> f = bpt.getFlags();
                    if (!f.contains((Object)DebugBreakpoint.BreakFlags.ENABLED) || f.contains((Object)DebugBreakpoint.BreakFlags.DEFERRED) || bpt.getType().breakType != DebugBreakpoint.BreakType.CODE) continue;
                    int id = bpt.getId();
                    retained.add(id);
                    long newOffset = this.orZero(bpt.getOffset());
                    BreakpointTag tag = this.breaksById.get(id);
                    if (tag == null) {
                        for (DebugThreadId tid : tids) {
                            Msg.debug((Object)this, (Object)("TRAP Added: " + id + " on " + tid));
                            if (this.claimsBreakpointAdded.satisfy((Object)tid)) {
                                Msg.debug((Object)this, (Object)"  claimed");
                            }
                            this.breaksById.put(id, new BreakpointTag(newOffset));
                        }
                        continue;
                    }
                    if (tag.offset == newOffset) continue;
                    tag.offset = newOffset;
                }
                Iterator<Integer> it = this.breaksById.keySet().iterator();
                while (it.hasNext()) {
                    int id = it.next();
                    if (retained.contains(id)) continue;
                    for (DebugThreadId tid : tids) {
                        Msg.debug((Object)this, (Object)("TRAP Removed: " + id + " on " + tid));
                        if (!this.claimsBreakpointRemoved.satisfy((Object)new BreakId(tid, id))) continue;
                        Msg.debug((Object)this, (Object)"  claimed");
                    }
                    it.remove();
                }
            }
        }
        catch (COMException e) {
            Msg.error((Object)this, (Object)("Error retrieving processes: " + e));
        }
    }

    @Override
    public CompletableFuture<Map<DebugProcessId, DbgProcess>> listProcesses() {
        return this.execute(new DbgListProcessesCommand(this));
    }

    @Override
    public CompletableFuture<List<Pair<Integer, String>>> listAvailableProcesses() {
        return this.execute(new DbgListAvailableProcessesCommand(this));
    }

    @Override
    public CompletableFuture<Map<String, DbgSession>> listSessions() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void sendInterruptNow() {
        this.checkStarted();
        Msg.info((Object)this, (Object)"Interrupting");
        this.reentrantClient.getControl().setInterrupt(DebugControl.DebugInterrupt.ACTIVE);
    }

    @Override
    public CompletableFuture<DbgProcess> addProcess() {
        return this.execute(new DbgAddProcessCommand(this));
    }

    @Override
    public CompletableFuture<Void> removeProcess(DbgProcess process) {
        return this.execute(new DbgRemoveProcessCommand(this, process.getId()));
    }

    @Override
    public CompletableFuture<DbgSession> addSession() {
        return this.execute(new DbgAddSessionCommand(this));
    }

    @Override
    public CompletableFuture<Void> removeSession(DbgSession session) {
        return this.execute(new DbgRemoveSessionCommand(this, session.getId()));
    }

    @Override
    public CompletableFuture<Void> addMemory(DbgModuleMemory region) {
        this.memory.put(region.getId(), region);
        return AsyncUtils.NIL;
    }

    @Override
    public CompletableFuture<Void> removeMemory(Long id) {
        this.memory.remove(id);
        return AsyncUtils.NIL;
    }

    @Override
    public CompletableFuture<?> launch(List<String> args) {
        return this.execute(new DbgLaunchProcessCommand(this, args));
    }

    @Override
    public CompletableFuture<Void> launch(Map<String, ?> args) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<?> openFile(Map<String, ?> args) {
        return this.execute(new DbgOpenDumpCommand(this, args));
    }

    public CompletableFuture<?> attachKernel(Map<String, ?> args) {
        this.setKernelMode(true);
        return this.execute(new DbgAttachKernelCommand(this, args));
    }

    public DebugClient getClient() {
        return this.engThread.getClient();
    }

    public DebugAdvanced getAdvanced() {
        DebugClient dbgeng = this.getClient();
        return dbgeng.getAdvanced();
    }

    public DebugControl getControl() {
        DebugClient dbgeng = this.getClient();
        return dbgeng.getControl();
    }

    public DebugDataSpaces getDataSpaces() {
        DebugClient dbgeng = this.getClient();
        return dbgeng.getDataSpaces();
    }

    public DebugRegisters getRegisters() {
        DebugClient dbgeng = this.getClient();
        return dbgeng.getRegisters();
    }

    public DebugSymbols getSymbols() {
        DebugClient dbgeng = this.getClient();
        return dbgeng.getSymbols();
    }

    public DebugSystemObjects getSystemObjects() {
        DebugClient dbgeng = this.getClient();
        return dbgeng.getSystemObjects();
    }

    public List<DebugThreadId> getThreads() {
        DebugSystemObjects so = this.getSystemObjects();
        return so.getThreads();
    }

    private List<DebugBreakpoint> getBreakpoints() {
        DebugControl control = this.getControl();
        return control.getBreakpoints();
    }

    public DbgThreadImpl getCurrentThread() {
        return (DbgThreadImpl)(this.currentThread != null ? this.currentThread : this.eventThread);
    }

    public void setCurrentThread(DbgThreadImpl thread) {
        this.currentThread = thread;
    }

    public DbgProcessImpl getCurrentProcess() {
        return (DbgProcessImpl)(this.currentProcess != null ? this.currentProcess : this.eventProcess);
    }

    public DbgSessionImpl getCurrentSession() {
        return (DbgSessionImpl)(this.currentSession != null ? this.currentSession : this.eventSession);
    }

    public DbgThreadImpl getEventThread() {
        return (DbgThreadImpl)this.eventThread;
    }

    public DbgProcessImpl getEventProcess() {
        return (DbgProcessImpl)this.eventProcess;
    }

    public DbgSessionImpl getEventSession() {
        return (DbgSessionImpl)this.eventSession;
    }

    public CompletableFuture<Void> setActiveFrame(DbgThread thread, int index) {
        this.currentThread = thread;
        return this.execute(new DbgSetActiveThreadCommand(this, thread, index));
    }

    public CompletableFuture<Void> setActiveThread(DbgThread thread) {
        this.currentThread = thread;
        return this.execute(new DbgSetActiveThreadCommand(this, thread, null));
    }

    public CompletableFuture<Void> setActiveProcess(DbgProcess process) {
        this.currentProcess = process;
        return this.execute(new DbgSetActiveProcessCommand(this, process));
    }

    public CompletableFuture<Void> setActiveSession(DbgSession session) {
        this.currentSession = session;
        return this.execute(new DbgSetActiveSessionCommand(this, session));
    }

    public CompletableFuture<Void> requestFocus(DbgModelTargetFocusScope scope, TargetObject obj) {
        return this.execute(new DbgRequestFocusCommand(this, scope, obj));
    }

    public CompletableFuture<Void> requestActivation(DbgModelTargetActiveScope activator, TargetObject obj) {
        return this.execute(new DbgRequestActivationCommand(this, activator, obj));
    }

    @Override
    public CompletableFuture<Void> console(String command) {
        if (this.continuation != null) {
            this.continuation.complete(command);
            this.setContinuation(null);
            return AsyncUtils.NIL;
        }
        return this.execute(new DbgConsoleExecCommand(this, command, DbgConsoleExecCommand.Output.CONSOLE)).thenApply(e -> null);
    }

    @Override
    public CompletableFuture<String> consoleCapture(String command) {
        return this.execute(new DbgConsoleExecCommand(this, command, DbgConsoleExecCommand.Output.CAPTURE));
    }

    public void fireThreadExited(DebugThreadId id, DbgProcessImpl process, DbgCause cause) {
        ((DbgEventsListener)this.getEventListeners().fire).threadExited(id, process, cause);
    }

    @Override
    public DbgState getState() {
        return (DbgState)((Object)this.state.get());
    }

    @Override
    public DbgProcess currentProcess() {
        return this.getCurrentProcess();
    }

    @Override
    public CompletableFuture<Void> waitForEventEx() {
        DebugControl control = this.getControl();
        this.waiting = true;
        control.waitForEvent();
        this.waiting = false;
        this.updateState();
        ((DbgEventsListener)this.getEventListeners().fire).threadSelected(this.eventThread, null, DbgCause.Causes.UNCLAIMED);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> waitForState(DbgState forState) {
        this.checkStarted();
        return this.state.waitValue((Object)forState);
    }

    @Override
    public CompletableFuture<Void> waitForPrompt() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public DebugEventInformation getLastEventInformation() {
        return this.lastEventInformation;
    }

    public boolean shouldUpdate(TargetObject object) {
        if (this.ignoreEventThread || !(object instanceof DbgModelTargetObject)) {
            return true;
        }
        DbgModelTargetObject modelObject = (DbgModelTargetObject)object;
        DbgModelTargetThread parentThread = modelObject.getParentThread();
        if (parentThread == null) {
            return true;
        }
        return parentThread.getThread().equals(this.eventThread);
    }

    public CompletableFuture<? extends Map<String, ?>> getRegisterMap(List<String> path) {
        return null;
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    public boolean isKernelMode() {
        return this.kernelMode;
    }

    public void setKernelMode(boolean kernelMode) {
        this.kernelMode = kernelMode;
    }

    public void setContinuation(CompletableFuture<String> continuation) {
        this.continuation = continuation;
    }

    public long getProcessCount() {
        return this.processCount;
    }

    class SavedFocus
    implements AutoCloseable {
        final DebugSystemObjects so;
        DebugThreadId tid = null;

        public SavedFocus(DebugSystemObjects so) {
            this.so = so;
            try {
                this.tid = so.getCurrentThreadId();
            }
            catch (COMException e) {
                Msg.debug((Object)this, (Object)("Cannot save current thread id: " + e));
            }
        }

        @Override
        public void close() {
            if (this.tid != null) {
                try {
                    this.so.setCurrentThreadId(this.tid);
                }
                catch (COMException e) {
                    Msg.debug((Object)this, (Object)("Could not restore current thread id: " + e));
                }
            }
        }
    }

    static class BreakpointTag {
        long offset;

        public BreakpointTag(long offset) {
            this.offset = offset;
        }
    }

    static class BreakId {
        final DebugThreadId tid;
        final int bpid;

        public BreakId(DebugThreadId tid, int bpid) {
            this.tid = tid;
            this.bpid = bpid;
        }
    }

    static class ExitEvent {
        final DebugThreadId tid;
        final long exitCode;

        public ExitEvent(DebugThreadId tid, long exitCode) {
            this.tid = tid;
            this.exitCode = exitCode;
        }
    }
}

