/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.impl.dbgeng.sysobj;

import agent.dbgeng.dbgeng.COMUtilsExtra;
import agent.dbgeng.dbgeng.DbgEng;
import agent.dbgeng.dbgeng.DebugProcessId;
import agent.dbgeng.dbgeng.DebugSessionId;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.impl.dbgeng.sysobj.DebugSystemObjectsInternal;
import agent.dbgeng.jna.dbgeng.sysobj.IDebugSystemObjects;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DebugSystemObjectsImpl1
implements DebugSystemObjectsInternal {
    private final DbgEng.OpaqueCleanable cleanable;
    private final IDebugSystemObjects jnaSysobj;

    public DebugSystemObjectsImpl1(IDebugSystemObjects jnaSysobj) {
        this.cleanable = DbgEng.releaseWhenPhantom((Object)this, jnaSysobj);
        this.jnaSysobj = jnaSysobj;
    }

    @Override
    public DebugThreadId getEventThread() {
        WinDef.ULONGByReference pulId = new WinDef.ULONGByReference();
        WinNT.HRESULT hr = this.jnaSysobj.GetEventThread(pulId);
        if (hr.equals((Object)COMUtilsExtra.E_UNEXPECTED)) {
            return new DebugThreadId(-1);
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return new DebugThreadId(pulId.getValue().intValue());
    }

    @Override
    public DebugProcessId getEventProcess() {
        WinDef.ULONGByReference pulId = new WinDef.ULONGByReference();
        WinNT.HRESULT hr = this.jnaSysobj.GetEventProcess(pulId);
        if (hr.equals((Object)COMUtilsExtra.E_UNEXPECTED)) {
            return new DebugProcessId(-1);
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return new DebugProcessId(pulId.getValue().intValue());
    }

    @Override
    public DebugThreadId getCurrentThreadId() {
        WinDef.ULONGByReference pulId = new WinDef.ULONGByReference();
        WinNT.HRESULT hr = this.jnaSysobj.GetCurrentThreadId(pulId);
        if (hr.equals((Object)COMUtilsExtra.E_UNEXPECTED)) {
            return new DebugThreadId(-1);
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return new DebugThreadId(pulId.getValue().intValue());
    }

    @Override
    public void setCurrentThreadId(DebugThreadId id) {
        WinNT.HRESULT hr = this.jnaSysobj.SetCurrentThreadId(new WinDef.ULONG((long)id.id));
        if (!hr.equals((Object)COMUtilsExtra.E_UNEXPECTED)) {
            COMUtils.checkRC((WinNT.HRESULT)hr);
        }
    }

    @Override
    public DebugProcessId getCurrentProcessId() {
        WinDef.ULONGByReference pulId = new WinDef.ULONGByReference();
        WinNT.HRESULT hr = this.jnaSysobj.GetCurrentProcessId(pulId);
        if (hr.equals((Object)COMUtilsExtra.E_UNEXPECTED)) {
            return new DebugProcessId(-1);
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return new DebugProcessId(pulId.getValue().intValue());
    }

    @Override
    public void setCurrentProcessId(DebugProcessId id) {
        WinNT.HRESULT hr = this.jnaSysobj.SetCurrentProcessId(new WinDef.ULONG((long)id.id));
        if (hr.equals((Object)COMUtilsExtra.E_UNEXPECTED)) {
            return;
        }
        if (hr.equals((Object)COMUtilsExtra.E_NOINTERFACE)) {
            return;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
    }

    @Override
    public int getNumberThreads() {
        WinDef.ULONGByReference pulNumber = new WinDef.ULONGByReference();
        WinNT.HRESULT hr = this.jnaSysobj.GetNumberThreads(pulNumber);
        if (hr.equals((Object)COMUtilsExtra.E_UNEXPECTED)) {
            return 0;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return pulNumber.getValue().intValue();
    }

    @Override
    public int getTotalNumberThreads() {
        WinDef.ULONGByReference pulTotal = new WinDef.ULONGByReference();
        WinDef.ULONGByReference pulLargestProcess = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSysobj.GetTotalNumberThreads(pulTotal, pulLargestProcess));
        return pulTotal.getValue().intValue();
    }

    @Override
    public List<DebugThreadId> getThreads(int start, int count) {
        if (count == 0) {
            return Collections.emptyList();
        }
        WinDef.ULONG ulStart = new WinDef.ULONG((long)start);
        WinDef.ULONG ulCount = new WinDef.ULONG((long)count);
        WinDef.ULONG[] aulIds = new WinDef.ULONG[count];
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSysobj.GetThreadIdsByIndex(ulStart, ulCount, aulIds, null));
        ArrayList<DebugThreadId> result = new ArrayList<DebugThreadId>(count);
        for (int i = 0; i < count; ++i) {
            result.add(new DebugThreadId(aulIds[i].intValue()));
        }
        return result;
    }

    @Override
    public DebugThreadId getThreadIdByHandle(long handle) {
        WinDef.ULONGLONG ullHandle = new WinDef.ULONGLONG(handle);
        WinDef.ULONGByReference pulId = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSysobj.GetThreadIdByHandle(ullHandle, pulId));
        return new DebugThreadId(pulId.getValue().intValue());
    }

    @Override
    public DebugThreadId getThreadIdBySystemId(int systemId) {
        WinDef.ULONG ulHandle = new WinDef.ULONG((long)systemId);
        WinDef.ULONGByReference pulId = new WinDef.ULONGByReference();
        WinNT.HRESULT hr = this.jnaSysobj.GetThreadIdBySystemId(ulHandle, pulId);
        if (hr.equals((Object)COMUtilsExtra.E_UNEXPECTED) || hr.equals((Object)COMUtilsExtra.E_NOTIMPLEMENTED) || hr.equals((Object)COMUtilsExtra.E_NOINTERFACE)) {
            return null;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return new DebugThreadId(pulId.getValue().intValue());
    }

    @Override
    public DebugProcessId getProcessIdByHandle(long handle) {
        WinDef.ULONGLONG ullHandle = new WinDef.ULONGLONG(handle);
        WinDef.ULONGByReference pulId = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSysobj.GetProcessIdByHandle(ullHandle, pulId));
        return new DebugProcessId(pulId.getValue().intValue());
    }

    @Override
    public DebugProcessId getProcessIdBySystemId(int systemId) {
        WinDef.ULONG ulHandle = new WinDef.ULONG((long)systemId);
        WinDef.ULONGByReference pulId = new WinDef.ULONGByReference();
        WinNT.HRESULT hr = this.jnaSysobj.GetProcessIdBySystemId(ulHandle, pulId);
        if (hr.equals((Object)COMUtilsExtra.E_UNEXPECTED) || hr.equals((Object)COMUtilsExtra.E_NOTIMPLEMENTED) || hr.equals((Object)COMUtilsExtra.E_NOINTERFACE)) {
            return null;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return new DebugProcessId(pulId.getValue().intValue());
    }

    @Override
    public int getNumberProcesses() {
        WinDef.ULONGByReference pulNumber = new WinDef.ULONGByReference();
        WinNT.HRESULT hr = this.jnaSysobj.GetNumberProcesses(pulNumber);
        if (hr.equals((Object)COMUtilsExtra.E_UNEXPECTED)) {
            return -1;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return pulNumber.getValue().intValue();
    }

    @Override
    public List<DebugProcessId> getProcesses(int start, int count) {
        if (count == 0) {
            return Collections.emptyList();
        }
        WinDef.ULONG ulStart = new WinDef.ULONG((long)start);
        WinDef.ULONG ulCount = new WinDef.ULONG((long)count);
        WinDef.ULONG[] aulIds = new WinDef.ULONG[count];
        COMUtils.checkRC((WinNT.HRESULT)this.jnaSysobj.GetProcessIdsByIndex(ulStart, ulCount, aulIds, null));
        ArrayList<DebugProcessId> result = new ArrayList<DebugProcessId>(count);
        for (int i = 0; i < count; ++i) {
            result.add(new DebugProcessId(aulIds[i].intValue()));
        }
        return result;
    }

    @Override
    public int getCurrentThreadSystemId() {
        WinDef.ULONGByReference pulSysId = new WinDef.ULONGByReference();
        WinNT.HRESULT hr = this.jnaSysobj.GetCurrentThreadSystemId(pulSysId);
        if (hr.equals((Object)COMUtilsExtra.E_UNEXPECTED) || hr.equals((Object)COMUtilsExtra.E_NOTIMPLEMENTED)) {
            return -1;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return pulSysId.getValue().intValue();
    }

    @Override
    public int getCurrentProcessSystemId() {
        WinDef.ULONGByReference pulSysId = new WinDef.ULONGByReference();
        WinNT.HRESULT hr = this.jnaSysobj.GetCurrentProcessSystemId(pulSysId);
        if (hr.equals((Object)COMUtilsExtra.E_UNEXPECTED) || hr.equals((Object)COMUtilsExtra.E_NOTIMPLEMENTED)) {
            return -1;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return pulSysId.getValue().intValue();
    }

    @Override
    public DebugSessionId getEventSystem() {
        throw new UnsupportedOperationException("Not supported by this interface");
    }

    @Override
    public DebugSessionId getCurrentSystemId() {
        throw new UnsupportedOperationException("Not supported by this interface");
    }

    @Override
    public void setCurrentSystemId(DebugSessionId id) {
        throw new UnsupportedOperationException("Not supported by this interface");
    }

    @Override
    public int getNumberSystems() {
        throw new UnsupportedOperationException("Not supported by this interface");
    }

    @Override
    public List<DebugSessionId> getSystems(int start, int count) {
        throw new UnsupportedOperationException("Not supported by this interface");
    }
}

