/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.dbgeng;

import agent.dbgeng.dbgeng.COMUtilsExtra;
import com.sun.jna.platform.win32.COM.COMException;
import ghidra.comm.util.BitmaskSet;
import ghidra.comm.util.BitmaskUniverse;
import ghidra.util.Msg;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public interface DebugDataSpaces {
    public int readVirtual(long var1, ByteBuffer var3, int var4);

    public int writeVirtual(long var1, ByteBuffer var3, int var4);

    public int readVirtualUncached(long var1, ByteBuffer var3, int var4);

    public int writeVirtualUncached(long var1, ByteBuffer var3, int var4);

    public int readPhysical(long var1, ByteBuffer var3, int var4);

    public int writePhysical(long var1, ByteBuffer var3, int var4);

    public int readControl(int var1, long var2, ByteBuffer var4, int var5);

    public int writeControl(int var1, long var2, ByteBuffer var4, int var5);

    public int readBusData(int var1, int var2, int var3, long var4, ByteBuffer var6, int var7);

    public int writeBusData(int var1, int var2, int var3, long var4, ByteBuffer var6, int var7);

    public int readIo(int var1, int var2, int var3, long var4, ByteBuffer var6, int var7);

    public int writeIo(int var1, int var2, int var3, long var4, ByteBuffer var6, int var7);

    public long readMsr(int var1);

    public void writeMsr(int var1, long var2);

    public int readDebuggerData(int var1, ByteBuffer var2, int var3);

    public DebugMemoryBasicInformation queryVirtual(long var1);

    default public Iterable<DebugMemoryBasicInformation> iterateVirtual(final long start) {
        return new Iterable<DebugMemoryBasicInformation>(){

            @Override
            public Iterator<DebugMemoryBasicInformation> iterator() {
                return new Iterator<DebugMemoryBasicInformation>(){
                    private long last;
                    private long offset;
                    private DebugMemoryBasicInformation next;
                    {
                        this.last = start;
                        this.offset = start;
                        this.next = this.doGetNext();
                    }

                    private DebugMemoryBasicInformation getNext() {
                        if (Long.compareUnsigned(this.last, this.offset) < 0) {
                            return this.doGetNext();
                        }
                        return null;
                    }

                    private DebugMemoryBasicInformation doGetNext() {
                        try {
                            DebugMemoryBasicInformation info = DebugDataSpaces.this.queryVirtual(this.offset);
                            this.last = this.offset;
                            if (info != null) {
                                this.offset += info.regionSize;
                            }
                            return info;
                        }
                        catch (COMException e) {
                            if (!COMUtilsExtra.isE_NOINTERFACE(e)) {
                                throw e;
                            }
                            return null;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public DebugMemoryBasicInformation next() {
                        DebugMemoryBasicInformation ret = this.next;
                        this.next = this.getNext();
                        return ret;
                    }
                };
            }
        };
    }

    public static class DebugMemoryBasicInformation {
        public final long baseAddress;
        public final long allocationBase;
        public final Set<PageProtection> allocationProtect;
        public final long regionSize;
        public final PageState state;
        public final Set<PageProtection> protect;
        public final PageType type;

        public DebugMemoryBasicInformation(long baseAddress, long allocationBase, BitmaskSet<PageProtection> allocationProtect, long regionSize, PageState state, BitmaskSet<PageProtection> protect, PageType type) {
            this.baseAddress = baseAddress;
            this.allocationBase = allocationBase;
            this.allocationProtect = Collections.unmodifiableSet(allocationProtect);
            this.regionSize = regionSize;
            this.state = state;
            this.protect = Collections.unmodifiableSet(protect);
            this.type = type;
        }

        public String toString() {
            return "<DebugMemoryBasicInformation:\n    baseAddress=" + Long.toHexString(this.baseAddress) + "h,\n    allocationBase=" + Long.toHexString(this.allocationBase) + "h,\n    allocationProtect=" + this.allocationProtect + ",\n    regionSize=" + Long.toHexString(this.regionSize) + "h,\n    state=" + this.state + ",\n    protect=" + this.protect + ",\n    type=" + this.type + "\n>";
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.baseAddress, this.allocationBase, this.allocationProtect, this.regionSize, this.state, this.protect, this.type});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DebugMemoryBasicInformation)) {
                return false;
            }
            DebugMemoryBasicInformation that = (DebugMemoryBasicInformation)obj;
            if (this.baseAddress != that.baseAddress) {
                return false;
            }
            if (this.allocationBase != that.allocationBase) {
                return false;
            }
            if (!this.allocationProtect.equals(that.allocationProtect)) {
                return false;
            }
            if (this.regionSize != that.regionSize) {
                return false;
            }
            if (this.state != that.state) {
                return false;
            }
            if (!this.protect.equals(that.protect)) {
                return false;
            }
            return this.type == that.type;
        }
    }

    public static enum PageType {
        NONE(0),
        IMAGE(0x1000000),
        MAPPED(262144),
        PRIVATE(131072);

        private final int val;

        private PageType(int val) {
            this.val = val;
        }

        public static PageType byValue(int val) {
            for (PageType type : PageType.values()) {
                if (type.val != val) continue;
                return type;
            }
            Msg.warn(PageType.class, (Object)("No such value: 0x" + Integer.toHexString(val)));
            return null;
        }
    }

    public static enum PageProtection implements BitmaskUniverse
    {
        NOACCESS(1, false, false, false),
        READONLY(2, true, false, false),
        READWRITE(4, true, true, false),
        WRITE_COPY(8, true, true, false),
        EXECUTE(16, false, false, true),
        EXECUTE_READ(32, true, false, true),
        EXECUTE_READWRITE(64, true, true, true),
        EXECUTE_WRITECOPY(128, true, true, true),
        GUARD(256, false, false, false),
        NOCACHE(512, false, false, false),
        WRITECOMBINE(1024, false, false, false);

        final int mask;
        final boolean isRead;
        final boolean isWrite;
        final boolean isExecute;

        private PageProtection(int mask, boolean isRead, boolean isWrite, boolean isExecute) {
            this.mask = mask;
            this.isRead = isRead;
            this.isWrite = isWrite;
            this.isExecute = isExecute;
        }

        public long getMask() {
            return this.mask;
        }

        public boolean isRead() {
            return this.isRead;
        }

        public boolean isWrite() {
            return this.isWrite;
        }

        public boolean isExecute() {
            return this.isExecute;
        }
    }

    public static enum PageState {
        COMMIT(4096),
        FREE(65536),
        RESERVE(8192);

        private final int val;

        private PageState(int val) {
            this.val = val;
        }

        public static PageState byValue(int val) {
            for (PageState state : PageState.values()) {
                if (state.val != val) continue;
                return state;
            }
            Msg.warn(PageState.class, (Object)("No such value: 0x" + Integer.toHexString(val)));
            return null;
        }
    }
}

