/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.pcode.BlockGraph;
import ghidra.program.model.pcode.BlockMap;
import ghidra.program.model.pcode.PcodeBlock;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class BlockMultiGoto
extends BlockGraph {
    protected ArrayList<PcodeBlock> targets = new ArrayList();

    public BlockMultiGoto() {
        this.blocktype = 5;
    }

    public void addGotoTarget(PcodeBlock target) {
        this.targets.add(target);
    }

    @Override
    public void saveXmlBody(Writer writer) throws IOException {
        super.saveXmlBody(writer);
        for (int i = 0; i < this.targets.size(); ++i) {
            PcodeBlock gototarget = this.targets.get(i);
            StringBuilder buf = new StringBuilder();
            buf.append("<target");
            PcodeBlock leaf = gototarget.getFrontLeaf();
            int depth = gototarget.calcDepth(leaf);
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buf, (String)"index", (long)leaf.getIndex());
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buf, (String)"depth", (long)depth);
            buf.append("/>\n");
            writer.write(buf.toString());
        }
    }

    @Override
    public void restoreXmlBody(XmlPullParser parser, BlockMap resolver) throws PcodeXMLException {
        super.restoreXmlBody(parser, resolver);
        while (parser.peek().isStart()) {
            XmlElement el = parser.start(new String[]{"target"});
            int target = SpecXmlUtils.decodeInt((String)el.getAttribute("index"));
            int depth = SpecXmlUtils.decodeInt((String)el.getAttribute("depth"));
            parser.end(el);
            resolver.addGotoRef(this, target, depth);
        }
    }
}

