/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.util.StringFormat;
import ghidra.util.StringUtilities;

public class StringRenderBuilder {
    public static final char DOUBLE_QUOTE = '\"';
    public static final char SINGLE_QUOTE = '\'';
    private static final int MAX_ASCII = 128;
    private StringBuilder sb = new StringBuilder();
    private boolean byteMode = true;
    private final char quoteChar;
    private final int charSize;

    public StringRenderBuilder(int charSize) {
        this(charSize, '\"');
    }

    public StringRenderBuilder(int charSize, char quoteChar) {
        this.charSize = charSize;
        this.quoteChar = quoteChar;
    }

    public boolean startsWithQuotedText() {
        return this.sb.length() > 0 && this.sb.charAt(0) == this.quoteChar;
    }

    public void addString(String str) {
        this.ensureTextMode();
        this.sb.append(str);
    }

    public void addEscapedChar(char ch) {
        this.ensureTextMode();
        this.sb.append("\\").append(ch);
    }

    public void addCodePointChar(int codePoint) {
        this.ensureTextMode();
        if (codePoint == this.quoteChar) {
            this.sb.append("\\");
        }
        this.sb.appendCodePoint(codePoint);
    }

    public void addCodePointValue(int codePoint) {
        this.ensureByteMode();
        String valStr = Integer.toHexString(codePoint).toUpperCase();
        valStr = valStr.length() < this.charSize * 2 ? StringFormat.padIt((String)valStr, (int)(this.charSize * 2), (char)'\u0000', (boolean)true) : valStr;
        this.sb.append(valStr);
    }

    public void addByteSeq(byte[] bytes) {
        if (bytes == null) {
            this.ensureByteMode();
            this.sb.append("???");
            return;
        }
        for (int i = 0; i < bytes.length; ++i) {
            this.ensureByteMode();
            String valStr = Integer.toHexString(bytes[i] & 0xFF).toUpperCase();
            if (valStr.length() < 2) {
                this.sb.append("0");
            }
            this.sb.append(valStr).append("h");
        }
    }

    public void addEscapedCodePoint(int codePoint) {
        char escapeChar;
        this.ensureTextMode();
        char c = codePoint < 128 ? (char)'x' : (escapeChar = Character.isBmpCodePoint(codePoint) ? (char)'u' : 'U');
        int cpDigits = codePoint < 128 ? 2 : (Character.isBmpCodePoint(codePoint) ? 4 : 8);
        String s = Integer.toHexString(codePoint).toUpperCase();
        this.sb.append("\\").append(escapeChar);
        this.sb.append(StringUtilities.pad((String)s, (char)'0', (int)cpDigits));
    }

    public String toString() {
        Object str = this.sb.toString();
        if (!this.byteMode) {
            str = (String)str + this.quoteChar;
        }
        return str;
    }

    private void ensureTextMode() {
        if (this.sb.length() == 0) {
            this.sb.append(this.quoteChar);
        } else if (this.byteMode) {
            this.sb.append(',');
            this.sb.append(this.quoteChar);
        }
        this.byteMode = false;
    }

    private void ensureByteMode() {
        if (!this.byteMode) {
            this.sb.append(this.quoteChar);
        }
        if (this.sb.length() > 0) {
            this.sb.append(',');
        }
        this.byteMode = true;
    }
}

