/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.TypedefDBAdapter;
import ghidra.util.UniversalID;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.Date;

class TypedefDBAdapterV1
extends TypedefDBAdapter {
    static final int VERSION = 1;
    static final int V1_TYPEDEF_DT_ID_COL = 0;
    static final int V1_TYPEDEF_NAME_COL = 1;
    static final int V1_TYPEDEF_CAT_COL = 2;
    static final int V1_TYPEDEF_SOURCE_ARCHIVE_ID_COL = 3;
    static final int V1_TYPEDEF_UNIVERSAL_DT_ID_COL = 4;
    static final int V1_TYPEDEF_SOURCE_SYNC_TIME_COL = 5;
    static final int V1_TYPEDEF_LAST_CHANGE_TIME_COL = 6;
    static final Schema V1_SCHEMA = new Schema(1, "Typedef ID", new Field[]{LongField.INSTANCE, StringField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE}, new String[]{"Data Type ID", "Name", "Category ID", "Source Archive ID", "Universal Data Type ID", "Source Sync Time", "Last Change Time"});
    private Table table;

    public TypedefDBAdapterV1(DBHandle handle, boolean create) throws VersionException, IOException {
        if (create) {
            this.table = handle.createTable("Typedefs", V1_SCHEMA, new int[]{2, 4});
        } else {
            this.table = handle.getTable("Typedefs");
            if (this.table == null) {
                throw new VersionException("Missing Table: Typedefs");
            }
            int version = this.table.getSchema().getVersion();
            if (version != 1) {
                String msg = "Expected version 1 for table Typedefs but got " + this.table.getSchema().getVersion();
                if (version < 1) {
                    throw new VersionException(msg, 1, true);
                }
                throw new VersionException(msg, 2, false);
            }
        }
    }

    @Override
    void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable("Typedefs");
    }

    @Override
    public DBRecord createRecord(long dataTypeID, String name, long categoryID, long sourceArchiveID, long sourceDataTypeID, long lastChangeTime) throws IOException {
        long tableKey = this.table.getKey();
        long key = DataTypeManagerDB.createKey(5, tableKey);
        DBRecord record = V1_SCHEMA.createRecord(key);
        record.setLongValue(0, dataTypeID);
        record.setString(1, name);
        record.setLongValue(2, categoryID);
        record.setLongValue(3, sourceArchiveID);
        record.setLongValue(4, sourceDataTypeID);
        record.setLongValue(5, lastChangeTime);
        record.setLongValue(6, lastChangeTime);
        this.table.putRecord(record);
        return record;
    }

    @Override
    public DBRecord getRecord(long typedefID) throws IOException {
        return this.table.getRecord(typedefID);
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return this.table.iterator();
    }

    @Override
    public void updateRecord(DBRecord record, boolean setLastChangeTime) throws IOException {
        if (setLastChangeTime) {
            record.setLongValue(6, new Date().getTime());
        }
        this.table.putRecord(record);
    }

    @Override
    public boolean removeRecord(long dataID) throws IOException {
        return this.table.deleteRecord(dataID);
    }

    @Override
    public Field[] getRecordIdsInCategory(long categoryID) throws IOException {
        return this.table.findRecords((Field)new LongField(categoryID), 2);
    }

    @Override
    Field[] getRecordIdsForSourceArchive(long archiveID) throws IOException {
        return this.table.findRecords((Field)new LongField(archiveID), 3);
    }

    @Override
    DBRecord getRecordWithIDs(UniversalID sourceID, UniversalID datatypeID) throws IOException {
        Field[] keys = this.table.findRecords((Field)new LongField(datatypeID.getValue()), 4);
        for (int i = 0; i < keys.length; ++i) {
            DBRecord record = this.table.getRecord(keys[i]);
            if (record.getLongValue(3) != sourceID.getValue()) continue;
            return record;
        }
        return null;
    }
}

