/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Algorithms {
    public static int binarySearchWithDuplicates(List data, Object searchItem, Comparator comparator) {
        int index = Collections.binarySearch(data, searchItem, comparator);
        index = index < 0 ? -index - 1 : Algorithms.findTrueStartIndex(searchItem, data, index, comparator);
        return index;
    }

    private static <T> int findTrueStartIndex(T searchItem, List<T> dataList, int startIndex, Comparator<T> comparator) {
        if (startIndex < 0) {
            return startIndex;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (comparator.compare(dataList.get(i), searchItem) == 0) continue;
            return ++i;
        }
        return 0;
    }

    public static <T> void bubbleSort(List<T> data, int low, int high, Comparator<T> comparator) {
        try {
            Algorithms.doBubbleSort(data, low, high, comparator, TaskMonitorAdapter.DUMMY_MONITOR);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    private static <T> void doBubbleSort(List<T> data, int low, int high, Comparator<T> comparator, TaskMonitor monitor) throws CancelledException {
        for (int i = high; i > low; --i) {
            monitor.checkCanceled();
            boolean swapped = false;
            for (int j = low; j < i; ++j) {
                if (comparator.compare(data.get(j), data.get(j + 1)) <= 0) continue;
                Collections.swap(data, j, j + 1);
                swapped = true;
            }
            if (swapped) continue;
            return;
        }
    }

    public static <T> void mergeSort(List<T> data, Comparator<T> c, TaskMonitor monitor) {
        ArrayList<T> aux = new ArrayList<T>(data);
        Algorithms.mergeSort(aux, data, 0, data.size(), c, monitor);
    }

    private static <T> void mergeSort(List<T> src, List<T> dest, int low, int high, Comparator<T> c, TaskMonitor monitor) {
        try {
            Algorithms.doMergeSort(src, dest, low, high, c, monitor);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    private static <T> void doMergeSort(List<T> src, List<T> dest, int low, int high, Comparator<T> c, TaskMonitor monitor) throws CancelledException {
        monitor.checkCanceled();
        monitor.setProgress((long)low);
        int length = high - low;
        if (length < 7) {
            Algorithms.doBubbleSort(dest, low, high - 1, c, monitor);
            return;
        }
        int mid = low + high >> 1;
        Algorithms.doMergeSort(dest, src, low, mid, c, monitor);
        Algorithms.doMergeSort(dest, src, mid, high, c, monitor);
        if (c.compare(src.get(mid - 1), src.get(mid)) <= 0) {
            for (int i = low; i < high; ++i) {
                monitor.checkCanceled();
                dest.set(i, src.get(i));
            }
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            monitor.checkCanceled();
            if (q >= high || p < mid && c.compare(src.get(p), src.get(q)) <= 0) {
                dest.set(i, src.get(p++));
                continue;
            }
            dest.set(i, src.get(q++));
        }
    }
}

