/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.JComboBox;

public class PropertySelector
extends JComboBox<String>
implements ItemListener {
    private PropertyEditor propertyEditor;
    private boolean notifyEditorOfChanges = true;

    public PropertySelector(PropertyEditor pe) {
        String[] tags;
        this.propertyEditor = pe;
        for (String tag : tags = this.propertyEditor.getTags()) {
            this.addItem(tag);
        }
        this.setSelectedIndex(0);
        this.setSelectedItem(this.propertyEditor.getAsText());
        this.addItemListener(this);
        this.invalidate();
        this.propertyEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String value = PropertySelector.this.propertyEditor.getAsText();
                if (!value.equals(PropertySelector.this.getSelectedItem())) {
                    PropertySelector.this.notifyEditorOfChanges = false;
                    try {
                        PropertySelector.this.setSelectedItem(value);
                    }
                    finally {
                        PropertySelector.this.notifyEditorOfChanges = true;
                    }
                }
            }
        });
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (!this.notifyEditorOfChanges) {
            return;
        }
        String s = (String)this.getSelectedItem();
        if (s != null) {
            this.propertyEditor.setAsText(s);
        }
    }
}

