/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Label
extends Control {
    int frameHandle;
    int labelHandle;
    int imageHandle;
    int boxHandle;
    ImageList imageList;
    Image image;
    String text;

    public Label(Composite parent, int style) {
        super(parent, Label.checkStyle(style));
    }

    static int checkStyle(int style) {
        if (((style |= 0x80000) & 2) != 0) {
            style = Label.checkBits(style, 512, 256, 0, 0, 0, 0);
            return Label.checkBits(style, 8, 4, 32, 0, 0, 0);
        }
        return Label.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    @Override
    void addRelation(Control control) {
        if (!control.isDescribedByLabel()) {
            return;
        }
        if (this.labelHandle == 0) {
            return;
        }
        control._getAccessible().addRelation(9, this._getAccessible());
        control.labelRelation = this;
    }

    @Override
    Point computeNativeSize(int h, int wHint, int hHint, boolean changed) {
        boolean wrapGTK3;
        int width = wHint;
        int height = hHint;
        boolean bl = wrapGTK3 = GTK.GTK3 && this.labelHandle != 0 && (this.style & 0x40) != 0 && GTK.gtk_widget_get_visible(this.labelHandle);
        if (wrapGTK3 && wHint == -1 && hHint == -1) {
            GtkRequisition naturalSize = new GtkRequisition();
            GtkRequisition minimumSize = new GtkRequisition();
            GTK.gtk_widget_get_preferred_size(h, minimumSize, naturalSize);
            width = minimumSize.width;
            height = naturalSize.height;
            return new Point(width, height);
        }
        return super.computeNativeSize(h, wHint, hHint, changed);
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        Point size;
        boolean fixWrap;
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        if ((this.style & 2) != 0) {
            if ((this.style & 0x100) != 0) {
                if (wHint == -1) {
                    wHint = 64;
                }
            } else if (hHint == -1) {
                hHint = 64;
            }
        }
        boolean bl = fixWrap = this.labelHandle != 0 && (this.style & 0x40) != 0 && GTK.gtk_widget_get_visible(this.labelHandle);
        if (fixWrap || this.frameHandle != 0) {
            this.forceResize();
        }
        if (fixWrap) {
            int labelLayout = GTK.gtk_label_get_layout(this.labelHandle);
            int pangoWidth = OS.pango_layout_get_width(labelLayout);
            if (wHint != -1) {
                OS.pango_layout_set_width(labelLayout, wHint * 1024);
            } else {
                OS.pango_layout_set_width(labelLayout, -1);
            }
            int[] w = new int[1];
            int[] h = new int[1];
            OS.pango_layout_get_pixel_size(labelLayout, w, h);
            OS.pango_layout_set_width(labelLayout, pangoWidth);
            if (this.frameHandle != 0) {
                int[] labelWidth = new int[1];
                int[] labelHeight = new int[1];
                GTK.gtk_widget_get_size_request(this.labelHandle, labelWidth, labelHeight);
                GTK.gtk_widget_set_size_request(this.labelHandle, 1, 1);
                size = this.computeNativeSize(this.frameHandle, -1, -1, changed);
                GTK.gtk_widget_set_size_request(this.labelHandle, labelWidth[0], labelHeight[0]);
                --size.y;
            } else {
                size = new Point(0, 0);
            }
            size.x = --size.x + (wHint == -1 ? w[0] : wHint);
            size.y = size.y + (hHint == -1 ? h[0] : hHint);
        } else if (this.frameHandle != 0) {
            int[] reqWidth = new int[1];
            int[] reqHeight = new int[1];
            GTK.gtk_widget_get_size_request(this.handle, reqWidth, reqHeight);
            GTK.gtk_widget_set_size_request(this.handle, wHint, hHint);
            size = this.computeNativeSize(this.frameHandle, -1, -1, changed);
            GTK.gtk_widget_set_size_request(this.handle, reqWidth[0], reqHeight[0]);
        } else {
            size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        }
        if (hHint == -1 && this.labelHandle != 0) {
            int layout = GTK.gtk_label_get_layout(this.labelHandle);
            int context = OS.pango_layout_get_context(layout);
            int lang = OS.pango_context_get_language(context);
            int font = this.getFontDescription();
            int metrics = OS.pango_context_get_metrics(context, font, lang);
            int ascent = OS.PANGO_PIXELS(OS.pango_font_metrics_get_ascent(metrics));
            int descent = OS.PANGO_PIXELS(OS.pango_font_metrics_get_descent(metrics));
            OS.pango_font_metrics_unref(metrics);
            int fontHeight = ascent + descent;
            if (GTK.GTK3) {
                int[] bufferBottom = new int[1];
                int[] bufferTop = new int[1];
                OS.g_object_get(this.labelHandle, OS.margin_bottom, bufferBottom, 0);
                OS.g_object_get(this.labelHandle, OS.margin_top, bufferTop, 0);
                fontHeight += bufferBottom[0] + bufferTop[0];
            } else {
                int[] bufferYpad = new int[1];
                OS.g_object_get(this.labelHandle, OS.ypad, bufferYpad, 0);
                fontHeight += 2 * bufferYpad[0];
            }
            if (this.frameHandle != 0) {
                fontHeight += 2 * this.getThickness((int)this.frameHandle).y;
                fontHeight += 2 * GTK.gtk_container_get_border_width(this.frameHandle);
            }
            size.y = Math.max(size.y, fontHeight);
        }
        return size;
    }

    @Override
    void createHandle(int index) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        GTK.gtk_widget_set_has_window(this.fixedHandle, true);
        if ((this.style & 2) != 0) {
            if ((this.style & 0x100) != 0) {
                this.handle = this.gtk_separator_new(0);
                if (this.handle != 0 && GTK.GTK_VERSION >= OS.VERSION(3, 20, 0)) {
                    GTK.gtk_widget_set_valign(this.handle, 3);
                }
            } else {
                this.handle = this.gtk_separator_new(1);
                if (this.handle != 0 && GTK.GTK_VERSION >= OS.VERSION(3, 20, 0)) {
                    GTK.gtk_widget_set_halign(this.handle, 3);
                }
            }
            if (this.handle == 0) {
                this.error(2);
            }
        } else {
            this.handle = GTK.gtk_event_box_new();
            if (this.handle == 0) {
                this.error(2);
            }
            this.boxHandle = this.gtk_box_new(0, false, 0);
            if (this.boxHandle == 0) {
                this.error(2);
            }
            this.labelHandle = GTK.gtk_label_new_with_mnemonic(null);
            if (this.labelHandle == 0) {
                this.error(2);
            }
            this.imageHandle = GTK.gtk_image_new();
            if (this.imageHandle == 0) {
                this.error(2);
            }
            GTK.gtk_container_add(this.handle, this.boxHandle);
            GTK.gtk_container_add(this.boxHandle, this.labelHandle);
            GTK.gtk_container_add(this.boxHandle, this.imageHandle);
            GTK.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, true, true, 0, 0);
            GTK.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, true, true, 0, 0);
        }
        if ((this.style & 0x800) != 0) {
            this.frameHandle = GTK.gtk_frame_new(null);
            if (this.frameHandle == 0) {
                this.error(2);
            }
            GTK.gtk_container_add(this.fixedHandle, this.frameHandle);
            GTK.gtk_container_add(this.frameHandle, this.handle);
            GTK.gtk_frame_set_shadow_type(this.frameHandle, 3);
        } else {
            GTK.gtk_container_add(this.fixedHandle, this.handle);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if ((this.style & 0x40) != 0) {
            GTK.gtk_label_set_line_wrap(this.labelHandle, true);
            GTK.gtk_label_set_line_wrap_mode(this.labelHandle, 2);
        }
        if (GTK.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
        this.setAlignment();
    }

    @Override
    void createWidget(int index) {
        super.createWidget(index);
        this.text = "";
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.frameHandle != 0) {
            this.display.removeWidget(this.frameHandle);
        }
        if (this.labelHandle != 0) {
            this.display.removeWidget(this.labelHandle);
        }
        if (this.imageHandle != 0) {
            this.display.removeWidget(this.imageHandle);
        }
        if (this.boxHandle != 0) {
            this.display.removeWidget(this.boxHandle);
        }
    }

    @Override
    int eventHandle() {
        return this.fixedHandle;
    }

    @Override
    int cssHandle() {
        if ((this.style & 2) == 0) {
            return this.labelHandle;
        }
        return this.handle;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return 0;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    @Override
    int getBorderWidthInPixels() {
        this.checkWidget();
        if (this.frameHandle != 0) {
            return this.getThickness((int)this.frameHandle).x;
        }
        return 0;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return "";
        }
        return this.text;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (this.labelHandle != 0) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.getClosure(32), false);
        }
    }

    @Override
    boolean isDescribedByLabel() {
        return false;
    }

    @Override
    boolean mnemonicHit(char key) {
        if (this.labelHandle == 0) {
            return false;
        }
        boolean result = super.mnemonicHit(this.labelHandle, key);
        if (result) {
            Control control = this;
            while (control.parent != null) {
                int index;
                Control[] children = control.parent._getChildren();
                for (index = 0; index < children.length && children[index] != control; ++index) {
                }
                if (++index < children.length && children[index].setFocus()) {
                    return result;
                }
                control = control.parent;
            }
        }
        return result;
    }

    @Override
    boolean mnemonicMatch(char key) {
        if (this.labelHandle == 0) {
            return false;
        }
        return this.mnemonicMatch(this.labelHandle, key);
    }

    @Override
    void register() {
        super.register();
        if (this.boxHandle != 0) {
            this.display.addWidget(this.boxHandle, this);
        }
        if (this.frameHandle != 0) {
            this.display.addWidget(this.frameHandle, this);
        }
        if (this.labelHandle != 0) {
            this.display.addWidget(this.labelHandle, this);
        }
        if (this.imageHandle != 0) {
            this.display.addWidget(this.imageHandle, this);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.boxHandle = 0;
        this.labelHandle = 0;
        this.imageHandle = 0;
        this.frameHandle = 0;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        this.image = null;
        this.text = null;
    }

    @Override
    void resizeHandle(int width, int height) {
        if (GTK.GTK3) {
            OS.swt_fixed_resize(GTK.gtk_widget_get_parent(this.fixedHandle), this.fixedHandle, width, height);
            int child = this.frameHandle != 0 ? this.frameHandle : this.handle;
            Point sizes = this.resizeCalculationsGTK3(child, width, height);
            width = sizes.x;
            height = sizes.y;
            OS.swt_fixed_resize(GTK.gtk_widget_get_parent(child), child, width, height);
        } else {
            GTK.gtk_widget_set_size_request(this.fixedHandle, width, height);
            GTK.gtk_widget_set_size_request(this.frameHandle != 0 ? this.frameHandle : this.handle, width, height);
        }
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        this.setAlignment();
    }

    void setAlignment() {
        if ((this.style & 0x4000) != 0) {
            if (GTK.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
                this.gtk_widget_set_align(this.labelHandle, 1, 1);
                this.gtk_label_set_align(0.0f, 0.0f);
                this.gtk_widget_set_align(this.imageHandle, 1, 3);
            } else {
                GTK.gtk_misc_set_alignment(this.labelHandle, 0.0f, 0.0f);
                GTK.gtk_misc_set_alignment(this.imageHandle, 0.0f, 0.5f);
            }
            GTK.gtk_label_set_justify(this.labelHandle, 0);
            return;
        }
        if ((this.style & 0x1000000) != 0) {
            if (GTK.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
                this.gtk_widget_set_align(this.labelHandle, 3, 1);
                this.gtk_label_set_align(0.5f, 0.0f);
                this.gtk_widget_set_align(this.imageHandle, 3, 3);
            } else {
                GTK.gtk_misc_set_alignment(this.labelHandle, 0.5f, 0.0f);
                GTK.gtk_misc_set_alignment(this.imageHandle, 0.5f, 0.5f);
            }
            GTK.gtk_label_set_justify(this.labelHandle, 2);
            return;
        }
        if ((this.style & 0x20000) != 0) {
            if (GTK.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
                this.gtk_widget_set_align(this.labelHandle, 2, 1);
                this.gtk_label_set_align(1.0f, 0.0f);
                this.gtk_widget_set_align(this.imageHandle, 2, 3);
            } else {
                GTK.gtk_misc_set_alignment(this.labelHandle, 1.0f, 0.0f);
                GTK.gtk_misc_set_alignment(this.imageHandle, 1.0f, 0.5f);
            }
            GTK.gtk_label_set_justify(this.labelHandle, 1);
            return;
        }
    }

    private void gtk_label_set_align(float xalign, float yalign) {
        GTK.gtk_label_set_xalign(this.labelHandle, xalign);
        GTK.gtk_label_set_yalign(this.labelHandle, yalign);
    }

    @Override
    void setBackgroundGdkColor(GdkColor color) {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        super.setBackgroundGdkColor(color);
        this.setBackgroundGdkColor(this.fixedHandle, color);
        if (this.labelHandle != 0) {
            this.setBackgroundGdkColor(this.labelHandle, color);
        }
        if (this.imageHandle != 0) {
            this.setBackgroundGdkColor(this.imageHandle, color);
        }
    }

    @Override
    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean fixWrap;
        boolean bl = fixWrap = resize && this.labelHandle != 0 && (this.style & 0x40) != 0;
        if (fixWrap) {
            GTK.gtk_widget_set_size_request(this.labelHandle, -1, -1);
        }
        int result = super.setBounds(x, y, width, height, move, resize);
        if (fixWrap) {
            GtkAllocation allocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(this.handle, allocation);
            int labelWidth = allocation.width;
            int labelHeight = allocation.height;
            GTK.gtk_widget_set_size_request(this.labelHandle, labelWidth, labelHeight);
            GtkRequisition requisition = new GtkRequisition();
            this.gtk_widget_get_preferred_size(this.labelHandle, requisition);
            GTK.gtk_widget_get_allocation(this.labelHandle, allocation);
            allocation.width = labelWidth;
            allocation.height = labelHeight;
            GTK.gtk_widget_size_allocate(this.labelHandle, allocation);
        }
        return result;
    }

    @Override
    void setFontDescription(int font) {
        super.setFontDescription(font);
        if (this.labelHandle != 0) {
            this.setFontDescription(this.labelHandle, font);
        }
        if (this.imageHandle != 0) {
            this.setFontDescription(this.imageHandle, font);
        }
        if (GTK.GTK3) {
            int originalDirection = (this.style & 0x4000000) != 0 ? 2 : 1;
            int tempDirection = (this.style & 0x4000000) != 0 ? 1 : 2;
            GTK.gtk_widget_set_direction(this.labelHandle, tempDirection);
            GTK.gtk_widget_set_direction(this.labelHandle, originalDirection);
        }
    }

    @Override
    void setForegroundGdkColor(GdkColor color) {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        super.setForegroundGdkColor(color);
        this.setForegroundColor(this.fixedHandle, color);
        if (this.labelHandle != 0) {
            this.setForegroundColor(this.labelHandle, color);
        }
        if (this.imageHandle != 0) {
            this.setForegroundColor(this.imageHandle, color);
        }
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA rgba) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        super.setForegroundGdkRGBA(rgba);
        this.setForegroundGdkRGBA(this.fixedHandle, rgba);
        if (this.labelHandle != 0) {
            this.setForegroundGdkRGBA(this.labelHandle, rgba);
        }
        if (this.imageHandle != 0) {
            this.setForegroundGdkRGBA(this.imageHandle, rgba);
        }
    }

    @Override
    void setOrientation(boolean create) {
        super.setOrientation(create);
        if ((this.style & 0x4000000) != 0 || !create) {
            int dir;
            int n = dir = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.labelHandle != 0) {
                GTK.gtk_widget_set_direction(this.labelHandle, dir);
            }
            if (this.imageHandle != 0) {
                GTK.gtk_widget_set_direction(this.imageHandle, dir);
            }
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.image = image;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        if (image != null) {
            this.imageList = new ImageList();
            int imageIndex = this.imageList.add(image);
            int pixbuf = this.imageList.getPixbuf(imageIndex);
            this.gtk_image_set_from_pixbuf(this.imageHandle, pixbuf);
            GTK.gtk_widget_hide(this.labelHandle);
            GTK.gtk_widget_show(this.imageHandle);
        } else {
            this.gtk_image_set_from_pixbuf(this.imageHandle, 0);
            GTK.gtk_widget_show(this.labelHandle);
            GTK.gtk_widget_hide(this.imageHandle);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.text = string;
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(chars, true);
        GTK.gtk_label_set_text_with_mnemonic(this.labelHandle, buffer);
        GTK.gtk_widget_hide(this.imageHandle);
        GTK.gtk_widget_show(this.labelHandle);
    }

    @Override
    void setWidgetBackground() {
        if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
            GdkRGBA rgba = (this.state & 0x2000) != 0 ? this.getBackgroundGdkRGBA() : null;
            super.setBackgroundGdkRGBA(this.handle, rgba);
        } else {
            super.setWidgetBackground();
        }
    }

    @Override
    void showWidget() {
        super.showWidget();
        if (this.frameHandle != 0) {
            GTK.gtk_widget_show(this.frameHandle);
        }
        if (this.labelHandle != 0) {
            GTK.gtk_widget_show(this.labelHandle);
        }
        if (this.boxHandle != 0) {
            GTK.gtk_widget_show(this.boxHandle);
        }
    }

    int gtk_separator_new(int orientation) {
        int separator = 0;
        separator = GTK.GTK3 ? GTK.gtk_separator_new(orientation) : (orientation == 0 ? GTK.gtk_hseparator_new() : GTK.gtk_vseparator_new());
        return separator;
    }

    @Override
    int windowProc(int handle, int arg0, int user_data) {
        switch (user_data) {
            case 18: {
                if (GTK.GTK_VERSION < OS.VERSION(3, 9, 0) || this.paintHandle() != handle) break;
                return this.gtk_draw(handle, arg0);
            }
        }
        return super.windowProc(handle, arg0, user_data);
    }
}

