/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import java.util.List;

enum Command {
    DIGIT_0,
    DIGIT_1,
    DIGIT_2,
    DIGIT_3,
    DIGIT_4,
    DIGIT_5,
    DIGIT_6,
    DIGIT_7,
    DIGIT_8,
    DIGIT_9,
    EQ,
    ADD,
    SUB,
    MUL,
    DIV,
    POW,
    ENTER,
    DOT,
    SIGN,
    EXP,
    EXP_SIGN,
    MANTISSA_SIGN,
    LOG10,
    TENTOX,
    LN,
    ETOX,
    SQRT,
    SQR,
    INVX,
    PI,
    FACT,
    ARC,
    HYP,
    EXCH_XY,
    STACK_UP,
    STACK_DOWN,
    LEFT_PAREN,
    RIGHT_PAREN,
    SIN,
    COS,
    TAN,
    ASIN,
    SINH,
    ASINH,
    ACOS,
    COSH,
    ACOSH,
    ATAN,
    TANH,
    ATANH,
    CLEAR_ALL,
    CLEAR_X,
    DEG_RAD,
    FORMAT,
    CUSTOM,
    MEM_TO_X,
    MEM_PLUS,
    EXCH_X_MEM,
    X_TO_MEM,
    MEM0,
    MEM1,
    UNDO,
    REDO,
    INFO,
    SETTINGS,
    COPY,
    PASTE,
    EXIT;

    static final Command[] mem;
    static final List<Command> rpnOnly;
    static final List<Command> algOnly;
    static final List<Command> trigBare;
    static final List<Command> trigAll;
    static final List<Command> invalidForCustomCommandSequence;

    static Command trigBareToDressed(Command command, boolean bl, boolean bl2) {
        switch (command) {
            case SIN: {
                if (bl) {
                    if (bl2) {
                        return ASINH;
                    }
                    return ASIN;
                }
                if (bl2) {
                    return SINH;
                }
                return SIN;
            }
            case COS: {
                if (bl) {
                    if (bl2) {
                        return ACOSH;
                    }
                    return ACOS;
                }
                if (bl2) {
                    return COSH;
                }
                return COS;
            }
            case TAN: {
                if (bl) {
                    if (bl2) {
                        return ATANH;
                    }
                    return ATAN;
                }
                if (bl2) {
                    return TANH;
                }
                return TAN;
            }
        }
        throw new RuntimeException("Function " + command.toString() + " is not a bare trig function (sin, cos, tan)");
    }

    static boolean isValidButton(Command command, Settings.Mode mode) {
        switch (mode) {
            case RPN: {
                return !algOnly.contains((Object)command);
            }
            case ALG: {
                return !rpnOnly.contains((Object)command);
            }
        }
        throw new RuntimeException("unknown mode " + mode.toString());
    }

    static {
        mem = new Command[]{MEM0, MEM1};
        rpnOnly = Arrays.asList(ENTER, STACK_UP, STACK_DOWN);
        algOnly = Arrays.asList(EQ, LEFT_PAREN, RIGHT_PAREN);
        trigBare = Arrays.asList(SIN, COS, TAN);
        trigAll = Arrays.asList(SIN, COS, TAN, ASIN, ACOS, ATAN, SINH, COSH, TANH, ASINH, ACOSH, ATANH);
        invalidForCustomCommandSequence = Arrays.asList(CUSTOM, DEG_RAD, FORMAT, UNDO, REDO, INFO, SETTINGS, COPY, PASTE);
    }
}

