/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.plugin.randlsb;

import com.openstego.desktop.OpenStegoConfig;
import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.plugin.lsb.LSBDataHeader;
import com.openstego.desktop.util.ImageHolder;
import com.openstego.desktop.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class RandomLSBInputStream
extends InputStream {
    private ImageHolder image = null;
    private LSBDataHeader dataHeader = null;
    private int channelBitsUsed = 1;
    private int imgWidth = 0;
    private int imgHeight = 0;
    private OpenStegoConfig config = null;
    private Set<String> bitRead = new HashSet<String>();
    private Random rand = null;

    public RandomLSBInputStream(ImageHolder image, OpenStegoConfig config) throws OpenStegoException {
        if (image == null || image.getImage() == null) {
            throw new OpenStegoException(null, "LSB", 2);
        }
        this.image = image;
        this.channelBitsUsed = 1;
        this.config = config;
        this.imgWidth = image.getImage().getWidth();
        this.imgHeight = image.getImage().getHeight();
        this.rand = new Random(StringUtil.passwordHash(config.getPassword()));
        this.readHeader();
    }

    private void readHeader() throws OpenStegoException {
        this.dataHeader = new LSBDataHeader(this, this.config);
        this.channelBitsUsed = this.dataHeader.getChannelBitsUsed();
    }

    @Override
    public int read() throws IOException {
        byte[] bitSet = new byte[8];
        int x = 0;
        int y = 0;
        int channel = 0;
        int bit = 0;
        for (int i = 0; i < 8; ++i) {
            String key;
            do {
                x = this.rand.nextInt(this.imgWidth);
                y = this.rand.nextInt(this.imgHeight);
                channel = this.rand.nextInt(3);
                bit = this.rand.nextInt(this.channelBitsUsed);
            } while (this.bitRead.contains(key = x + "_" + y + "_" + channel + "_" + bit));
            this.bitRead.add(key);
            bitSet[i] = (byte)this.getPixelBit(x, y, channel, bit);
        }
        return (bitSet[0] << 7) + (bitSet[1] << 6) + (bitSet[2] << 5) + (bitSet[3] << 4) + (bitSet[4] << 3) + (bitSet[5] << 2) + (bitSet[6] << 1) + (bitSet[7] << 0);
    }

    public LSBDataHeader getDataHeader() {
        return this.dataHeader;
    }

    public int getPixelBit(int x, int y, int channel, int bit) {
        return this.image.getImage().getRGB(x, y) >> channel * 8 + bit & 1;
    }
}

