/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.ui.internal.editor.BackgroundSaveWorkbook;

public class AutoSaveService
implements IStartup,
IWorkbenchListener,
IPropertyChangeListener {
    private IWorkbench workbench;

    private void checkState() {
        IPreferenceStore ps = CathyPlugin.getDefault().getPreferenceStore();
        boolean enabled = ps.getBoolean("autoSaveEnabled");
        int intervals = ps.getInt("autoSaveIntervals") * 60000;
        BackgroundSaveWorkbook.getInstance().reset(intervals, enabled);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("autoSaveEnabled".equals(property) || "autoSaveIntervals".equals(property)) {
            this.checkState();
        }
    }

    public void earlyStartup() {
        this.workbench = PlatformUI.getWorkbench();
        this.workbench.addWorkbenchListener((IWorkbenchListener)this);
        CathyPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.checkState();
    }

    public void postShutdown(IWorkbench workbench) {
        if (this.workbench == null) {
            return;
        }
        this.workbench.removeWorkbenchListener((IWorkbenchListener)this);
        this.workbench = null;
        CathyPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        BackgroundSaveWorkbook.getInstance().stopAll();
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        return true;
    }
}

