/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.comments;

import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.util.TopicIterator;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.comments.CommentAction;
import org.xmind.ui.internal.comments.CommentsPopup;
import org.xmind.ui.internal.comments.CommentsUtils;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MindMapUtils;

public class ShowPreTopicCommentsAction
extends CommentAction {
    private ITopic topic;
    private CommentsPopup dialog;

    public ShowPreTopicCommentsAction(IGraphicalEditor editor, CommentsPopup dialog) {
        super(editor);
        this.topic = dialog.getTopic();
        this.dialog = dialog;
        this.setId("org.xmind.ui.action.showPreTopicComments2");
        this.setText(MindMapMessages.ShowPreTopicComments_text);
        this.setImageDescriptor(MindMapUI.getImages().get("previous-topic.png", true));
        this.setToolTipText(MindMapMessages.ShowPreTopicComments_tooltip);
    }

    @Override
    public void run() {
        if (this.topic == null) {
            return;
        }
        ITopic previousTopic = this.findPreviousTopicWithComments(this.topic);
        if (previousTopic == null || previousTopic == this.topic) {
            return;
        }
        ITopicPart topicPart = MindMapUtils.findTopicPart((IViewer)this.getTargetEditor().getAdapter(IGraphicalViewer.class), previousTopic);
        if (topicPart == null) {
            return;
        }
        this.dialog.close();
        CommentsUtils.reveal(this.getTargetEditor(), previousTopic);
        CommentsPopup popup = new CommentsPopup(this.getTargetEditor().getSite().getWorkbenchWindow(), topicPart, true);
        popup.open();
    }

    private ITopic findPreviousTopicWithComments(ITopic sourceTopic) {
        ITopic nextTopic;
        ISheet sheet = sourceTopic.getOwnedSheet();
        if (sheet == null) {
            return null;
        }
        TopicIterator it = new TopicIterator(sheet.getRootTopic(), 1);
        boolean sourceFound = false;
        while (it.hasNext()) {
            nextTopic = it.next();
            if (!sourceFound) {
                if (nextTopic != sourceTopic) continue;
                sourceFound = true;
                continue;
            }
            if (!nextTopic.getOwnedWorkbook().getCommentManager().hasComments(nextTopic.getId())) continue;
            return nextTopic;
        }
        if (sourceFound) {
            it = new TopicIterator(sheet.getRootTopic(), 1);
            while (it.hasNext()) {
                nextTopic = it.next();
                if (nextTopic == sourceTopic) break;
                if (!nextTopic.getOwnedWorkbook().getCommentManager().hasComments(nextTopic.getId())) continue;
                return nextTopic;
            }
        }
        return null;
    }
}

