/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.clients;

import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.notestore.ClientUsageMetrics;
import com.evernote.edam.notestore.NoteCollectionCounts;
import com.evernote.edam.notestore.NoteEmailParameters;
import com.evernote.edam.notestore.NoteFilter;
import com.evernote.edam.notestore.NoteList;
import com.evernote.edam.notestore.NoteStore;
import com.evernote.edam.notestore.NoteVersionId;
import com.evernote.edam.notestore.NotesMetadataList;
import com.evernote.edam.notestore.NotesMetadataResultSpec;
import com.evernote.edam.notestore.RelatedQuery;
import com.evernote.edam.notestore.RelatedResult;
import com.evernote.edam.notestore.RelatedResultSpec;
import com.evernote.edam.notestore.SyncChunk;
import com.evernote.edam.notestore.SyncChunkFilter;
import com.evernote.edam.notestore.SyncState;
import com.evernote.edam.type.LazyMap;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.Resource;
import com.evernote.edam.type.ResourceAttributes;
import com.evernote.edam.type.SavedSearch;
import com.evernote.edam.type.SharedNotebook;
import com.evernote.edam.type.SharedNotebookRecipientSettings;
import com.evernote.edam.type.Tag;
import com.evernote.edam.userstore.AuthenticationResult;
import com.evernote.thrift.TException;
import com.evernote.thrift.protocol.TProtocol;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoteStoreClient {
    protected String token;
    protected final NoteStore.Client client;

    NoteStoreClient(TProtocol prot, String token) {
        if (prot == null || token == null) {
            throw new IllegalArgumentException("TProtocol and Token must not be null.");
        }
        this.client = new NoteStore.Client(prot);
        this.token = token;
    }

    NoteStoreClient(TProtocol iprot, TProtocol oprot, String token) {
        if (iprot == null || oprot == null || token == null) {
            throw new IllegalArgumentException("TProtocol and Token must not be null.");
        }
        this.client = new NoteStore.Client(iprot, oprot);
        this.token = token;
    }

    public NoteStore.Client getClient() {
        return this.client;
    }

    String getToken() {
        return this.token;
    }

    public SyncState getSyncState() throws EDAMUserException, EDAMSystemException, TException {
        return this.getClient().getSyncState(this.getToken());
    }

    public SyncState getSyncStateWithMetrics(ClientUsageMetrics clientMetrics) throws EDAMUserException, EDAMSystemException, TException {
        return this.getClient().getSyncStateWithMetrics(this.getToken(), clientMetrics);
    }

    public SyncChunk getSyncChunk(int afterUSN, int maxEntries, boolean fullSyncOnly) throws EDAMUserException, EDAMSystemException, TException {
        return this.getClient().getSyncChunk(this.getToken(), afterUSN, maxEntries, fullSyncOnly);
    }

    public SyncChunk getFilteredSyncChunk(int afterUSN, int maxEntries, SyncChunkFilter filter) throws EDAMUserException, EDAMSystemException, TException {
        return this.getClient().getFilteredSyncChunk(this.getToken(), afterUSN, maxEntries, filter);
    }

    public SyncState getLinkedNotebookSyncState(LinkedNotebook linkedNotebook) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().getLinkedNotebookSyncState(this.getToken(), linkedNotebook);
    }

    public SyncChunk getLinkedNotebookSyncChunk(LinkedNotebook linkedNotebook, int afterUSN, int maxEntries, boolean fullSyncOnly) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().getLinkedNotebookSyncChunk(this.getToken(), linkedNotebook, afterUSN, maxEntries, fullSyncOnly);
    }

    public List<Notebook> listNotebooks() throws EDAMUserException, EDAMSystemException, TException {
        return this.getClient().listNotebooks(this.getToken());
    }

    public Notebook getNotebook(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().getNotebook(this.getToken(), guid);
    }

    public Notebook getDefaultNotebook() throws EDAMUserException, EDAMSystemException, TException {
        return this.getClient().getDefaultNotebook(this.getToken());
    }

    public Notebook createNotebook(Notebook notebook) throws EDAMUserException, EDAMSystemException, TException {
        return this.getClient().createNotebook(this.getToken(), notebook);
    }

    public int updateNotebook(Notebook notebook) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().updateNotebook(this.getToken(), notebook);
    }

    public int expungeNotebook(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().expungeNotebook(this.getToken(), guid);
    }

    public List<Tag> listTags() throws EDAMUserException, EDAMSystemException, TException {
        return this.getClient().listTags(this.getToken());
    }

    public List<Tag> listTagsByNotebook(String notebookGuid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().listTagsByNotebook(this.getToken(), notebookGuid);
    }

    public Tag getTag(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().getTag(this.getToken(), guid);
    }

    public Tag createTag(Tag tag) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().createTag(this.getToken(), tag);
    }

    public int updateTag(Tag tag) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().updateTag(this.getToken(), tag);
    }

    public void untagAll(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        this.getClient().untagAll(this.getToken(), guid);
    }

    public int expungeTag(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().expungeTag(this.getToken(), guid);
    }

    public List<SavedSearch> listSearches() throws EDAMUserException, EDAMSystemException, TException {
        return this.getClient().listSearches(this.getToken());
    }

    public SavedSearch getSearch(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().getSearch(this.getToken(), guid);
    }

    public SavedSearch createSearch(SavedSearch search) throws EDAMUserException, EDAMSystemException, TException {
        return this.getClient().createSearch(this.getToken(), search);
    }

    public int updateSearch(SavedSearch search) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().updateSearch(this.getToken(), search);
    }

    public int expungeSearch(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().expungeSearch(this.getToken(), guid);
    }

    public NoteList findNotes(NoteFilter filter, int offset, int maxNotes) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().findNotes(this.getToken(), filter, offset, maxNotes);
    }

    public int findNoteOffset(NoteFilter filter, String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().findNoteOffset(this.getToken(), filter, guid);
    }

    public NotesMetadataList findNotesMetadata(NoteFilter filter, int offset, int maxNotes, NotesMetadataResultSpec resultSpec) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().findNotesMetadata(this.getToken(), filter, offset, maxNotes, resultSpec);
    }

    public NoteCollectionCounts findNoteCounts(NoteFilter filter, boolean withTrash) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().findNoteCounts(this.getToken(), filter, withTrash);
    }

    public Note getNote(String guid, boolean withContent, boolean withResourcesData, boolean withResourcesRecognition, boolean withResourcesAlternateData) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().getNote(this.getToken(), guid, withContent, withResourcesData, withResourcesRecognition, withResourcesAlternateData);
    }

    public LazyMap getNoteApplicationData(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().getNoteApplicationData(this.getToken(), guid);
    }

    public String getNoteApplicationDataEntry(String guid, String key) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().getNoteApplicationDataEntry(this.getToken(), guid, key);
    }

    public int setNoteApplicationDataEntry(String guid, String key, String value) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().setNoteApplicationDataEntry(this.getToken(), guid, key, value);
    }

    public int unsetNoteApplicationDataEntry(String guid, String key) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().unsetNoteApplicationDataEntry(this.getToken(), guid, key);
    }

    public String getNoteContent(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().getNoteContent(this.getToken(), guid);
    }

    public String getNoteSearchText(String guid, boolean noteOnly, boolean tokenizeForIndexing) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().getNoteSearchText(this.getToken(), guid, noteOnly, tokenizeForIndexing);
    }

    public String getResourceSearchText(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().getResourceSearchText(this.getToken(), guid);
    }

    public List<String> getNoteTagNames(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().getNoteTagNames(this.getToken(), guid);
    }

    public Note createNote(Note note) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().createNote(this.getToken(), note);
    }

    public Note updateNote(Note note) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().updateNote(this.getToken(), note);
    }

    public int deleteNote(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().deleteNote(this.getToken(), guid);
    }

    public int expungeNote(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().expungeNote(this.getToken(), guid);
    }

    public int expungeNotes(List<String> noteGuids) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().expungeNotes(this.getToken(), noteGuids);
    }

    public int expungeInactiveNotes() throws EDAMUserException, EDAMSystemException, TException {
        return this.getClient().expungeInactiveNotes(this.getToken());
    }

    public Note copyNote(String noteGuid, String toNotebookGuid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().copyNote(this.getToken(), noteGuid, toNotebookGuid);
    }

    public List<NoteVersionId> listNoteVersions(String noteGuid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().listNoteVersions(this.getToken(), noteGuid);
    }

    public Note getNoteVersion(String noteGuid, int updateSequenceNum, boolean withResourcesData, boolean withResourcesRecognition, boolean withResourcesAlternateData) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().getNoteVersion(this.getToken(), noteGuid, updateSequenceNum, withResourcesData, withResourcesRecognition, withResourcesAlternateData);
    }

    public Resource getResource(String guid, boolean withData, boolean withRecognition, boolean withAttributes, boolean withAlternateData) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().getResource(this.getToken(), guid, withData, withRecognition, withAttributes, withAlternateData);
    }

    public LazyMap getResourceApplicationData(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().getResourceApplicationData(this.getToken(), guid);
    }

    public String getResourceApplicationDataEntry(String guid, String key) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().getResourceApplicationDataEntry(this.getToken(), guid, key);
    }

    public int setResourceApplicationDataEntry(String guid, String key, String value) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().setResourceApplicationDataEntry(this.getToken(), guid, key, value);
    }

    public int unsetResourceApplicationDataEntry(String guid, String key) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().unsetResourceApplicationDataEntry(this.getToken(), guid, key);
    }

    public int updateResource(Resource resource) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().updateResource(this.getToken(), resource);
    }

    public byte[] getResourceData(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().getResourceData(this.getToken(), guid);
    }

    public Resource getResourceByHash(String noteGuid, byte[] contentHash, boolean withData, boolean withRecognition, boolean withAlternateData) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().getResourceByHash(this.getToken(), noteGuid, contentHash, withData, withRecognition, withAlternateData);
    }

    public byte[] getResourceRecognition(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().getResourceRecognition(this.getToken(), guid);
    }

    public byte[] getResourceAlternateData(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().getResourceAlternateData(this.getToken(), guid);
    }

    public ResourceAttributes getResourceAttributes(String guid) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().getResourceAttributes(this.getToken(), guid);
    }

    public Notebook getPublicNotebook(int userId, String publicUri) throws EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().getPublicNotebook(userId, publicUri);
    }

    public SharedNotebook createSharedNotebook(SharedNotebook sharedNotebook) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.getClient().createSharedNotebook(this.getToken(), sharedNotebook);
    }

    public int updateSharedNotebook(SharedNotebook sharedNotebook) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.getClient().updateSharedNotebook(this.getToken(), sharedNotebook);
    }

    public int sendMessageToSharedNotebookMembers(String notebookGuid, String messageText, List<String> recipients) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.getClient().sendMessageToSharedNotebookMembers(this.getToken(), notebookGuid, messageText, recipients);
    }

    public List<SharedNotebook> listSharedNotebooks() throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.getClient().listSharedNotebooks(this.getToken());
    }

    public int expungeSharedNotebooks(List<Long> sharedNotebookIds) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.getClient().expungeSharedNotebooks(this.getToken(), sharedNotebookIds);
    }

    public LinkedNotebook createLinkedNotebook(LinkedNotebook linkedNotebook) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.getClient().createLinkedNotebook(this.getToken(), linkedNotebook);
    }

    public int updateLinkedNotebook(LinkedNotebook linkedNotebook) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.getClient().updateLinkedNotebook(this.getToken(), linkedNotebook);
    }

    public List<LinkedNotebook> listLinkedNotebooks() throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.getClient().listLinkedNotebooks(this.getToken());
    }

    public int expungeLinkedNotebook(String guid) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.getClient().expungeLinkedNotebook(this.getToken(), guid);
    }

    public AuthenticationResult authenticateToSharedNotebook(String shareKey) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.getClient().authenticateToSharedNotebook(shareKey, this.getToken());
    }

    public SharedNotebook getSharedNotebookByAuth() throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.getClient().getSharedNotebookByAuth(this.getToken());
    }

    public void emailNote(NoteEmailParameters parameters) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        this.getClient().emailNote(this.getToken(), parameters);
    }

    public String shareNote(String guid) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.getClient().shareNote(this.getToken(), guid);
    }

    public void stopSharingNote(String guid) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        this.getClient().stopSharingNote(this.getToken(), guid);
    }

    public AuthenticationResult authenticateToSharedNote(String guid, String noteKey, String authenticationToken) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        return this.getClient().authenticateToSharedNote(guid, noteKey, authenticationToken);
    }

    public RelatedResult findRelated(RelatedQuery query, RelatedResultSpec resultSpec) throws EDAMUserException, EDAMSystemException, EDAMNotFoundException, TException {
        return this.getClient().findRelated(this.getToken(), query, resultSpec);
    }

    public void setSharedNotebookRecipientSettings(String authenticationToken, long sharedNotebookId, SharedNotebookRecipientSettings recipientSettings) throws EDAMUserException, EDAMNotFoundException, EDAMSystemException, TException {
        this.getClient().setSharedNotebookRecipientSettings(authenticationToken, sharedNotebookId, recipientSettings);
    }
}

