/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind.dashboard;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.xmind.seawind.internal.core.SeawindFile;
import org.xmind.seawind.internal.core.SeawindFolder;
import org.xmind.ui.internal.dashboard.pages.IDashboardContext;
import org.xmind.ui.internal.seawind.SeawindFolderManager;
import org.xmind.ui.internal.seawind.SeawindLibrary;
import org.xmind.ui.internal.seawind.SeawindMessages;
import org.xmind.ui.internal.seawind.SeawindUIPlugin;
import org.xmind.ui.internal.seawind.SeawindWorkbookRef;
import org.xmind.ui.internal.seawind.URIUtils;
import org.xmind.ui.internal.seawind.dashboard.CloudComparator;
import org.xmind.ui.internal.seawind.handlers.OpenCloudWorkbooksHandler;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.views.Page;

public class CloudMapFolderListPage
extends Page
implements SelectionListener {
    private static final DateFormat DATE_TIME_FORMAT = DateFormat.getDateTimeInstance(2, 3);
    private static final String IMAGE_EMPTY = "empty.png";
    private static final String IMAGE_MAP_SYCNED = "ic_map_finish.png";
    private static final String IMAGE_MAP_SYCN_ERROR = "ic_map_error.png";
    private static final String IMAGE_MAP_SYCNCING = "ic_map_sync.png";
    private static final String IMAGE_FOLDER_SYNCING = "ic_fd_sync.png";
    private static final String IMAGE_FOLDER_SYCNED = "ic_fd_finish.png";
    private static final String IMAGE_FOLDER_SYCN_ERROR = "ic_fd_error.png";
    private static final String IMAGE_MAP_DOWNLOADING = "ic_map_download.png";
    private static final String IMAGE_MAP_UPLOADING = "ic_map_upload.png";
    private static final String IMAGE_FOLDER_DOWNLOADING = "ic_fd_download.png";
    private static final String IMAGE_FOLDER_UPLOADING = "ic_fd_upload.png";
    private static final String IMAGE_MAP_DEFAULT = "list_view_map.png";
    private static final String COLOR_MODIFICATION_TIME = "#8f8f8f";
    private TableViewer folderListViewer;
    private IDashboardContext context;
    private SeawindLibrary library;
    private Object beforeSelection = null;
    private Object source;
    private LocalResourceManager resource;
    private static final String TABLE_BACKGROUND_GRAY = "#FAFAFA";
    private static final String TABLE_SELECTION_COLOR_BLUE = "#0070D8";
    private static final String IMAGE_TABLE_BACK_COLOR = "color.png";
    private static final int IN_SYNCING = 32;
    private static final int IN_SYNCED = 64;
    private static final int IN_SYNCERROR = 128;
    private static final int DOWNLOAD = 256;
    private static final int UPLOAD = 512;
    private static final int FOLDER_DOWNLOAD = 1024;
    private static final int FOLDER_UPLOAD = 2048;

    public CloudMapFolderListPage(IDashboardContext context, SeawindLibrary library) {
        this.context = context;
        this.library = library;
    }

    public Control doCreateControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalIndent = 0;
        composite.setLayoutData((Object)data);
        composite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.createFolderListViewer(composite);
        return composite;
    }

    private void createFolderListViewer(Composite composite) {
        if (this.resource == null) {
            this.resource = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        }
        Table folderTable = this.initFolderListViewer(composite);
        this.folderListViewer.setLabelProvider((IBaseLabelProvider)new ListPageLabelProvider());
        this.folderListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.configFolderTable(folderTable);
        this.context.registerContextMenu((Object)this.folderListViewer.getTable(), "org.xmind.ui.popup.dashboard.cloud.mapCollection");
    }

    private Table initFolderListViewer(Composite composite) {
        this.folderListViewer = new TableViewer(composite, 66306);
        Table folderTable = this.folderListViewer.getTable();
        TableLayout tableLayout = new TableLayout();
        folderTable.setLayout((Layout)tableLayout);
        GridData data = new GridData(4, 4, true, true);
        folderTable.setLayoutData((Object)data);
        folderTable.setHeaderVisible(true);
        folderTable.setLinesVisible(false);
        TableViewerColumn viewColumn = new TableViewerColumn(this.folderListViewer, 0);
        TableColumn nameCol = viewColumn.getColumn();
        nameCol.setResizable(true);
        nameCol.setMoveable(true);
        nameCol.setText("  " + SeawindMessages.CloudMapFolderListPage_Title_Name);
        nameCol.setWidth(700);
        nameCol.setImage((Image)this.resource.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor(IMAGE_EMPTY)));
        TableColumn typeCol = new TableColumn(folderTable, 0x1000000);
        typeCol.setWidth(100);
        typeCol.setText(SeawindMessages.CloudMapFolderListPage_Title_Type);
        TableColumn modificationTime = new TableColumn(folderTable, 0x1000000);
        modificationTime.setText(SeawindMessages.CloudMapFolderListPage_Title_LastModified);
        modificationTime.setWidth(200);
        modificationTime.addSelectionListener((SelectionListener)this);
        nameCol.addSelectionListener((SelectionListener)this);
        return folderTable;
    }

    private void configFolderTable(Table folderTable) {
        this.configViewerOpenListener();
        this.conifgMouseAction(folderTable);
        this.setTableHeight(folderTable);
        this.setTableBackColor(folderTable);
        this.aotuColWidth(folderTable);
        this.customTableSectionStyle(folderTable);
        this.setSection(folderTable);
        this.configTableFont(folderTable);
    }

    private void configTableFont(Table folderTable) {
        folderTable.setFont((Font)this.resource.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])folderTable.getFont().getFontData(), (int)0))));
    }

    private void setSection(Table folderTable) {
        folderTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CloudMapFolderListPage.this.context.setSelectionProvider(CloudMapFolderListPage.this.getAdapter(ISelectionProvider.class));
            }
        });
    }

    private void customTableSectionStyle(final Table folderTable) {
        folderTable.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                if ((event.detail & 2) == 0) {
                    return;
                }
                int clientWidth = folderTable.getClientArea().width;
                Color color = (Color)CloudMapFolderListPage.this.resource.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)CloudMapFolderListPage.TABLE_SELECTION_COLOR_BLUE));
                GC gc = event.gc;
                gc.setBackground(color);
                gc.fillRectangle(0, event.y, clientWidth, event.height);
                gc.setForeground(ColorConstants.white);
                gc.setBackground(color);
                event.detail &= 0xFFFFFFFD;
            }
        });
    }

    private void configViewerOpenListener() {
        this.folderListViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ISelection selection = event.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                Object element = ((IStructuredSelection)selection).getFirstElement();
                if (!CloudMapFolderListPage.this.canOperateMenu(element)) {
                    event.getViewer().setSelection(null);
                    return;
                }
                CloudMapFolderListPage.this.openSelectedItem(element);
            }
        });
    }

    private void conifgMouseAction(final Table folderTable) {
        folderTable.addMouseListener((MouseListener)new MouseAdapter(){
            FutureTask<Integer> task = null;
            Callable call = new Callable(){

                public Object call() throws Exception {
                    CloudMapFolderListPage.this.startRename();
                    return 0;
                }
            };

            public void mouseUp(MouseEvent e) {
                TableItem item = folderTable.getItem(new Point(e.x, e.y));
                if (item == null) {
                    return;
                }
                if (e.count == 2 || e.button == 3) {
                    CloudMapFolderListPage.this.beforeSelection = null;
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)CloudMapFolderListPage.this.folderListViewer.getSelection();
                if (selection.size() > 1) {
                    return;
                }
                Object currentSelection = selection.getFirstElement();
                if (CloudMapFolderListPage.this.beforeSelection != null && CloudMapFolderListPage.this.beforeSelection == currentSelection && e.count == 1) {
                    CloudMapFolderListPage.this.beforeSelection = null;
                    this.task = new FutureTask(this.call);
                    Thread thread = new Thread(this.task);
                    Display.getCurrent().timerExec(200, (Runnable)thread);
                } else if (e.count == 1) {
                    CloudMapFolderListPage.this.beforeSelection = currentSelection;
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (this.task != null && !this.task.isCancelled()) {
                    this.task.cancel(true);
                    this.task = null;
                }
            }
        });
    }

    private void setTableHeight(Table folderTable) {
        folderTable.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 30;
            }
        });
    }

    private void setTableBackColor(Table table) {
        table.setBackground((Color)this.resource.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)TABLE_BACKGROUND_GRAY)));
    }

    private void aotuColWidth(final Table table) {
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int oldTableWidth = 0;
                int i = 1;
                while (i < table.getColumnCount()) {
                    oldTableWidth += table.getColumn(i).getWidth();
                    ++i;
                }
                i = 1;
                while (i < table.getColumnCount()) {
                    int oldWidth = table.getColumn(i).getWidth();
                    table.getColumn(i).setWidth((table.getSize().x - table.getColumn(0).getWidth() - oldTableWidth) / (table.getColumnCount() - 1) + oldWidth - 9);
                    ++i;
                }
            }
        });
    }

    private void startRename() {
        this.source = ((IStructuredSelection)this.folderListViewer.getSelection()).getFirstElement();
        if (this.source == null) {
            return;
        }
        Table table = this.folderListViewer.getTable();
        final Text editor = new Text((Composite)table, 2052);
        final TableEditor tb_editor = new TableEditor(table);
        if (this.source instanceof SeawindFolder) {
            editor.setText(((SeawindFolder)this.source).getTitle());
        } else if (this.source instanceof SeawindWorkbookRef) {
            editor.setText(((SeawindWorkbookRef)((Object)this.source)).getName());
        }
        editor.setFont(table.getFont());
        editor.selectAll();
        editor.setFocus();
        TableItem item = table.getItem(table.getSelectionIndex());
        tb_editor.grabHorizontal = true;
        tb_editor.verticalAlignment = 0x1000000;
        tb_editor.minimumHeight = editor.getSize().y;
        tb_editor.minimumWidth = editor.getSize().x;
        tb_editor.setEditor((Control)editor, item, 0);
        editor.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (tb_editor != null) {
                    tb_editor.dispose();
                }
            }
        });
        editor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                CloudMapFolderListPage.this.finishRename(editor);
            }
        });
        editor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 27) {
                    CloudMapFolderListPage.this.finishRename(editor);
                }
            }
        });
    }

    private void finishRename(Text editor) {
        String newValue = editor.getText().trim();
        if (newValue.length() > 223) {
            newValue = newValue.substring(0, 223);
        }
        String oldValue = "";
        if (this.source instanceof SeawindFolder) {
            oldValue = ((SeawindFolder)this.source).getTitle().trim();
        } else if (this.source instanceof SeawindWorkbookRef) {
            oldValue = ((SeawindWorkbookRef)((Object)this.source)).getName().trim();
        }
        if ("".equals(newValue) || newValue == null || newValue.equals(oldValue)) {
            this.disposeEditor(editor);
            return;
        }
        this.updateFolderOrMapName(editor, newValue);
    }

    private void updateFolderOrMapName(Text editor, String newValue) {
        if (this.source instanceof SeawindFolder) {
            SeawindFolder folder = (SeawindFolder)this.source;
            SeawindUIPlugin.getSeawindLibrary().renameFolder(folder, newValue);
        } else if (this.source instanceof IWorkbookRef) {
            IWorkbookRef editable = (IWorkbookRef)this.source;
            SeawindUIPlugin.getSeawindLibrary().renameWorkbookRef(editable.getURI(), newValue);
        }
        this.folderListViewer.update(this.source, null);
        this.folderListViewer.refresh();
        this.disposeEditor(editor);
    }

    private void disposeEditor(Text editor) {
        Assert.isNotNull((Object)editor);
        editor.dispose();
    }

    private void openSelectedItem(Object element) {
        if (element instanceof SeawindFolder) {
            SeawindFolder folder = (SeawindFolder)element;
            this.library.setCurrentFolderPath(folder.getPath());
        } else if (element instanceof IWorkbookRef) {
            IWorkbookRef ref = (IWorkbookRef)element;
            OpenCloudWorkbooksHandler.openFile(ref.getURI());
        }
    }

    private boolean canOperateMenu(Object element) {
        if (element instanceof SeawindWorkbookRef) {
            return this.canSeawindWorkookOperate((SeawindWorkbookRef)((Object)element));
        }
        if (element instanceof SeawindFolder) {
            return this.canSeawindFolderOperate((SeawindFolder)element);
        }
        return false;
    }

    private boolean canSeawindWorkookOperate(SeawindWorkbookRef workbook) {
        return workbook.exists();
    }

    private boolean canSeawindFolderOperate(SeawindFolder folder) {
        if (folder.isEmpty()) {
            return true;
        }
        ArrayList<Object> elements = this.getInput(folder);
        Iterator<Object> iterator = elements.iterator();
        if (iterator.hasNext()) {
            Object obj = iterator.next();
            return this.canOperateMenu(obj);
        }
        return false;
    }

    public void setInput(SeawindFolder folder) {
        this.folderListViewer.setInput(this.getInput(folder));
    }

    private ArrayList<Object> getInput(SeawindFolder folder) {
        ArrayList<Object> elements = new ArrayList<Object>();
        if (folder instanceof SeawindFolder) {
            Set files = folder.getFiles();
            for (SeawindFile sf : files) {
                IWorkbookRef workbookRef = this.findWorkbookRef(sf.getIdentifier());
                if (workbookRef == null) continue;
                elements.add(workbookRef);
            }
            elements.addAll(folder.getFolders());
        }
        return elements;
    }

    private IWorkbookRef findWorkbookRef(String id) {
        Collection<IWorkbookRef> workbooks = this.library.getWorkbookRefs();
        for (IWorkbookRef workbook : workbooks) {
            if (!id.equals(URIUtils.getWorkbookIdFromURI(workbook.getURI()))) continue;
            return workbook;
        }
        return null;
    }

    public void refresh() {
        if (this.folderListViewer == null) {
            return;
        }
        if (this.context == null) {
            return;
        }
        String type = this.context.getPersistedState("sort_type");
        if (type == null || "".equals(type)) {
            type = "by_modification_time_desc";
        }
        if (this.folderListViewer.getControl().isDisposed()) {
            return;
        }
        this.folderListViewer.setComparator((ViewerComparator)CloudComparator.getComparatorAsType(type));
        this.folderListViewer.refresh();
    }

    public void widgetSelected(SelectionEvent e) {
        Table table = this.folderListViewer.getTable();
        this.setSortIndecator(e, table);
        String type = null;
        if (table.getColumn(0) == e.getSource()) {
            type = "by_name_asc";
        } else if (e.getSource() == table.getColumn(2)) {
            type = "by_modification_time_asc";
        }
        if (!this.folderListViewer.getControl().isDisposed() && type != null) {
            PlatformUI.getPreferenceStore().firePropertyChangeEvent("sort_type", null, (Object)type);
        }
    }

    private void setSortIndecator(SelectionEvent e, Table table) {
        int sortDirection = 1024;
        if (e.widget == table.getSortColumn()) {
            switch (table.getSortDirection()) {
                case 1024: {
                    sortDirection = 128;
                    break;
                }
                case 128: {
                    sortDirection = 1024;
                }
            }
        } else {
            table.setSortColumn((TableColumn)e.widget);
        }
        table.setSortDirection(sortDirection);
        table.setBackgroundImage((Image)this.resource.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor(IMAGE_TABLE_BACK_COLOR)));
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void update() {
        this.update(null);
    }

    public void update(Object[] elements) {
        if (elements == null) {
            SeawindFolderManager sfm = this.library.getSeawindFolderManager();
            String currentFolderPath = sfm.getCurrentFolderPath();
            this.setInput(sfm.getSeawindFolder(currentFolderPath));
            this.setRenameHelper(this.folderListViewer.getControl().getParent());
        } else {
            this.folderListViewer.update(elements, null);
        }
        this.refresh();
    }

    private void setRenameHelper(Composite parent) {
        Shell shellForRenameHelper = parent.getShell();
        shellForRenameHelper.setData("org.xmind.ui.seawind.dashboard.renameMapHelper", (Object)new Runnable(){

            @Override
            public void run() {
                CloudMapFolderListPage.this.startRename();
            }
        });
        shellForRenameHelper.setData("org.xmind.ui.seawind.dashboard.renameFolderHelper", (Object)new Runnable(){

            @Override
            public void run() {
                CloudMapFolderListPage.this.startRename();
            }
        });
        this.disposeRenameHelper(parent, shellForRenameHelper);
    }

    private void disposeRenameHelper(Composite parent, final Shell shellForRenameHelper) {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (shellForRenameHelper.isDisposed()) {
                    return;
                }
                shellForRenameHelper.setData("org.xmind.ui.seawind.dashboard.renameFolderHelper", null);
                shellForRenameHelper.setData("org.xmind.ui.seawind.dashboard.renameMapHelper", null);
            }
        });
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (this.folderListViewer != null && adapter.isAssignableFrom(this.folderListViewer.getClass())) {
            return adapter.cast(this.folderListViewer);
        }
        return (T)super.getAdapter(adapter);
    }

    private class ListPageLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private ListPageLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof SeawindFolder) {
                return this.initFolderElements(element, columnIndex);
            }
            if (element instanceof SeawindWorkbookRef) {
                return this.initMapElements(element, columnIndex);
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex != 0) {
                return null;
            }
            if (element instanceof SeawindFolder) {
                return this.getStateImageOfFolder((SeawindFolder)element);
            }
            if (element instanceof SeawindWorkbookRef) {
                return this.getStateImageOfWorkbook((SeawindWorkbookRef)((Object)element));
            }
            return (Image)CloudMapFolderListPage.this.resource.get((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor(CloudMapFolderListPage.IMAGE_MAP_DEFAULT));
        }

        private String initMapElements(Object element, int columnIndex) {
            SeawindWorkbookRef ref = (SeawindWorkbookRef)((Object)element);
            switch (columnIndex) {
                case 0: {
                    String name = ((IWorkbookRef)element).getName();
                    if (name == null) {
                        return "  " + SeawindMessages.SeawindWorkbookRef_UntitledWorkbookName;
                    }
                    return "  " + ref.getName();
                }
                case 1: {
                    return SeawindMessages.CloudMapFolderListPage_Type_Workbook;
                }
                case 2: {
                    return DATE_TIME_FORMAT.format(new Date(ref.getModificationTime()));
                }
            }
            return "";
        }

        private String initFolderElements(Object element, int columnIndex) {
            SeawindFolder folder = (SeawindFolder)element;
            switch (columnIndex) {
                case 0: {
                    return "  " + folder.getTitle();
                }
                case 1: {
                    return SeawindMessages.CloudMapFolderListPage_Type_Folder;
                }
                case 2: {
                    if (folder.getModificationTime() == 0L) break;
                    return DATE_TIME_FORMAT.format(new Date(folder.getModificationTime()));
                }
            }
            return "-";
        }

        private Image getStateImageOfWorkbook(SeawindWorkbookRef workbookRef) {
            ImageDescriptor imageDescriptor = null;
            switch (this.getStateOfObject((Object)workbookRef)) {
                case 64: {
                    imageDescriptor = SeawindUIPlugin.getImageDescriptor(CloudMapFolderListPage.IMAGE_MAP_SYCNED);
                    break;
                }
                case 128: {
                    imageDescriptor = SeawindUIPlugin.getImageDescriptor(CloudMapFolderListPage.IMAGE_MAP_SYCN_ERROR);
                    break;
                }
                case 256: {
                    imageDescriptor = SeawindUIPlugin.getImageDescriptor(CloudMapFolderListPage.IMAGE_MAP_DOWNLOADING);
                    break;
                }
                case 512: {
                    imageDescriptor = SeawindUIPlugin.getImageDescriptor(CloudMapFolderListPage.IMAGE_MAP_UPLOADING);
                    break;
                }
                default: {
                    imageDescriptor = SeawindUIPlugin.getImageDescriptor(CloudMapFolderListPage.IMAGE_MAP_SYCNCING);
                }
            }
            return (Image)CloudMapFolderListPage.this.resource.get((DeviceResourceDescriptor)imageDescriptor);
        }

        private Image getStateImageOfFolder(SeawindFolder folder) {
            ImageDescriptor imageDescriptor = null;
            switch (this.getSeawindFolderState(folder)) {
                case 64: {
                    imageDescriptor = SeawindUIPlugin.getImageDescriptor(CloudMapFolderListPage.IMAGE_FOLDER_SYCNED);
                    break;
                }
                case 32: {
                    imageDescriptor = SeawindUIPlugin.getImageDescriptor(CloudMapFolderListPage.IMAGE_FOLDER_SYNCING);
                    break;
                }
                case 128: {
                    imageDescriptor = SeawindUIPlugin.getImageDescriptor(CloudMapFolderListPage.IMAGE_FOLDER_SYCN_ERROR);
                    break;
                }
                case 1024: {
                    imageDescriptor = SeawindUIPlugin.getImageDescriptor(CloudMapFolderListPage.IMAGE_FOLDER_DOWNLOADING);
                    break;
                }
                case 2048: {
                    imageDescriptor = SeawindUIPlugin.getImageDescriptor(CloudMapFolderListPage.IMAGE_FOLDER_UPLOADING);
                    break;
                }
                default: {
                    imageDescriptor = SeawindUIPlugin.getImageDescriptor(CloudMapFolderListPage.IMAGE_FOLDER_SYNCING);
                }
            }
            return (Image)CloudMapFolderListPage.this.resource.get((DeviceResourceDescriptor)imageDescriptor);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int getStateOfObject(Object obj) {
            if (obj instanceof SeawindWorkbookRef) {
                SeawindWorkbookRef workbookRef = (SeawindWorkbookRef)((Object)obj);
                int syncStatusType = workbookRef.getSyncStatusType();
                if (!workbookRef.isSyncing()) return 64;
                if (workbookRef.getSyncError() != null) {
                    return 128;
                }
                if (syncStatusType == SeawindWorkbookRef.SYNC_STATUS_SYNCING) {
                    return 32;
                }
                if (syncStatusType == SeawindWorkbookRef.SYNC_STATUS_DOWNLOADING) {
                    return 256;
                }
                if (syncStatusType != SeawindWorkbookRef.SYNC_STATUS_UPLOADING) return 2;
                return 512;
            }
            if (!(obj instanceof SeawindFolder)) return 2;
            return this.getSeawindFolderState((SeawindFolder)obj);
        }

        private int getSeawindFolderState(SeawindFolder folder) {
            ArrayList objects = CloudMapFolderListPage.this.getInput(folder);
            int state = 0;
            for (Object obj : objects) {
                if ((0x80 & (state |= this.getStateOfObject(obj))) == 0) continue;
                return 128;
            }
            if (state == 256) {
                return 1024;
            }
            if (state == 512) {
                return 2048;
            }
            if (state == 32) {
                return 32;
            }
            return 64;
        }

        public Color getForeground(Object element, int columnIndex) {
            if (columnIndex == 2) {
                return (Color)CloudMapFolderListPage.this.resource.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)CloudMapFolderListPage.COLOR_MODIFICATION_TIME));
            }
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }
    }
}

