/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.GraphicalViewer;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.part.GraphicalRootEditPart;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRootPart;
import org.xmind.ui.gallery.GalleryPartFactory;
import org.xmind.ui.gallery.IDecorationContext;

public class GalleryViewer
extends GraphicalViewer
implements IDecorationContext {
    public static final String Horizontal = "org.xmind.ui.gallery.horizontal";
    public static final String Wrap = "org.xmind.ui.gallery.wrap";
    public static final String HideTitle = "org.xmind.ui.gallery.hideTitle";
    public static final String Layout = "org.xmind.ui.gallery.layout";
    public static final String ImageStretched = "stretched";
    public static final String ImageConstrained = "constrained";
    public static final String FrameContentSize = "org.xmind.ui.gallery.frameContentSize";
    public static final String PackFrameContent = "org.xmind.ui.gallery.packFrameContent";
    public static final String FlatFrames = "org.xmind.ui.gallery.flatFrames";
    public static final String SolidFrames = "org.xmind.ui.gallery.solidFrames";
    public static final String TitlePlacement = "org.xmind.ui.gallery.titlePlacement";
    public static final String SingleClickToOpen = "org.xmind.ui.gallery.singleClickToOpen";
    public static final String EmptySelectionIgnored = "org.xmind.ui.gallery.emptySelectionIgnored";
    public static final String CustomContentPaneDecorator = "org.xmind.ui.gallery.customDecorateContentPane";
    public static final String ContentPaneMargins = "org.xmind.ui.gallery.contentPaneMargins";
    public static final String ContentPaneBorderWidth = "org.xmind.ui.gallery.contentPaneBorderWidth";
    public static final String ContentPaneBorderColor = "org.xmind.ui.gallery.contentPaneBorderColor";
    public static final String ContentPaneSpaceCollaborativeEngine = "org.xmind.ui.gallery.contentPaneSpaceCollaborativeEngine";
    public static final String HorizontalLayout = "org.xmind.ui.gallery.horizontalLayout";
    public static final Integer TITLE_TOP = new Integer(8);
    public static final Integer TITLE_BOTTOM = new Integer(32);
    public static final Integer TITLE_LEFT = new Integer(1);
    public static final Integer TITLE_RIGHT = new Integer(4);
    public static final String POLICY_NAVIGABLE = "org.xmind.ui.gallery.editPolicy.navigable";
    public static final String POLICY_MOVABLE = "org.xmind.ui.gallery.editPolicy.movable";
    private IStructuredContentProvider contentProvider = null;
    private IBaseLabelProvider labelProvider = null;
    private ILabelProviderListener labelProviderListener = new GalleryLabelProviderListener();
    private List<IOpenListener> openListeners = null;
    private IFilter titleEditingApprover = null;
    private List<? extends IPart> toReveal;

    public GalleryViewer() {
        this.setPartFactory(GalleryPartFactory.getDefault());
        this.setRootPart((IRootPart)new GraphicalRootEditPart());
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IBaseLabelProvider.class.equals(adapter)) {
            return adapter.cast(this.getLabelProvider());
        }
        if (IStructuredContentProvider.class.equals(adapter)) {
            return adapter.cast(this.getContentProvider());
        }
        return (T)super.getAdapter(adapter);
    }

    protected Control internalCreateControl(Composite parent, int style) {
        Control control = super.internalCreateControl(parent, style);
        control.setBackground(parent.getDisplay().getSystemColor(25));
        return control;
    }

    public void update() {
        this.update(null);
    }

    public void update(Object[] elements) {
        if (elements == null) {
            IPart contents = this.getRootPart().getContents();
            if (contents.getStatus().isActive()) {
                contents.refresh();
            }
            for (IPart p : contents.getChildren()) {
                if (!p.getStatus().isActive()) continue;
                ((IGraphicalPart)p).refresh();
            }
        } else {
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                IPart p = this.findPart(element);
                if (p != null && p.getStatus().isActive()) {
                    ((IGraphicalPart)p).refresh();
                }
                ++n2;
            }
        }
    }

    public void setContentProvider(IStructuredContentProvider contentProvider) {
        IStructuredContentProvider oldContentProvider = this.contentProvider;
        this.contentProvider = contentProvider;
        if (oldContentProvider != null) {
            Object currentInput = this.getInput();
            oldContentProvider.inputChanged((Viewer)this, currentInput, null);
            oldContentProvider.dispose();
            contentProvider.inputChanged((Viewer)this, null, currentInput);
            this.refresh();
        }
    }

    public IStructuredContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public IBaseLabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new LabelProvider();
        }
        return this.labelProvider;
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        if (labelProvider == null) {
            return;
        }
        IBaseLabelProvider oldLabelProvider = this.labelProvider;
        if (labelProvider == oldLabelProvider) {
            return;
        }
        if (oldLabelProvider != null) {
            oldLabelProvider.removeListener(this.labelProviderListener);
        }
        this.labelProvider = labelProvider;
        this.labelProviderListener = new GalleryLabelProviderListener();
        labelProvider.addListener(this.labelProviderListener);
        this.refresh();
        if (oldLabelProvider != null) {
            oldLabelProvider.dispose();
        }
    }

    protected void contentsChanged(Object input, Object oldInput) {
        IStructuredContentProvider content = this.getContentProvider();
        if (content != null) {
            content.inputChanged((Viewer)this, oldInput, input);
        }
        super.contentsChanged(input, oldInput);
    }

    protected void handleDispose(DisposeEvent e) {
        if (this.contentProvider != null) {
            this.contentProvider.inputChanged((Viewer)this, this.getInput(), null);
            this.contentProvider.dispose();
            this.contentProvider = null;
        }
        if (this.labelProvider != null) {
            this.labelProvider.removeListener(this.labelProviderListener);
            this.labelProvider.dispose();
            this.labelProvider = null;
        }
        super.handleDispose(e);
    }

    public void centerHorizontal() {
        FigureCanvas fc = this.getCanvas();
        if (fc.isDisposed()) {
            return;
        }
        RangeModel horizontal = fc.getViewport().getHorizontalRangeModel();
        int h = (horizontal.getMaximum() - horizontal.getExtent() + horizontal.getMinimum()) / 2;
        fc.scrollToX(h);
    }

    public void addOpenListener(IOpenListener listener) {
        if (this.openListeners == null) {
            this.openListeners = new ArrayList<IOpenListener>();
        }
        this.openListeners.add(listener);
    }

    public void removeOpenListener(IOpenListener listener) {
        if (this.openListeners == null) {
            return;
        }
        this.openListeners.remove(listener);
    }

    protected void fireOpen(final OpenEvent event) {
        if (this.openListeners == null) {
            return;
        }
        Object[] objectArray = this.openListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object l = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IOpenListener)l).open(event);
                }
            });
            ++n2;
        }
    }

    protected void fireOpen() {
        this.fireOpen(new OpenEvent((Viewer)this, this.getSelection()));
    }

    protected void revealParts(List<? extends IPart> parts) {
        if (this.toReveal != null) {
            this.toReveal = parts;
        } else {
            this.toReveal = parts;
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (GalleryViewer.this.toReveal == null || GalleryViewer.this.getControl() == null || GalleryViewer.this.getControl().isDisposed()) {
                        return;
                    }
                    Rectangle r = null;
                    for (IPart p : GalleryViewer.this.toReveal) {
                        if (!(p instanceof IGraphicalPart)) continue;
                        r = Geometry.union(r, (Rectangle)((IGraphicalPart)p).getFigure().getBounds());
                    }
                    if (r != null) {
                        GalleryViewer.this.ensureVisible(r);
                    }
                    GalleryViewer.this.toReveal = null;
                }
            });
        }
    }

    public void setSelection(ISelection selection) {
        this.setSelection(selection, true);
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (this.getProperties().getBoolean(EmptySelectionIgnored, false) && selection.isEmpty()) {
            return;
        }
        super.setSelection(selection, reveal);
    }

    public IFilter getTitleEditingApprover() {
        return this.titleEditingApprover;
    }

    public void setTitleEditingApprover(IFilter titleEditingApprover) {
        this.titleEditingApprover = titleEditingApprover;
    }

    protected boolean isTitleEditable(IPart p) {
        return this.titleEditingApprover != null && this.titleEditingApprover.select((Object)p);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        return this.getProperties().get(key, defaultValue);
    }

    private class GalleryLabelProviderListener
    implements ILabelProviderListener {
        private GalleryLabelProviderListener() {
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            GalleryViewer.this.update(event.getElements());
        }
    }
}

