/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.ui.IActionBars;
import org.xmind.gef.ui.editor.IGlobalActionHandlerService;
import org.xmind.gef.ui.editor.IGlobalActionHandlerUpdater;
import org.xmind.gef.ui.editor.IGraphicalEditor;

public class GlobalActionHandlerService
implements IGlobalActionHandlerService,
IPageChangedListener {
    private IGraphicalEditor editor;
    private List<IActionBars> actionBarsList = null;

    public GlobalActionHandlerService(IGraphicalEditor editor) {
        this.editor = editor;
        editor.addPageChangedListener(this);
    }

    @Override
    public void addActionBars(IActionBars actionBars) {
        if (this.actionBarsList != null && this.actionBarsList.contains(actionBars)) {
            return;
        }
        if (this.actionBarsList == null) {
            this.actionBarsList = new ArrayList<IActionBars>();
        }
        this.actionBarsList.add(actionBars);
        this.update(actionBars, this.getUpdater());
    }

    @Override
    public void removeActionBars(IActionBars actionBars) {
        if (this.actionBarsList != null) {
            this.actionBarsList.remove(actionBars);
        }
        if (actionBars != null) {
            actionBars.clearGlobalActionHandlers();
            actionBars.updateActionBars();
        }
    }

    private IGlobalActionHandlerUpdater getUpdater() {
        return (IGlobalActionHandlerUpdater)this.editor.getAdapter(IGlobalActionHandlerUpdater.class);
    }

    private void update(IActionBars actionBars, IGlobalActionHandlerUpdater updater) {
        if (updater == null) {
            return;
        }
        updater.updateGlobalActionHandlers(actionBars);
    }

    public void pageChanged(PageChangedEvent event) {
        IGlobalActionHandlerUpdater updater;
        if (this.actionBarsList != null && (updater = this.getUpdater()) != null) {
            for (IActionBars actionBars : this.actionBarsList) {
                this.update(actionBars, updater);
            }
        }
    }
}

