/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.util;

import com.jgoodies.binding.beans.BeanUtils;
import com.jgoodies.binding.beans.Model;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public final class ChangeTracker
extends Model {
    public static final String PROPERTY_CHANGED = "changed";
    @Deprecated
    public static final String PROPERTYNAME_CHANGED = "changed";
    private final PropertyChangeListener updateHandler = new UpdateHandler();
    private boolean changed = false;

    public boolean isChanged() {
        return this.changed;
    }

    public void reset() {
        this.setChanged(false);
    }

    private void setChanged(boolean newValue) {
        boolean oldValue = this.isChanged();
        this.changed = newValue;
        this.firePropertyChange("changed", oldValue, newValue);
    }

    public void observe(Object bean, String propertyName) {
        Preconditions.checkNotNull((Object)bean, (String)"The bean must not be null.");
        Preconditions.checkNotNull((Object)propertyName, (String)"The property name must not be null.");
        BeanUtils.addPropertyChangeListener(bean, propertyName, this.updateHandler);
    }

    public void observe(ValueModel valueModel) {
        Preconditions.checkNotNull((Object)valueModel, (String)"The ValueModel must not be null.");
        valueModel.addValueChangeListener(this.updateHandler);
    }

    public void retractInterestFor(Object bean, String propertyName) {
        Preconditions.checkNotNull((Object)bean, (String)"The bean must not be null.");
        Preconditions.checkNotNull((Object)propertyName, (String)"The property name must not be null.");
        BeanUtils.removePropertyChangeListener(bean, propertyName, this.updateHandler);
    }

    public void retractInterestFor(ValueModel valueModel) {
        Preconditions.checkNotNull((Object)valueModel, (String)"The ValueModel must not be null.");
        valueModel.removeValueChangeListener(this.updateHandler);
    }

    private final class UpdateHandler
    implements PropertyChangeListener {
        private UpdateHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (!"changed".equals(propertyName) || ((Boolean)evt.getNewValue()).booleanValue()) {
                ChangeTracker.this.setChanged(true);
            }
        }
    }
}

