/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.swing;

import java.awt.Color;
import java.util.Map;
import java.util.TreeMap;

public class ColorUtils {
    private static int[] colorShorthandTable = new int[]{0, 17, 34, 51, 68, 85, 102, 119, 136, 153, 170, 187, 204, 221, 238, 255};
    private static Map colorNamesMap = new TreeMap();

    public static Color toColor(String str) {
        switch (str.charAt(0)) {
            case '(': {
                int red = ColorUtils.nextColorInt(str, 1);
                int index = str.indexOf(44);
                int green = ColorUtils.nextColorInt(str, index + 1);
                index = str.indexOf(44, index + 1);
                int blue = ColorUtils.nextColorInt(str, index + 1);
                return new Color(red, green, blue);
            }
            case '#': {
                if (str.length() == 4) {
                    return new Color(ColorUtils.getShorthandValue(str.charAt(1)), ColorUtils.getShorthandValue(str.charAt(2)), ColorUtils.getShorthandValue(str.charAt(3)));
                }
                return new Color(Integer.parseInt(str.substring(1), 16));
            }
        }
        if (Character.isDigit(str.charAt(0))) {
            int red = ColorUtils.nextColorInt(str, 0);
            int index = str.indexOf(44);
            int green = ColorUtils.nextColorInt(str, index + 1);
            index = str.indexOf(44, index + 1);
            int blue = ColorUtils.nextColorInt(str, index + 1);
            return new Color(red, green, blue);
        }
        return (Color)colorNamesMap.get(str);
    }

    private static int nextColorInt(String str, int index) {
        char c;
        int colorLength;
        char c2;
        while (index < str.length() && ('0' > (c2 = str.charAt(index)) || c2 > '9')) {
            ++index;
        }
        for (colorLength = index; colorLength < index + 3 && (c = str.charAt(colorLength)) >= '0' && '9' >= c; ++colorLength) {
        }
        return Integer.parseInt(str.substring(index, colorLength));
    }

    private static int getShorthandValue(char c) {
        if ('A' <= (c = Character.toUpperCase(c)) && c <= 'F') {
            return colorShorthandTable[c - 65 + 10];
        }
        return colorShorthandTable[c - 48];
    }

    public static Color oposite(Color a) {
        return new Color(255 - a.getRed(), 255 - a.getGreen(), 255 - a.getBlue(), a.getAlpha());
    }

    public static Color subtract(Color a, Color b) {
        return new Color(Math.max(0, Math.min(255, a.getRed() - b.getRed())), Math.max(0, Math.min(255, a.getGreen() - b.getGreen())), Math.max(0, Math.min(255, a.getBlue() - b.getBlue())));
    }

    public static String toString(Color c) {
        String colString = Integer.toHexString(c.getRGB() & 0xFFFFFF).toUpperCase();
        return "#000000".substring(0, 7 - colString.length()).concat(colString);
    }

    public static Color getTranslucentColor(Color c, int alpha) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    public static Color getSimiliarColor(Color color, float factor) {
        return new Color(ColorUtils.between((int)((float)color.getRed() * factor), 0, 255), ColorUtils.between((int)((float)color.getGreen() * factor), 0, 255), ColorUtils.between((int)((float)color.getBlue() * factor), 0, 255), color.getAlpha());
    }

    private static int between(int v, int min, int max) {
        return Math.max(min, Math.min(v, max));
    }

    public static Color getColor(Color color, float factor) {
        float[] hsbValues = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbValues);
        return Color.getHSBColor(hsbValues[0], hsbValues[1], hsbValues[2] * factor);
    }

    public static Color[] mixColors(Color c) {
        Color[] result = new Color[9];
        result[0] = c;
        double[] hs = ColorUtils.RGBtoHSV(c);
        double[] y = new double[3];
        double[] yx = new double[3];
        double[] p = new double[3];
        double[] pr = new double[3];
        p[0] = y[0] = hs[0];
        p[1] = y[1] = hs[1];
        if (hs[2] > 70.0) {
            y[2] = hs[2] - 30.0;
            p[2] = hs[2] - 15.0;
        } else {
            y[2] = hs[2] + 30.0;
            p[2] = hs[2] + 15.0;
        }
        result[1] = ColorUtils.HSVtoRGB(p);
        result[2] = ColorUtils.HSVtoRGB(y);
        if (hs[0] >= 0.0 && hs[0] < 30.0) {
            yx[0] = y[0] = hs[0] + 20.0;
            pr[0] = y[0];
            yx[1] = y[1] = hs[1];
            pr[1] = y[1];
            y[2] = hs[2];
            if (hs[2] > 70.0) {
                yx[2] = hs[2] - 30.0;
                pr[2] = hs[2] - 15.0;
            } else {
                yx[2] = hs[2] + 30.0;
                pr[2] = hs[2] + 15.0;
            }
        }
        if (hs[0] >= 30.0 && hs[0] < 60.0) {
            yx[0] = y[0] = hs[0] + 150.0;
            pr[0] = y[0];
            y[1] = ColorUtils.minMax(hs[1] - 30.0, 0.0, 100.0);
            y[2] = ColorUtils.minMax(hs[2] - 20.0, 0.0, 100.0);
            pr[1] = yx[1] = ColorUtils.minMax(hs[1] - 70.0, 0.0, 100.0);
            yx[2] = ColorUtils.minMax(hs[2] + 20.0, 0.0, 100.0);
            pr[2] = hs[2];
        }
        if (hs[0] >= 60.0 && hs[0] < 180.0) {
            yx[0] = y[0] = hs[0] - 40.0;
            pr[0] = y[0];
            yx[1] = y[1] = hs[1];
            pr[1] = y[1];
            y[2] = hs[2];
            if (hs[2] > 70.0) {
                yx[2] = hs[2] - 30.0;
                pr[2] = hs[2] - 15.0;
            } else {
                yx[2] = hs[2] + 30.0;
                pr[2] = hs[2] + 15.0;
            }
        }
        if (hs[0] >= 180.0 && hs[0] < 220.0) {
            pr[0] = yx[0] = hs[0] - 170.0;
            y[0] = hs[0] - 160.0;
            yx[1] = y[1] = hs[1];
            pr[1] = y[1];
            y[2] = hs[2];
            if (hs[2] > 70.0) {
                yx[2] = hs[2] - 30.0;
                pr[2] = hs[2] - 15.0;
            } else {
                yx[2] = hs[2] + 30.0;
                pr[2] = hs[2] + 15.0;
            }
        }
        if (hs[0] >= 220.0 && hs[0] < 300.0) {
            yx[0] = y[0] = hs[0];
            pr[0] = y[0];
            yx[1] = y[1] = ColorUtils.minMax(hs[1] - 60.0, 0.0, 100.0);
            pr[1] = y[1];
            y[2] = hs[2];
            if (hs[2] > 70.0) {
                yx[2] = hs[2] - 30.0;
                pr[2] = hs[2] - 15.0;
            } else {
                yx[2] = hs[2] + 30.0;
                pr[2] = hs[2] + 15.0;
            }
        }
        if (hs[0] >= 300.0) {
            if (hs[1] > 50.0) {
                yx[1] = y[1] = hs[1] - 40.0;
                pr[1] = y[1];
            } else {
                yx[1] = y[1] = hs[1] + 40.0;
                pr[1] = y[1];
            }
            yx[0] = y[0] = (hs[0] + 20.0) % 360.0;
            pr[0] = y[0];
            y[2] = hs[2];
            if (hs[2] > 70.0) {
                yx[2] = hs[2] - 30.0;
                pr[2] = hs[2] - 15.0;
            } else {
                yx[2] = hs[2] + 30.0;
                pr[2] = hs[2] + 15.0;
            }
        }
        result[3] = ColorUtils.HSVtoRGB(y);
        result[4] = ColorUtils.HSVtoRGB(pr);
        result[5] = ColorUtils.HSVtoRGB(yx);
        y[1] = 0.0;
        y[0] = 0.0;
        y[2] = 100.0 - hs[2];
        result[6] = ColorUtils.HSVtoRGB(y);
        y[2] = hs[2];
        result[7] = ColorUtils.HSVtoRGB(y);
        pr[1] = 0.0;
        pr[0] = 0.0;
        pr[2] = hs[2] >= 50.0 ? 0.0 : 100.0;
        result[8] = ColorUtils.HSVtoRGB(pr);
        return result;
    }

    private static double minMax(double x, double min, double max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    public static Color HSVtoRGB(double[] data) {
        if (data == null || data.length != 3) {
            throw new IllegalArgumentException("data must be an array of 3 items and must not be null!");
        }
        return ColorUtils.HSVtoRGB(data[0], data[1], data[2]);
    }

    public static Color HSVtoRGB(double h, double s, double v) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (s == 0.0) {
            g = b = (int)Math.round(v * 2.55);
            r = b;
        } else {
            double i = Math.floor(h /= 60.0);
            double f = h - i;
            int p = (int)Math.round(255.0 * ((v /= 100.0) * (1.0 - (s /= 100.0))));
            int q = (int)Math.round(255.0 * (v * (1.0 - s * f)));
            int t = (int)Math.round(255.0 * (v * (1.0 - s * (1.0 - f))));
            int v2 = (int)Math.round(255.0 * v);
            switch ((int)i) {
                case 0: {
                    r = v2;
                    g = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = v2;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = v2;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = v2;
                    break;
                }
                case 4: {
                    r = t;
                    g = p;
                    b = v2;
                    break;
                }
                default: {
                    r = v2;
                    g = p;
                    b = q;
                }
            }
        }
        return new Color(r, g, b);
    }

    public static double[] RGBtoHSV(Color c) {
        double s;
        double[] hsv = new double[3];
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int min = Math.min(Math.min(r, g), b);
        int max = Math.max(Math.max(r, g), b);
        int delta = max - min;
        double h = 0.0;
        double v = 100 * max / 255;
        if (delta == 0) {
            s = 0.0;
            h = 0.0;
        } else {
            s = 100 * delta / max;
            double del_r = 100 * ((max - r) / 6 + max / 2) / delta;
            double del_g = 100 * ((max - g) / 6 + max / 2) / delta;
            double del_b = 100 * ((max - b) / 6 + max / 2) / delta;
            if (r == max) {
                h = 60 * (g - b) / delta;
            } else if (g == max) {
                h = 120 + 60 * (b - r) / delta;
            } else if (b == max) {
                h = 240 + 60 * (r - g) / delta;
            }
            if (h < 0.0) {
                h += 360.0;
            }
        }
        hsv[0] = h;
        hsv[1] = s;
        hsv[2] = v;
        return hsv;
    }

    static {
        colorNamesMap.put("white", new Color(0xFFFFFF));
        colorNamesMap.put("lightGray", new Color(0xC0C0C0));
        colorNamesMap.put("gray", new Color(0x808080));
        colorNamesMap.put("darkGray", new Color(0x404040));
        colorNamesMap.put("black", new Color(0));
        colorNamesMap.put("red", new Color(0xFF0000));
        colorNamesMap.put("pink", new Color(0xFFAFAF));
        colorNamesMap.put("orange", new Color(16762880));
        colorNamesMap.put("yellow", new Color(0xFFFF00));
        colorNamesMap.put("green", new Color(65280));
        colorNamesMap.put("magenta", new Color(0xFF00FF));
        colorNamesMap.put("cyan", new Color(65535));
        colorNamesMap.put("blue", new Color(255));
    }
}

