/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser.filters;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import org.fife.ui.rtextfilechooser.Utilities;

public class ExtensionFileFilter
extends FileFilter {
    public static final int SYSTEM_CASE_CHECK = 0;
    public static final int CASE_CHECK = 1;
    public static final int NO_CASE_CHECK = 2;
    private String description;
    private String[] extensions;
    private boolean caseCheck;

    public ExtensionFileFilter(String description, String extension) {
        this(description, extension, 0);
    }

    public ExtensionFileFilter(String description, String[] extensions) {
        this(description, extensions, 0);
    }

    public ExtensionFileFilter(String description, String extension, int caseCheck) {
        this(description, extension, caseCheck, true);
    }

    public ExtensionFileFilter(String description, String[] extensions, int caseCheck) {
        this(description, extensions, caseCheck, true);
    }

    public ExtensionFileFilter(String description, String extension, int caseCheck, boolean showExtensions) {
        this.extensions = new String[1];
        this.caseCheck = ExtensionFileFilter.doCaseCheck(caseCheck);
        this.extensions[0] = this.caseCheck ? extension : extension.toLowerCase();
        StringBuffer buf = new StringBuffer(description);
        if (showExtensions) {
            buf.append(" (*.").append(this.extensions[0]).append(")");
        }
        this.description = buf.toString();
    }

    public ExtensionFileFilter(String description, String[] extensions, int caseCheck, boolean showExtensions) {
        int extCount = extensions == null ? 0 : extensions.length;
        this.extensions = new String[extCount];
        this.caseCheck = ExtensionFileFilter.doCaseCheck(caseCheck);
        if (this.caseCheck) {
            System.arraycopy(extensions, 0, this.extensions, 0, extCount);
        } else {
            for (int i = 0; i < extCount; ++i) {
                this.extensions[i] = extensions[i].toLowerCase();
            }
        }
        StringBuffer buf = new StringBuffer(description);
        if (showExtensions && extCount > 0) {
            buf.append(" (");
            for (int i = 0; i < extCount - 1; ++i) {
                buf.append("*.").append(extensions[i]).append(", ");
            }
            buf.append("*.").append(extensions[extCount - 1]).append(")");
        }
        this.description = buf.toString();
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String extension = Utilities.getExtension(f.getName());
        if (extension == null) {
            return false;
        }
        if (this.caseCheck) {
            extension = extension.toLowerCase();
        }
        int extensionCount = this.extensions.length;
        for (int i = 0; i < extensionCount; ++i) {
            if (!this.extensions[i].equals(extension)) continue;
            return true;
        }
        return false;
    }

    private static final boolean doCaseCheck(int requestedCheck) {
        switch (requestedCheck) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        String os = System.getProperty("os.name");
        if (os != null) {
            boolean notWindows = os.toLowerCase().indexOf("windows") == 0;
            return notWindows;
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getDescription();
    }
}

