/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.plugins.graph.EdgesGraphComponent;
import net.sourceforge.squirrel_sql.plugins.graph.EdgesListener;
import net.sourceforge.squirrel_sql.plugins.graph.FormatController;
import net.sourceforge.squirrel_sql.plugins.graph.FormatControllerListener;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPlugin;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPluginResources;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPrintable;
import net.sourceforge.squirrel_sql.plugins.graph.PixelCalculater;
import net.sourceforge.squirrel_sql.plugins.graph.StartButtonHandler;
import net.sourceforge.squirrel_sql.plugins.graph.ZoomPrintPanel;
import net.sourceforge.squirrel_sql.plugins.graph.Zoomer;
import net.sourceforge.squirrel_sql.plugins.graph.graphtofiles.GraphToFilesCtrlr;
import net.sourceforge.squirrel_sql.plugins.graph.graphtofiles.SaveToFilePageFormat;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.FormatXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.PrintXmlBean;
import net.sourceforge.squirrel_sql.plugins.graph.xmlbeans.ZoomerXmlBean;

public class ZoomPrintController {
    private Zoomer _zoomer;
    private boolean _dontReactToSliderChanges = false;
    private ISession _session;
    private FormatController _formatController;
    private EdgesListener _edgesListener;
    private EdgesGraphComponent _edgesGraphComponent;
    private GraphPlugin _plugin;
    private GraphPrintable _printable;
    private ZoomPrintPanel _panel = null;

    public ZoomPrintController(ZoomerXmlBean zoomerXmlBean, PrintXmlBean printXmlBean, EdgesListener edgesListener, GraphPrintable printable, ISession session, GraphPlugin plugin, StartButtonHandler startButtonHandler) {
        this._printable = printable;
        this._plugin = plugin;
        this._panel = new ZoomPrintPanel(new GraphPluginResources((IPlugin)this._plugin), startButtonHandler);
        this.initZoom(session, zoomerXmlBean);
        this.initPrint(printXmlBean, edgesListener);
    }

    private void initPrint(PrintXmlBean printXmlBean, EdgesListener edgesListener) {
        this._edgesListener = edgesListener;
        FormatControllerListener fcl = new FormatControllerListener(){

            @Override
            public void formatsChanged(FormatXmlBean selectedFormat) {
                ZoomPrintController.this.onFormatsChanged(selectedFormat);
            }
        };
        if (null != printXmlBean) {
            this._formatController = new FormatController(this._session, this._plugin, fcl);
            this._panel.sldEdges.setValue(printXmlBean.getEdgesScale());
            this._panel.chkShowEdges.setSelected(printXmlBean.isShowEdges());
        } else {
            this._formatController = new FormatController(this._session, this._plugin, fcl);
        }
        FormatXmlBean[] formats = this._formatController.getFormats();
        FormatXmlBean toSelect = null;
        for (int i = 0; i < formats.length; ++i) {
            this._panel.cboFormat.addItem(formats[i]);
            if (!formats[i].isSelected()) continue;
            toSelect = formats[i];
        }
        if (null != toSelect) {
            this._panel.cboFormat.setSelectedItem(toSelect);
        }
        this._panel.sldEdges.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ZoomPrintController.this.onSldEdgesChanged();
            }
        });
        this._panel.chkShowEdges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZoomPrintController.this.onShowEdges();
            }
        });
        this.onShowEdges();
        this._panel.btnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZoomPrintController.this.onPrint();
            }
        });
        this._panel.btnSaveImages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZoomPrintController.this.onSaveImages();
            }
        });
        this._panel.cboFormat.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ZoomPrintController.this.onSelectedFormatChanged(e);
            }
        });
    }

    private void onShowEdges() {
        this._panel.btnFormat.setEnabled(this._panel.chkShowEdges.isSelected());
        this._panel.cboFormat.setEnabled(this._panel.chkShowEdges.isSelected());
        this._panel.sldEdges.setEnabled(this._panel.chkShowEdges.isSelected());
        this._panel.btnPrint.setEnabled(this._panel.chkShowEdges.isSelected());
        this.fireEdgesGraphComponentChanged(this._panel.chkShowEdges.isSelected() && this._panel.isVisible());
    }

    private void onSelectedFormatChanged(ItemEvent e) {
        if (1 == e.getStateChange()) {
            this.fireEdgesGraphComponentChanged(this._panel.chkShowEdges.isSelected());
        }
    }

    private void onFormatsChanged(FormatXmlBean selectedFormat) {
        FormatXmlBean[] formats = this._formatController.getFormats();
        this._panel.cboFormat.removeAllItems();
        for (int i = 0; i < formats.length; ++i) {
            this._panel.cboFormat.addItem(formats[i]);
            if (formats[i] == selectedFormat) {
                formats[i].setSelected(true);
                this._panel.cboFormat.setSelectedItem(formats[i]);
                continue;
            }
            formats[i].setSelected(false);
        }
    }

    private void onPrint() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PageFormat pf = this.initPrint(false);
        printJob.setPrintable(this._printable, pf);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private void onSaveImages() {
        try {
            ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
            if (this._panel.chkShowEdges.isSelected()) {
                int pxHeight;
                int pxWidth;
                BufferedImage img;
                int pageState;
                PageFormat pf = this.initPrint(true);
                FormatXmlBean format = (FormatXmlBean)this._panel.cboFormat.getSelectedItem();
                PixelCalculater pc = new PixelCalculater(format);
                int pageIndex = 0;
                while (1 != (pageState = this._printable.print((img = this.prepareImage(pxWidth = pc.getPixelWidth(), pxHeight = pc.getPixelHeight())).getGraphics(), pf, pageIndex))) {
                    images.add(img);
                    ++pageIndex;
                }
            } else {
                Dimension graphPixelSize = this._printable.initPrintNoScaleSinglePage();
                SaveToFilePageFormat pf = new SaveToFilePageFormat(graphPixelSize);
                BufferedImage img = this.prepareImage(graphPixelSize.width, graphPixelSize.height);
                this._printable.print(img.getGraphics(), pf, 0);
                images.add(img);
            }
            Window parent = SwingUtilities.windowForComponent(this._panel);
            new GraphToFilesCtrlr(images.toArray(new BufferedImage[images.size()]), parent);
        }
        catch (PrinterException e) {
            throw new RuntimeException(e);
        }
    }

    private BufferedImage prepareImage(int pxWidth, int pxHeight) {
        BufferedImage img = new BufferedImage(pxWidth, pxHeight, 1);
        img.getGraphics().setColor(Color.white);
        img.getGraphics().fillRect(0, 0, pxWidth, pxHeight);
        img.getGraphics().setColor(Color.black);
        return img;
    }

    private PageFormat initPrint(boolean isSaveToFile) {
        PageFormat pf;
        FormatXmlBean format = (FormatXmlBean)this._panel.cboFormat.getSelectedItem();
        this._printable.initPrint(format.getWidth(), format.getHeight(), (double)this._panel.sldEdges.getValue() / 100.0);
        PageFormat pageFormat = pf = isSaveToFile ? new SaveToFilePageFormat(format) : new PageFormat();
        if (format.isLandscape()) {
            pf.setOrientation(0);
        } else {
            pf.setOrientation(1);
        }
        return pf;
    }

    private void fireEdgesGraphComponentChanged(boolean showEdges) {
        if (null == this._edgesGraphComponent) {
            this._edgesGraphComponent = new EdgesGraphComponent();
        }
        if (showEdges) {
            FormatXmlBean format = (FormatXmlBean)this._panel.cboFormat.getSelectedItem();
            this._edgesGraphComponent.init(format, (double)this._panel.sldEdges.getValue() / 100.0, this._panel.sldEdges.getValueIsAdjusting());
            this._edgesListener.edgesGraphComponentChanged(this._edgesGraphComponent, true);
        } else {
            this._edgesListener.edgesGraphComponentChanged(this._edgesGraphComponent, false);
        }
    }

    private void onSldEdgesChanged() {
        this.fireEdgesGraphComponentChanged(this._panel.chkShowEdges.isSelected());
    }

    private void initZoom(ISession session, ZoomerXmlBean zoomerXmlBean) {
        this._session = session;
        this._zoomer = new Zoomer(zoomerXmlBean);
        this._panel.sldZoom.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ZoomPrintController.this.onSldZoomChanged();
            }
        });
        this._panel.chkHideScrollBars.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZoomPrintController.this.onHideScrollbars();
            }
        });
        this._panel.btnFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZoomPrintController.this.onBtnFormat();
            }
        });
    }

    private void onBtnFormat() {
        Window parent = SwingUtilities.windowForComponent(this._panel);
        this._formatController.setVisible(parent, true);
    }

    private void onHideScrollbars() {
        this._zoomer.setHideScrollBars(this._panel.chkHideScrollBars.isSelected());
    }

    private void onSldZoomChanged() {
        if (this._dontReactToSliderChanges) {
            return;
        }
        this._zoomer.setZoom((double)this._panel.sldZoom.getValue() / 100.0, this._panel.sldZoom.getValueIsAdjusting());
    }

    public ZoomPrintPanel getBottomPanel() {
        return this._panel;
    }

    public void activate(boolean b) {
        this._zoomer.setEnabled(b);
        this.fireEdgesGraphComponentChanged(b);
        this.onShowEdges();
        try {
            this._dontReactToSliderChanges = true;
            this._panel.sldZoom.setValue((int)(this._zoomer.getZoom() * 100.0 + 0.5));
        }
        finally {
            this._dontReactToSliderChanges = false;
        }
    }

    public Zoomer getZoomer() {
        return this._zoomer;
    }

    public PrintXmlBean getPrintXmlBean() {
        PrintXmlBean ret = new PrintXmlBean();
        ret.setShowEdges(this._panel.chkShowEdges.isSelected());
        ret.setEdgesScale(this._panel.sldEdges.getValue());
        return ret;
    }

    public void sessionEnding() {
        this._formatController.close();
    }
}

