/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSModuleNamespaceObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.objects.Dead;
import com.oracle.truffle.js.runtime.objects.ExportResolution;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.DefinePropertyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class JSModuleNamespace
extends JSNonProxy {
    public static final JSModuleNamespace INSTANCE = new JSModuleNamespace();
    public static final String CLASS_NAME = "Module";

    private JSModuleNamespace() {
    }

    public static JSModuleRecord getModule(DynamicObject obj) {
        assert (JSModuleNamespace.isJSModuleNamespace(obj));
        return ((JSModuleNamespaceObject)obj).getModule();
    }

    public static Map<String, ExportResolution> getExports(DynamicObject obj) {
        assert (JSModuleNamespace.isJSModuleNamespace(obj));
        return ((JSModuleNamespaceObject)obj).getExports();
    }

    public static DynamicObject create(JSContext context, JSModuleRecord module, Map<String, ExportResolution> exports) {
        JSRealm realm = context.getRealm();
        JSObjectFactory.BoundProto factory = context.getModuleNamespaceFactory();
        DynamicObject obj = JSModuleNamespaceObject.create(realm, factory, module, exports);
        assert (JSModuleNamespace.isJSModuleNamespace(obj));
        assert (!JSObject.isExtensible(obj));
        return context.trackAllocation(obj);
    }

    public static Shape makeInitialShape(JSContext context) {
        Shape initialShape = JSShape.newBuilder(context, INSTANCE, Null.instance).shapeFlags(1).build();
        initialShape = Shape.newBuilder((Shape)initialShape).addConstantProperty((Object)JSObject.HIDDEN_PROTO, (Object)Null.instance, 0).addConstantProperty((Object)Symbol.SYMBOL_TO_STRING_TAG, (Object)CLASS_NAME, JSAttributes.notConfigurableNotEnumerableNotWritable()).build();
        assert (!JSShape.isExtensible(initialShape));
        return initialShape;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return CLASS_NAME;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String toDisplayStringImpl(DynamicObject obj, int depth, boolean allowSideEffects, JSContext context) {
        return "[Module]";
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(DynamicObject store, Object thisObj, Object key) {
        if (!(key instanceof String)) {
            return super.getOwnHelper(store, thisObj, key);
        }
        Map<String, ExportResolution> exports = JSModuleNamespace.getExports(store);
        ExportResolution binding = exports.get(key);
        if (binding != null) {
            return JSModuleNamespace.getBindingValue(binding);
        }
        return Undefined.instance;
    }

    static Object getBindingValue(ExportResolution binding) {
        JSModuleRecord targetModule = binding.getModule();
        MaterializedFrame targetEnv = targetModule.getEnvironment();
        if (targetEnv == null) {
            throw Errors.createReferenceErrorNotDefined(binding.getBindingName(), null);
        }
        if (binding.isNamespace()) {
            return targetModule.getContext().getEvaluator().getModuleNamespace(targetModule);
        }
        FrameSlot frameSlot = targetEnv.getFrameDescriptor().findFrameSlot((Object)binding.getBindingName());
        if (JSFrameUtil.hasTemporalDeadZone(frameSlot) && targetEnv.isObject(frameSlot) && FrameUtil.getObjectSafe((Frame)targetEnv, (FrameSlot)frameSlot) == Dead.instance()) {
            throw Errors.createReferenceErrorNotDefined(binding.getBindingName(), null);
        }
        return targetEnv.getValue(frameSlot);
    }

    @Override
    public boolean hasProperty(DynamicObject thisObj, Object key) {
        if (!(key instanceof String)) {
            return super.hasProperty(thisObj, key);
        }
        Map<String, ExportResolution> exports = JSModuleNamespace.getExports(thisObj);
        return Boundaries.mapContainsKey(exports, key);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasOwnProperty(DynamicObject thisObj, Object key) {
        if (!(key instanceof String)) {
            return super.hasOwnProperty(thisObj, key);
        }
        Map<String, ExportResolution> exports = JSModuleNamespace.getExports(thisObj);
        ExportResolution binding = exports.get(key);
        if (binding != null) {
            JSModuleNamespace.getBindingValue(binding);
            return true;
        }
        return false;
    }

    @Override
    public boolean delete(DynamicObject thisObj, long index, boolean isStrict) {
        return true;
    }

    @Override
    public boolean delete(DynamicObject thisObj, Object key, boolean isStrict) {
        if (!(key instanceof String)) {
            return super.delete(thisObj, key, isStrict);
        }
        if (Boundaries.mapContainsKey(JSModuleNamespace.getExports(thisObj), key)) {
            if (isStrict) {
                throw Errors.createTypeErrorNotConfigurableProperty(key);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean setPrototypeOf(DynamicObject thisObj, DynamicObject newPrototype) {
        return newPrototype == Null.instance;
    }

    @Override
    public boolean defineOwnProperty(DynamicObject thisObj, Object key, PropertyDescriptor desc, boolean doThrow) {
        if (!(key instanceof String)) {
            return super.defineOwnProperty(thisObj, key, desc, doThrow);
        }
        PropertyDescriptor current = this.getOwnProperty(thisObj, key);
        if (current != null && !desc.isAccessorDescriptor() && desc.getIfHasWritable(true) && desc.getIfHasEnumerable(true) && !desc.getIfHasConfigurable(false) && (!desc.hasValue() || JSRuntime.isSameValue(desc.getValue(), current.getValue()))) {
            return true;
        }
        return DefinePropertyUtil.reject(doThrow, "not allowed to defineProperty on a namespace object");
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public PropertyDescriptor getOwnProperty(DynamicObject thisObj, Object key) {
        if (!(key instanceof String)) {
            return super.getOwnProperty(thisObj, key);
        }
        Map<String, ExportResolution> exports = JSModuleNamespace.getExports(thisObj);
        ExportResolution binding = exports.get(key);
        if (binding != null) {
            Object value = JSModuleNamespace.getBindingValue(binding);
            return PropertyDescriptor.createData(value, true, true, false);
        }
        return null;
    }

    public static boolean isJSModuleNamespace(Object obj) {
        return obj instanceof JSModuleNamespaceObject;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public List<Object> getOwnPropertyKeys(DynamicObject thisObj, boolean strings, boolean symbols) {
        List<Object> symbolKeys;
        List<Object> list = symbolKeys = symbols ? JSModuleNamespace.symbolKeys(thisObj) : Collections.emptyList();
        if (!strings) {
            return symbolKeys;
        }
        Map<String, ExportResolution> exports = JSModuleNamespace.getExports(thisObj);
        ArrayList<Object> keys = new ArrayList<Object>(exports.size() + symbolKeys.size());
        keys.addAll(exports.keySet());
        keys.addAll(symbolKeys);
        return keys;
    }

    private static List<Object> symbolKeys(DynamicObject thisObj) {
        return thisObj.getShape().getKeyList();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean setIntegrityLevel(DynamicObject obj, boolean freeze, boolean doThrow) {
        if (freeze) {
            Map<String, ExportResolution> exports = JSModuleNamespace.getExports(obj);
            if (!exports.isEmpty()) {
                ExportResolution firstBinding = exports.values().iterator().next();
                JSModuleNamespace.getBindingValue(firstBinding);
                throw Errors.createTypeError("not allowed to freeze a namespace object");
            }
        } else {
            for (ExportResolution binding : JSModuleNamespace.getExports(obj).values()) {
                JSModuleNamespace.getBindingValue(binding);
            }
        }
        return true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict) {
        if (isStrict) {
            throw Errors.createTypeErrorNotExtensible(thisObj, key);
        }
        return false;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(DynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict) {
        if (isStrict) {
            throw Errors.createTypeErrorNotExtensible(thisObj, Boundaries.stringValueOf(index));
        }
        return false;
    }

    @Override
    public boolean usesOrdinaryGetOwnProperty() {
        return false;
    }
}

