/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.StructureItem;
import org.openide.xml.XMLUtil;

public abstract class YamlStructureItem
implements StructureItem {
    private static final Logger LOGGER = Logger.getLogger(YamlStructureItem.class.getName());
    private final NodeType type;
    private final long startMark;

    public YamlStructureItem(NodeType type, long startMark) {
        this.type = type;
        this.startMark = startMark;
    }

    public NodeType getType() {
        return this.type;
    }

    public String getSortText() {
        return this.getName();
    }

    public String getHtml(HtmlFormatter formatter) {
        try {
            return XMLUtil.toElementContent((String)this.getName());
        }
        catch (CharConversionException cce) {
            LOGGER.log(Level.FINE, "NAME:" + this.getName(), cce);
            return this.getName();
        }
    }

    public ElementHandle getElementHandle() {
        return null;
    }

    public ElementKind getKind() {
        return ElementKind.ATTRIBUTE;
    }

    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    public boolean isLeaf() {
        return this.getNestedItems().isEmpty();
    }

    public long getPosition() {
        return this.startMark;
    }

    public ImageIcon getCustomIcon() {
        return null;
    }

    public String toString() {
        return "" + this.getPosition() + ": " + this.getName();
    }

    public static final class MapEntry
    extends YamlStructureItem {
        final YamlStructureItem keyItem;
        final YamlStructureItem valueItem;

        public MapEntry(YamlStructureItem keyItem, YamlStructureItem valueItem) {
            super(NodeType.MAPPING, keyItem.startMark);
            this.keyItem = keyItem;
            this.valueItem = valueItem;
        }

        public String getName() {
            return this.keyItem.getName();
        }

        public List<? extends StructureItem> getNestedItems() {
            return this.valueItem.getNestedItems();
        }

        public long getEndPosition() {
            return this.valueItem.getEndPosition();
        }
    }

    public static final class Collection
    extends YamlStructureItem {
        private final List<YamlStructureItem> children = new ArrayList<YamlStructureItem>();
        private long endMark;

        public Collection(NodeType type, long startMark) {
            super(type, startMark);
            this.endMark = startMark;
        }

        public String getName() {
            return "list item";
        }

        public List<? extends StructureItem> getNestedItems() {
            return this.children;
        }

        public List<? extends YamlStructureItem> getChildren() {
            return this.children;
        }

        public long getEndPosition() {
            return this.endMark;
        }

        public void add(YamlStructureItem item) {
            this.endMark = item.getEndPosition();
            this.children.add(item);
        }

        public void setEndMark(int end) {
            this.endMark = end;
        }
    }

    public static final class Simple
    extends YamlStructureItem {
        final String name;
        final long endMark;

        public Simple(NodeType type, String name, long startMark, long endMark) {
            super(type, startMark);
            this.name = name;
            this.endMark = endMark;
        }

        public String getName() {
            return this.name;
        }

        public List<? extends StructureItem> getNestedItems() {
            return Collections.emptyList();
        }

        public long getEndPosition() {
            return this.endMark;
        }
    }

    public static enum NodeType {
        MAP,
        SEQUENCE,
        MAPPING,
        SCALAR,
        ALIAS;

    }
}

