/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.StepRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.ExpressionPool;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.JPDAStepImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.actions.CompoundSmartSteppingListener;
import org.netbeans.modules.debugger.jpda.actions.JPDADebuggerActionProvider;
import org.netbeans.modules.debugger.jpda.actions.SmartSteppingFilterImpl;
import org.netbeans.modules.debugger.jpda.actions.StepIntoActionProvider;
import org.netbeans.modules.debugger.jpda.impl.StepUtils;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocatableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MethodWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.EventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.LocatableEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.StepRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.jpda.SmartSteppingCallback;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class StepActionProvider
extends JPDADebuggerActionProvider
implements Executor {
    private final ContextProvider lookupProvider;
    private JPDAStepImpl.MethodExitBreakpointListener lastMethodExitBreakpointListener;
    private int syntheticStep;
    private boolean smartSteppingStepOut;
    private final Properties p;
    private String className;
    private String methodName;
    private int depth;
    private boolean steppingFromFilteredLocation = false;
    private boolean steppingFromCompoundFilteredLocation = false;
    private static final RequestProcessor operationsRP = new RequestProcessor("Debugger Operations Computation", 1);
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.jdievents");
    private static final Logger loggerStep = Logger.getLogger("org.netbeans.modules.debugger.jpda.step");
    private static final long OPERATION_TIMEOUT = 200L;
    private StepIntoActionProvider stepIntoActionProvider;
    private SmartSteppingFilterImpl smartSteppingFilterImpl;
    private CompoundSmartSteppingListener compoundSmartSteppingListener;

    private static int getJDIAction(Object action) {
        if (action == ActionsManager.ACTION_STEP_OUT) {
            return 3;
        }
        if (action == ActionsManager.ACTION_STEP_OVER) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public StepActionProvider(ContextProvider lookupProvider) {
        super((JPDADebuggerImpl)((Object)lookupProvider.lookupFirst(null, JPDADebugger.class)));
        this.lookupProvider = lookupProvider;
        this.setProviderToDisableOnLazyAction(this);
        Map properties = (Map)lookupProvider.lookupFirst(null, Map.class);
        if (properties != null) {
            this.smartSteppingStepOut = properties.containsKey("SS_ACTION_STEPOUT");
        }
        this.p = Properties.getDefault().getProperties("debugger.options.JPDA");
    }

    public Set getActions() {
        return new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_STEP_OUT, ActionsManager.ACTION_STEP_OVER));
    }

    public void doAction(Object action) {
        this.runAction(action);
    }

    public void postAction(final Object action, final Runnable actionPerformedNotifier) {
        this.doLazyAction(action, new Runnable(){

            @Override
            public void run() {
                try {
                    StepActionProvider.this.runAction(action);
                }
                finally {
                    actionPerformedNotifier.run();
                }
            }
        });
    }

    public void runAction(Object action) {
        this.runAction(StepActionProvider.getJDIAction(action), -2, true, null, null, null);
    }

    /*
     * Exception decompiling
     */
    private void runAction(int stepDepth, int stepSize, boolean doResume, Lock lock, Boolean isSteppingFromFilteredLocation, Boolean isSteppingFromCompoundFilteredLocation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static CallStackFrame getTopFrame(JPDAThread thread) {
        CallStackFrame topFrame = null;
        try {
            CallStackFrame[] topFrameArr = thread.getCallStack(0, 1);
            if (topFrameArr.length > 0) {
                topFrame = topFrameArr[0];
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return topFrame;
    }

    private void addMethodExitBP(ThreadReference tr, JPDAThread jtr) throws VMDisconnectedExceptionWrapper, InternalExceptionWrapper, InvalidStackFrameExceptionWrapper, ObjectCollectedExceptionWrapper {
        Location loc;
        if (!MirrorWrapper.virtualMachine(tr).canGetMethodReturnValues()) {
            return;
        }
        try {
            loc = StackFrameWrapper.location(ThreadReferenceWrapper.frame(tr, 0));
        }
        catch (IncompatibleThreadStateException ex) {
            logger.fine("Incompatible Thread State: " + ex.getLocalizedMessage());
            return;
        }
        catch (IllegalThreadStateExceptionWrapper ex) {
            return;
        }
        catch (IndexOutOfBoundsException ex) {
            return;
        }
        String classType = ReferenceTypeWrapper.name(LocationWrapper.declaringType(loc));
        String methodName = TypeComponentWrapper.name(LocationWrapper.method(loc));
        MethodBreakpoint mb = MethodBreakpoint.create((String)classType, (String)methodName);
        mb.setBreakpointType(2);
        mb.setHidden(true);
        mb.setSuspend(0);
        mb.setThreadFilters((JPDADebugger)this.getDebuggerImpl(), new JPDAThread[]{jtr});
        this.lastMethodExitBreakpointListener = new JPDAStepImpl.MethodExitBreakpointListener(mb);
        mb.addJPDABreakpointListener((JPDABreakpointListener)this.lastMethodExitBreakpointListener);
        mb.setSession((JPDADebugger)this.debugger);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb);
    }

    @Override
    protected void checkEnabled(int debuggerState) {
        Iterator i = this.getActions().iterator();
        while (i.hasNext()) {
            this.setEnabled(i.next(), debuggerState == 3 && this.getDebuggerImpl().getCurrentThread() != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exec(Event ev) {
        try {
            LocatableEvent event = (LocatableEvent)ev;
            ThreadReference tr = LocatableEventWrapper.thread(event);
            StepRequest sr = (StepRequest)EventWrapper.request(ev);
            JPDAThreadImpl st = this.getDebuggerImpl().getThread(tr);
            Lock lock = this.getDebuggerImpl().getSuspend() == 1 ? st.accessLock.writeLock() : this.getDebuggerImpl().accessLock.writeLock();
            lock.lock();
            try {
                SmartSteppingCallback.StopOrStep fsh;
                st.setInStep(false, null);
                boolean suspended = false;
                try {
                    suspended = ThreadReferenceWrapper.isSuspended0(tr);
                }
                catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                    // empty catch block
                }
                if (!suspended) {
                    this.removeStepRequests(tr);
                    boolean bl = false;
                    return bl;
                }
                String className = ReferenceTypeWrapper.name(LocationWrapper.declaringType(LocatableWrapper.location(event)));
                this.setLastOperation(tr);
                this.removeStepRequests(tr);
                int suspendPolicy = this.getDebuggerImpl().getSuspend();
                if (this.syntheticStep != 0) {
                    int step = this.syntheticStep > 0 ? this.syntheticStep : StepRequestWrapper.depth(sr);
                    VirtualMachine vm = this.getDebuggerImpl().getVirtualMachine();
                    if (vm == null) {
                        this.removeBPListener();
                        boolean bl = false;
                        return bl;
                    }
                    StepRequest stepRequest = EventRequestManagerWrapper.createStepRequest(VirtualMachineWrapper.eventRequestManager(vm), tr, -2, step);
                    StepUtils.markOriginalStepDepth(stepRequest, tr);
                    EventRequestWrapper.addCountFilter(stepRequest, 1);
                    this.getDebuggerImpl().getOperator().register(stepRequest, this);
                    EventRequestWrapper.setSuspendPolicy(stepRequest, suspendPolicy);
                    try {
                        EventRequestWrapper.enable(stepRequest);
                    }
                    catch (IllegalThreadStateException itsex) {
                        this.getDebuggerImpl().getOperator().unregister(stepRequest);
                        stepRequest = null;
                        this.removeBPListener();
                    }
                    catch (InvalidRequestStateExceptionWrapper irse) {
                        Exceptions.printStackTrace((Throwable)irse);
                        this.getDebuggerImpl().getOperator().unregister(stepRequest);
                        stepRequest = null;
                        this.removeBPListener();
                    }
                    loggerStep.log(Level.FINE, "Further step in a synthetic location, depth = {0}", step);
                    boolean irse = true;
                    return irse;
                }
                if (this.depth == 1 && "main".equals(this.methodName) && !"java.lang.Thread".equals(this.className) && "java.lang.Thread".equals(className) && "exit".equals(this.getDebuggerImpl().getThread(tr).getMethodName())) {
                    boolean step = true;
                    return step;
                }
                if (this.steppingFromFilteredLocation) {
                    fsh = SmartSteppingCallback.StopOrStep.stop();
                } else {
                    SmartSteppingCallback.StopOrStep stopOrStep = fsh = this.getSmartSteppingFilterImpl().stopHere(className) ? SmartSteppingCallback.StopOrStep.stop() : SmartSteppingCallback.StopOrStep.skip();
                }
                if (loggerStep.isLoggable(Level.FINE)) {
                    loggerStep.fine("SS  SmartSteppingFilter.stopHere (" + className + ") ? " + fsh);
                }
                if (fsh.isStop()) {
                    if (!this.steppingFromCompoundFilteredLocation) {
                        JPDAThreadImpl t = this.getDebuggerImpl().getThread(tr);
                        CallStackFrame topFrame = StepActionProvider.getTopFrame(t);
                        if (topFrame != null) {
                            fsh = this.getCompoundSmartSteppingListener().stopAt(this.lookupProvider, topFrame, this.getSmartSteppingFilterImpl());
                        } else {
                            SmartSteppingCallback.StopOrStep stopOrStep = fsh = this.getCompoundSmartSteppingListener().stopHere(this.lookupProvider, t, this.getSmartSteppingFilterImpl()) ? SmartSteppingCallback.StopOrStep.stop() : SmartSteppingCallback.StopOrStep.skip();
                        }
                    }
                    if (fsh.isStop()) {
                        loggerStep.fine("Can stop here.");
                        boolean t = false;
                        return t;
                    }
                }
                loggerStep.fine("\nSS:  SMART STEPPING START! ********** ");
                int stepDepth = fsh.getStepDepth();
                int stepSize = fsh.getStepSize();
                if (stepSize == 0) {
                    stepSize = StepRequestWrapper.size(sr);
                }
                if (stepDepth == 0) {
                    boolean useStepFilters = this.p.getBoolean("UseStepFilters", true);
                    boolean stepThrough = useStepFilters && this.p.getBoolean("StepThroughFilters", false);
                    stepDepth = !stepThrough || this.smartSteppingStepOut ? 3 : StepRequestWrapper.depth(sr);
                }
                boolean actionRun = false;
                if (stepSize == -2) {
                    if (stepDepth == 1) {
                        this.getStepIntoActionProvider().runAction("smartStepInto", false, lock, this.steppingFromFilteredLocation, this.steppingFromCompoundFilteredLocation);
                        actionRun = true;
                    } else if (stepDepth == 3 && stepDepth != StepRequestWrapper.depth(sr)) {
                        this.getStepIntoActionProvider().runAction(ActionsManager.ACTION_STEP_OUT, false, lock, this.steppingFromFilteredLocation, this.steppingFromCompoundFilteredLocation);
                        actionRun = true;
                    }
                }
                if (!actionRun) {
                    this.runAction(stepDepth, stepSize, false, lock, this.steppingFromFilteredLocation, this.steppingFromCompoundFilteredLocation);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        catch (InternalExceptionWrapper e) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper e) {
            return false;
        }
        catch (ObjectCollectedExceptionWrapper e) {
            return false;
        }
    }

    @Override
    public void removed(EventRequest eventRequest) {
        StepRequest sr = (StepRequest)eventRequest;
        try {
            JPDAThreadImpl st = this.getDebuggerImpl().getThread(StepRequestWrapper.thread(sr));
            st.setInStep(false, null);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
        if (this.syntheticStep == 0 && this.lastMethodExitBreakpointListener != null) {
            this.lastMethodExitBreakpointListener.destroy();
            this.lastMethodExitBreakpointListener = null;
        }
    }

    private void removeBPListener() {
        this.syntheticStep = 0;
        if (this.lastMethodExitBreakpointListener != null) {
            this.lastMethodExitBreakpointListener.destroy();
            this.lastMethodExitBreakpointListener = null;
        }
    }

    private void setLastOperation(ThreadReference tr) throws VMDisconnectedExceptionWrapper {
        Variable returnValue = null;
        if (this.lastMethodExitBreakpointListener != null) {
            returnValue = this.lastMethodExitBreakpointListener.getReturnValue();
        }
        this.syntheticStep = StepActionProvider.setLastOperation(tr, this.getDebuggerImpl(), returnValue);
        if (this.syntheticStep == 0 && this.lastMethodExitBreakpointListener != null) {
            this.lastMethodExitBreakpointListener.destroy();
            this.lastMethodExitBreakpointListener = null;
        }
    }

    public static int setLastOperation(ThreadReference tr, JPDADebuggerImpl debugger, Variable returnValue) throws VMDisconnectedExceptionWrapper {
        String url;
        Location loc;
        try {
            loc = StackFrameWrapper.location(ThreadReferenceWrapper.frame(tr, 0));
        }
        catch (IncompatibleThreadStateException itsex) {
            try {
                int status = ThreadReferenceWrapper.status0(tr);
                if (status != -1 && status != 0 && status != 5) {
                    Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)itsex, (String)("Thread's status = " + status + ", suspended = " + ThreadReferenceWrapper.isSuspended0(tr))));
                }
            }
            catch (IllegalThreadStateExceptionWrapper status) {
                // empty catch block
            }
            logger.log(Level.FINE, "Incompatible Thread State: {0}", itsex.getLocalizedMessage());
            return 0;
        }
        catch (IllegalThreadStateExceptionWrapper itsex) {
            return 0;
        }
        catch (InternalExceptionWrapper iex) {
            return 0;
        }
        catch (IndexOutOfBoundsException iobe) {
            return 0;
        }
        catch (InvalidStackFrameExceptionWrapper iex) {
            return 0;
        }
        catch (ObjectCollectedExceptionWrapper iex) {
            return 0;
        }
        try {
            int syntheticStep = JPDAStepImpl.isSyntheticMethod(LocationWrapper.method(loc), loc);
            if (syntheticStep != 0) {
                return syntheticStep;
            }
        }
        catch (InternalExceptionWrapper syntheticStep) {
            // empty catch block
        }
        Session currentSession = DebuggerManager.getDebuggerManager().getCurrentSession();
        String language = currentSession == null ? null : currentSession.getCurrentLanguage();
        SourcePath sourcePath = debugger.getEngineContext();
        try {
            url = sourcePath.getURL(loc, language);
        }
        catch (InternalExceptionWrapper iex) {
            return 0;
        }
        catch (ObjectCollectedExceptionWrapper iex) {
            return 0;
        }
        StepActionProvider.setOperationsLazily(debugger.getThread(tr), returnValue, debugger, loc, url);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setOperationsLazily(final JPDAThreadImpl jtr, final Variable returnValue, final JPDADebuggerImpl debugger, final Location loc, final String url) throws VMDisconnectedExceptionWrapper {
        final Object[] finishedInTime = new Object[]{null};
        final RequestProcessor.Task task = operationsRP.create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                byte[] bytecodes;
                int codeIndex;
                ExpressionPool exprPool = debugger.getExpressionPool();
                ExpressionPool.Expression expr = exprPool.getExpressionAt(loc, url);
                if (expr == null) {
                    return;
                }
                EditorContext.Operation[] ops = expr.getOperations();
                try {
                    codeIndex = (int)LocationWrapper.codeIndex(loc);
                    bytecodes = MethodWrapper.bytecodes(LocationWrapper.method(loc));
                }
                catch (InternalExceptionWrapper iex) {
                    return;
                }
                catch (VMDisconnectedExceptionWrapper vmdex) {
                    Object[] objectArray = finishedInTime;
                    synchronized (finishedInTime) {
                        finishedInTime[0] = vmdex;
                        // ** MonitorExit[var7_9] (shouldn't be in output)
                        return;
                    }
                }
                codeIndex = codeIndex >= 5 && (bytecodes[codeIndex - 5] & 0xFF) == 185 ? (codeIndex -= 5) : (codeIndex -= 3);
                int opIndex = expr.findNextOperationIndex(codeIndex - 1);
                if (opIndex < 0 || ops[opIndex].getBytecodeIndex() != codeIndex) {
                    return;
                }
                EditorContext.Operation lastOperation = ops[opIndex];
                JPDAThreadImpl jPDAThreadImpl = jtr;
                synchronized (jPDAThreadImpl) {
                    Object[] objectArray = finishedInTime;
                    synchronized (finishedInTime) {
                        if (finishedInTime[0] == Boolean.FALSE) {
                            // ** MonitorExit[var10_13] (shouldn't be in output)
                            return;
                        }
                        boolean needsUpdate = finishedInTime[0] == Boolean.TRUE;
                        // ** MonitorExit[var10_13] (shouldn't be in output)
                        lastOperation.setReturnValue(returnValue);
                        if (needsUpdate) {
                            jtr.updateLastOperation(lastOperation);
                        } else {
                            jtr.addLastOperation(lastOperation);
                            jtr.setCurrentOperation(lastOperation);
                        }
                    }
                }
            }
        });
        PropertyChangeListener threadChangeListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object[] objectArray = finishedInTime;
                synchronized (finishedInTime) {
                    finishedInTime[0] = Boolean.FALSE;
                    task.cancel();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    jtr.removePropertyChangeListener("operationsSet", this);
                    return;
                }
            }
        };
        jtr.addPropertyChangeListener("operationsSet", threadChangeListener);
        task.schedule(0);
        try {
            boolean finished = task.waitFinished(200L);
            Object[] objectArray = finishedInTime;
            synchronized (finishedInTime) {
                if (finishedInTime[0] instanceof VMDisconnectedExceptionWrapper) {
                    throw (VMDisconnectedExceptionWrapper)finishedInTime[0];
                }
                if (!finished) {
                    finishedInTime[0] = Boolean.TRUE;
                }
                // ** MonitorExit[var9_10] (shouldn't be in output)
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        {
            return;
        }
    }

    private StepIntoActionProvider getStepIntoActionProvider() {
        if (this.stepIntoActionProvider == null) {
            this.stepIntoActionProvider = StepIntoActionProvider.instanceByContext.get(this.lookupProvider).get();
        }
        return this.stepIntoActionProvider;
    }

    private SmartSteppingFilterImpl getSmartSteppingFilterImpl() {
        if (this.smartSteppingFilterImpl == null) {
            this.smartSteppingFilterImpl = (SmartSteppingFilterImpl)this.lookupProvider.lookupFirst(null, SmartSteppingFilter.class);
        }
        return this.smartSteppingFilterImpl;
    }

    private CompoundSmartSteppingListener getCompoundSmartSteppingListener() {
        if (this.compoundSmartSteppingListener == null) {
            this.compoundSmartSteppingListener = (CompoundSmartSteppingListener)((Object)this.lookupProvider.lookupFirst(null, CompoundSmartSteppingListener.class));
        }
        return this.compoundSmartSteppingListener;
    }
}

