/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.actions;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.caret.CaretInfo;
import org.netbeans.api.editor.caret.CaretMoveContext;
import org.netbeans.api.editor.caret.EditorCaret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.spi.editor.AbstractEditorAction;
import org.netbeans.spi.editor.caret.CaretMoveHandler;

public class AddCaretAction
extends AbstractEditorAction {
    protected void actionPerformed(ActionEvent evt, final JTextComponent target) {
        Caret caret;
        if (target != null && (caret = target.getCaret()) != null && caret instanceof EditorCaret) {
            final EditorCaret editorCaret = (EditorCaret)caret;
            final BaseDocument doc = (BaseDocument)target.getDocument();
            final boolean upAction = "add-caret-up".equals(this.actionName());
            doc.runAtomicAsUser(new Runnable(){

                @Override
                public void run() {
                    final ArrayList dotAndMarks = new ArrayList(editorCaret.getCarets().size() << 1);
                    final ArrayList dotAndMarkBiases = new ArrayList(editorCaret.getCarets().size() << 1);
                    editorCaret.moveCarets(new CaretMoveHandler(){

                        public void moveCarets(CaretMoveContext context) {
                            for (CaretInfo caretInfo : context.getOriginalCarets()) {
                                try {
                                    int dot = caretInfo.getDot();
                                    Position.Bias dotBias = caretInfo.getDotBias();
                                    Point p = caretInfo.getMagicCaretPosition();
                                    if (p == null) {
                                        Rectangle r = target.getUI().modelToView(target, dot, dotBias);
                                        if (r != null) {
                                            p = new Point(r.x, r.y);
                                            context.setMagicCaretPosition(caretInfo, p);
                                        } else {
                                            return;
                                        }
                                    }
                                    try {
                                        dot = upAction ? Utilities.getPositionAbove((JTextComponent)target, (int)dot, (int)p.x) : Utilities.getPositionBelow((JTextComponent)target, (int)dot, (int)p.x);
                                        Position dotPos = doc.createPosition(dot);
                                        dotAndMarks.add(dotPos);
                                        dotAndMarks.add(dotPos);
                                        dotAndMarkBiases.add(dotBias);
                                        dotAndMarkBiases.add(dotBias);
                                    }
                                    catch (BadLocationException badLocationException) {
                                    }
                                }
                                catch (BadLocationException ex) {
                                    target.getToolkit().beep();
                                }
                            }
                        }
                    });
                    editorCaret.addCarets(dotAndMarks, dotAndMarkBiases);
                }
            });
        }
    }
}

