/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.modules.form.CustomCodeData;
import org.netbeans.modules.form.CustomCodeView;
import org.netbeans.modules.form.EditorSupport;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.JavaCodeGenerator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.netbeans.modules.form.RADProperty;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CodeCustomizer
implements CustomCodeView.Listener {
    private FormModel formModel;
    private Map<RADComponent, CustomCodeData> changedDataMap = new HashMap<RADComponent, CustomCodeData>();
    private CustomCodeView codeView;
    private RADComponent customizedComponent;

    private CodeCustomizer(FormModel formModel) {
        this.formModel = formModel;
        this.codeView = new CustomCodeView(this);
        this.setupComponentNames();
    }

    public static void show(RADComponent metacomp) {
        CodeCustomizer customizer = new CodeCustomizer(metacomp.getFormModel());
        customizer.selectComponent(metacomp);
        customizer.show();
    }

    private void show() {
        JavaCodeGenerator codeGen = (JavaCodeGenerator)FormEditor.getCodeGenerator(this.formModel);
        codeGen.regenerateCode();
        DialogDescriptor dd = new DialogDescriptor((Object)this.codeView, NbBundle.getMessage(CodeCustomizer.class, (String)"TITLE_CodeCustomizer"), true, 2, null, null);
        dd.setHelpCtx(new HelpCtx("gui.codecustomizer"));
        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (DialogDescriptor.OK_OPTION.equals(res)) {
            this.retreiveCurrentData();
            this.storeChanges();
        }
    }

    private void setupComponentNames() {
        Collection<RADComponent> allComps = this.formModel.getAllComponents();
        RADComponent rootComp = this.formModel.getTopRADComponent();
        Object[] compNames = new String[rootComp != null ? allComps.size() - 1 : allComps.size()];
        int i = 0;
        for (RADComponent metacomp : allComps) {
            if (metacomp == rootComp) continue;
            compNames[i++] = metacomp.getName();
        }
        Arrays.sort(compNames, 0, compNames.length - 1);
        this.codeView.setComponentNames((String[])compNames);
    }

    private void selectComponent(RADComponent metacomp) {
        this.customizedComponent = metacomp;
        CustomCodeData codeData = this.changedDataMap.get(metacomp);
        if (codeData == null) {
            codeData = JavaCodeGenerator.getCodeData(metacomp);
            codeData.check();
        }
        this.codeView.setCodeData(this.customizedComponent.getName(), codeData, this.getSourceFile(), this.getSourcePositions());
    }

    private FileObject getSourceFile() {
        return FormEditor.getFormDataObject(this.formModel).getPrimaryFile();
    }

    private int[] getSourcePositions() {
        EditorSupport es = FormEditor.getFormDataObject(this.formModel).getFormEditorSupport();
        SimpleSection sec = es.getGuardedSectionManager().findSimpleSection("initComponents");
        return new int[]{sec.getText().indexOf(123) + 2 + sec.getStartPosition().getOffset(), sec.getEndPosition().getOffset() + 1};
    }

    private void retreiveCurrentData() {
        if (this.codeView.isChanged()) {
            this.changedDataMap.put(this.customizedComponent, this.codeView.retreiveCodeData());
        }
    }

    private void storeChanges() {
        for (Map.Entry<RADComponent, CustomCodeData> e : this.changedDataMap.entrySet()) {
            this.storeComponent(e.getKey(), e.getValue(), true);
        }
        this.changedDataMap.clear();
    }

    private void storeComponent(RADComponent metacomp, CustomCodeData codeData, boolean definite) {
        CodeCustomizer.storeCodeCategory(metacomp, codeData, CustomCodeData.CodeCategory.CREATE_AND_INIT, definite);
        CodeCustomizer.storeCodeCategory(metacomp, codeData, CustomCodeData.CodeCategory.DECLARATION, definite);
        CodeCustomizer.storeDeclaration(metacomp, codeData.getDeclarationData(), definite);
    }

    private static void storeCodeCategory(RADComponent metacomp, CustomCodeData codeData, CustomCodeData.CodeCategory category, boolean definite) {
        int eCount = codeData.getEditableBlockCount(category);
        for (int i = 0; i < eCount; ++i) {
            CustomCodeData.EditableBlock eBlock = codeData.getEditableBlock(category, i);
            for (CustomCodeData.CodeEntry e : eBlock.getEntries()) {
                CodeCustomizer.storeCodeEntry(metacomp, e, definite);
            }
        }
        int gCount = codeData.getGuardedBlockCount(category);
        for (int i = 0; i < gCount; ++i) {
            CustomCodeData.GuardedBlock gBlock = codeData.getGuardedBlock(category, i);
            if (!gBlock.isCustomizable()) continue;
            CodeCustomizer.storeCodeEntry(metacomp, gBlock.getCustomEntry(), definite);
        }
    }

    private static void storeCodeEntry(RADComponent metacomp, CustomCodeData.CodeEntry entry, boolean definite) {
        boolean firing;
        FormProperty prop = entry.getTargetProperty();
        String code = entry.getCode();
        if (!definite) {
            firing = prop.isChangeFiring();
            prop.setChangeFiring(false);
        } else {
            firing = true;
        }
        try {
            if (entry.isPropertyPreInit()) {
                prop.setPreCode(code);
            } else if (entry.isPropertyPostInit()) {
                prop.setPostCode(code);
            } else if (prop instanceof RADProperty) {
                if (code != null) {
                    FormProperty.ValueWithEditor codeValue = new FormProperty.ValueWithEditor(new RADConnectionPropertyEditor.RADConnectionDesignValue(code), new RADConnectionPropertyEditor(prop.getValueType()));
                    prop.setValue(codeValue);
                } else if (JavaCodeGenerator.isPropertyWithCustomCode(prop)) {
                    prop.restoreDefaultValue();
                    if (!definite && prop.getPreCode() == null && prop.getPostCode() == null) {
                        prop.setPreCode("\n");
                    }
                }
            } else {
                prop.setValue(code != null ? code : "");
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        if (!definite) {
            prop.setChangeFiring(firing);
        }
    }

    private static void storeDeclaration(RADComponent metacomp, CustomCodeData.VariableDeclaration decl, boolean definite) {
        boolean firing;
        FormProperty varProp = (FormProperty)metacomp.getSyntheticProperty("useLocalVariable");
        FormProperty modifProp = (FormProperty)metacomp.getSyntheticProperty("modifiers");
        if (!definite) {
            firing = varProp.isChangeFiring();
            varProp.setChangeFiring(false);
            modifProp.setChangeFiring(false);
        } else {
            firing = true;
        }
        try {
            varProp.setValue(decl.local);
            int modif = decl.modifiers;
            if (modif < 0) {
                modif = (Integer)modifProp.getValue() & 0xFFFFFFEF | modif & 0x10;
            }
            modifProp.setValue(modif);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        if (!definite) {
            varProp.setChangeFiring(firing);
            modifProp.setChangeFiring(firing);
        }
    }

    @Override
    public void componentExchanged(String compName) {
        this.retreiveCurrentData();
        this.selectComponent(this.formModel.findRADComponent(compName));
    }

    @Override
    public void renameInvoked() {
        NotifyDescriptor.InputLine input = new NotifyDescriptor.InputLine(NbBundle.getMessage(CodeCustomizer.class, (String)"CTL_RenameLabel"), NbBundle.getMessage(CodeCustomizer.class, (String)"CTL_RenameTitle"));
        input.setInputText(this.customizedComponent.getName());
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)input))) {
            this.retreiveCurrentData();
            CustomCodeData codeData = this.changedDataMap.get(this.customizedComponent);
            if (codeData != null) {
                NotifyDescriptor.Confirmation confirm = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CodeCustomizer.class, (String)"CTL_ApplyChangesLabel"), NbBundle.getMessage(CodeCustomizer.class, (String)"CTL_ApplyChangesTitle"), 2);
                if (!NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)confirm))) {
                    return;
                }
                this.storeComponent(this.customizedComponent, codeData, true);
                this.changedDataMap.remove(this.customizedComponent);
            }
            try {
                String newName = input.getInputText();
                if (!newName.equals("")) {
                    this.customizedComponent.rename(newName);
                }
            }
            catch (IllegalArgumentException e) {
                Exceptions.printStackTrace((Throwable)e);
                return;
            }
            this.setupComponentNames();
            codeData = JavaCodeGenerator.getCodeData(this.customizedComponent);
            codeData.check();
            this.codeView.setCodeData(this.customizedComponent.getName(), codeData, this.getSourceFile(), this.getSourcePositions());
        }
    }

    @Override
    public void declarationChanged() {
        CustomCodeData original = JavaCodeGenerator.getCodeData(this.customizedComponent);
        this.retreiveCurrentData();
        CustomCodeData actual = this.changedDataMap.get(this.customizedComponent);
        this.storeComponent(this.customizedComponent, actual, false);
        CustomCodeData renewed = JavaCodeGenerator.getCodeData(this.customizedComponent);
        renewed.check();
        this.storeComponent(this.customizedComponent, original, false);
        this.codeView.setCodeData(this.customizedComponent.getName(), renewed, this.getSourceFile(), this.getSourcePositions());
    }
}

