/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.retrier;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.oracle.bmc.circuitbreaker.CallNotAllowedException;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.retrier.RetryCondition;
import lombok.NonNull;

public class DefaultRetryCondition
implements RetryCondition {
    private static final Multimap<Integer, String> RETRYABLE_SERVICE_ERRORS = ImmutableSetMultimap.builder().put((Object)409, (Object)"IncorrectState").build();
    private static final String PROCESSING_EXCEPTION_MSG = ".*processing(\\s)+exception.*";

    @Override
    public boolean shouldBeRetried(@NonNull BmcException exception) {
        if (exception == null) {
            throw new NullPointerException("exception is marked non-null but is null");
        }
        return exception.isClientSide() || exception.isTimeout() || exception.getStatusCode() == 429 || exception.getStatusCode() == 500 || exception.getStatusCode() == 502 || exception.getStatusCode() == 503 || exception.getStatusCode() == 504 || RETRYABLE_SERVICE_ERRORS.containsEntry((Object)exception.getStatusCode(), (Object)exception.getServiceCode()) || DefaultRetryCondition.isProcessingException(exception) || exception.getCause() instanceof CallNotAllowedException;
    }

    public static boolean isProcessingException(BmcException exception) {
        return exception.getStatusCode() == -1 && exception.getMessage().toLowerCase().matches(PROCESSING_EXCEPTION_MSG);
    }
}

