/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.util.Collection;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.DocTreePathHandle;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Context;
import org.netbeans.modules.refactoring.api.CopyRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.java.api.EncapsulateFieldRefactoring;
import org.netbeans.modules.refactoring.java.api.ExtractInterfaceRefactoring;
import org.netbeans.modules.refactoring.java.api.ExtractSuperclassRefactoring;
import org.netbeans.modules.refactoring.java.api.InlineRefactoring;
import org.netbeans.modules.refactoring.java.api.InnerToOuterRefactoring;
import org.netbeans.modules.refactoring.java.api.IntroduceLocalExtensionRefactoring;
import org.netbeans.modules.refactoring.java.api.IntroduceParameterRefactoring;
import org.netbeans.modules.refactoring.java.api.InvertBooleanRefactoring;
import org.netbeans.modules.refactoring.java.api.JavaMoveMembersProperties;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.api.PullUpRefactoring;
import org.netbeans.modules.refactoring.java.api.PushDownRefactoring;
import org.netbeans.modules.refactoring.java.api.ReplaceConstructorWithBuilderRefactoring;
import org.netbeans.modules.refactoring.java.api.ReplaceConstructorWithFactoryRefactoring;
import org.netbeans.modules.refactoring.java.api.UseSuperTypeRefactoring;
import org.netbeans.modules.refactoring.java.plugins.ChangeParametersPlugin;
import org.netbeans.modules.refactoring.java.plugins.CopyClassRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.CopyClassesRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.EncapsulateFieldRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.EncapsulateFieldsPlugin;
import org.netbeans.modules.refactoring.java.plugins.ExtractInterfaceRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.ExtractSuperclassRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.InlineRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.InnerToOuterRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.IntroduceLocalExtensionPlugin;
import org.netbeans.modules.refactoring.java.plugins.IntroduceParameterPlugin;
import org.netbeans.modules.refactoring.java.plugins.InvertBooleanRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.JavaWhereUsedQueryPlugin;
import org.netbeans.modules.refactoring.java.plugins.MoveFileRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.MoveMembersRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.PullUpRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.PushDownRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.RenameRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.ReplaceConstructorWithBuilderPlugin;
import org.netbeans.modules.refactoring.java.plugins.ReplaceConstructorWithFactoryPlugin;
import org.netbeans.modules.refactoring.java.plugins.SafeDeleteRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.UseSuperTypeRefactoringPlugin;
import org.netbeans.modules.refactoring.java.ui.EncapsulateFieldsRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;

public class JavaRefactoringsFactory
implements RefactoringPluginFactory {
    public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
        Lookup look = refactoring.getRefactoringSource();
        FileObject file = (FileObject)look.lookup(FileObject.class);
        NonRecursiveFolder folder = (NonRecursiveFolder)look.lookup(NonRecursiveFolder.class);
        TreePathHandle handle = (TreePathHandle)look.lookup(TreePathHandle.class);
        DocTreePathHandle docHandle = (DocTreePathHandle)look.lookup(DocTreePathHandle.class);
        if (refactoring instanceof WhereUsedQuery) {
            if (handle != null) {
                return new JavaWhereUsedQueryPlugin((WhereUsedQuery)refactoring);
            }
        } else if (refactoring instanceof RenameRefactoring) {
            if (handle != null || docHandle != null || file != null && RefactoringUtils.isJavaFile(file)) {
                return new RenameRefactoringPlugin((RenameRefactoring)refactoring);
            }
            if (file != null && JavaRefactoringUtils.isOnSourceClasspath(file) && file.isFolder()) {
                return new MoveFileRefactoringPlugin((RenameRefactoring)refactoring);
            }
            if (folder != null && JavaRefactoringUtils.isOnSourceClasspath(folder.getFolder())) {
                return new MoveFileRefactoringPlugin((RenameRefactoring)refactoring);
            }
        } else if (refactoring instanceof SafeDeleteRefactoring) {
            if (this.checkSafeDelete(refactoring.getRefactoringSource())) {
                return new SafeDeleteRefactoringPlugin((SafeDeleteRefactoring)refactoring);
            }
        } else if (refactoring instanceof MoveRefactoring) {
            if (this.checkMove(refactoring.getRefactoringSource())) {
                return new MoveFileRefactoringPlugin((MoveRefactoring)refactoring);
            }
            if (this.checkMoveMembers(refactoring.getContext())) {
                return new MoveMembersRefactoringPlugin((MoveRefactoring)refactoring);
            }
        } else if (refactoring instanceof SingleCopyRefactoring) {
            if (this.checkCopy(refactoring.getRefactoringSource())) {
                return new CopyClassRefactoringPlugin((SingleCopyRefactoring)refactoring);
            }
        } else if (refactoring instanceof CopyRefactoring) {
            if (this.checkCopy(refactoring.getRefactoringSource())) {
                return new CopyClassesRefactoringPlugin((CopyRefactoring)refactoring);
            }
        } else if (handle != null) {
            if (refactoring instanceof ExtractInterfaceRefactoring) {
                return new ExtractInterfaceRefactoringPlugin((ExtractInterfaceRefactoring)refactoring);
            }
            if (refactoring instanceof ExtractSuperclassRefactoring) {
                return new ExtractSuperclassRefactoringPlugin((ExtractSuperclassRefactoring)refactoring);
            }
            if (refactoring instanceof IntroduceLocalExtensionRefactoring) {
                return new IntroduceLocalExtensionPlugin((IntroduceLocalExtensionRefactoring)refactoring);
            }
            if (refactoring instanceof PullUpRefactoring) {
                return new PullUpRefactoringPlugin((PullUpRefactoring)refactoring);
            }
            if (refactoring instanceof PushDownRefactoring) {
                return new PushDownRefactoringPlugin((PushDownRefactoring)refactoring);
            }
            if (refactoring instanceof UseSuperTypeRefactoring) {
                return new UseSuperTypeRefactoringPlugin((UseSuperTypeRefactoring)refactoring);
            }
            if (refactoring instanceof InnerToOuterRefactoring) {
                return new InnerToOuterRefactoringPlugin((InnerToOuterRefactoring)refactoring);
            }
            if (refactoring instanceof ChangeParametersRefactoring) {
                return new ChangeParametersPlugin((ChangeParametersRefactoring)refactoring);
            }
            if (refactoring instanceof IntroduceParameterRefactoring) {
                return new IntroduceParameterPlugin((IntroduceParameterRefactoring)refactoring);
            }
            if (refactoring instanceof EncapsulateFieldRefactoring) {
                return new EncapsulateFieldRefactoringPlugin((EncapsulateFieldRefactoring)refactoring);
            }
            if (refactoring instanceof EncapsulateFieldsRefactoring) {
                return new EncapsulateFieldsPlugin((EncapsulateFieldsRefactoring)refactoring);
            }
            if (refactoring instanceof InlineRefactoring) {
                return new InlineRefactoringPlugin((InlineRefactoring)refactoring);
            }
            if (refactoring instanceof ReplaceConstructorWithFactoryRefactoring) {
                return new ReplaceConstructorWithFactoryPlugin((ReplaceConstructorWithFactoryRefactoring)refactoring);
            }
            if (refactoring instanceof InvertBooleanRefactoring) {
                return new InvertBooleanRefactoringPlugin((InvertBooleanRefactoring)refactoring);
            }
            if (refactoring instanceof ReplaceConstructorWithBuilderRefactoring) {
                return new ReplaceConstructorWithBuilderPlugin((ReplaceConstructorWithBuilderRefactoring)refactoring);
            }
        }
        return null;
    }

    private boolean checkMove(Lookup refactoringSource) {
        ElementHandle elementHandle;
        for (FileObject f : refactoringSource.lookupAll(FileObject.class)) {
            if (RefactoringUtils.isJavaFile(f)) {
                return true;
            }
            if (!f.isFolder()) continue;
            return true;
        }
        Collection tphs = refactoringSource.lookupAll(TreePathHandle.class);
        return tphs.size() == 1 && (elementHandle = ((TreePathHandle)tphs.iterator().next()).getElementHandle()) != null && (elementHandle.getKind().isClass() || elementHandle.getKind().isInterface());
    }

    private boolean checkSafeDelete(Lookup object) {
        boolean a = false;
        NonRecursiveFolder folder = (NonRecursiveFolder)object.lookup(NonRecursiveFolder.class);
        if (folder != null) {
            return true;
        }
        for (FileObject f : object.lookupAll(FileObject.class)) {
            a = true;
            if (!f.isValid()) {
                return false;
            }
            if (RefactoringUtils.isJavaFile(f) || JavaRefactoringsFactory.isPackage(f)) continue;
            return false;
        }
        if (object.lookup(TreePathHandle.class) != null) {
            return true;
        }
        return a;
    }

    private boolean checkCopy(Lookup object) {
        Collection fileObjects = object.lookupAll(FileObject.class);
        for (FileObject f : fileObjects) {
            if (f == null || !RefactoringUtils.isJavaFile(f)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPackage(FileObject fileObject) {
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
            return false;
        }
        return dataObject instanceof DataFolder && RefactoringUtils.isFileInOpenProject(fileObject) && JavaRefactoringUtils.isOnSourceClasspath(fileObject) && !RefactoringUtils.isClasspathRoot(fileObject);
    }

    private boolean checkMoveMembers(Context context) {
        return context.lookup(JavaMoveMembersProperties.class) != null;
    }
}

