/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.definitions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptDiagnostic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.definitions.DynamicConfigurationsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDependenciesProvider;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u0016\u0010\u0003\u001a\u00020\u0004*\f\u0012\u0004\u0012\u00020\u00040\u0005j\u0002`\u0006H\u0002\u00a8\u0006\u0007"}, d2={"findScriptCompilationConfiguration", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "Lcom/intellij/psi/PsiFile;", "valueOrError", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "Lkotlin/script/experimental/api/ResultWithDiagnostics;", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationResult;", "kotlin-scripting-compiler-impl"})
public final class DynamicConfigurationsKt {
    @Nullable
    public static final ScriptCompilationConfiguration findScriptCompilationConfiguration(@NotNull PsiFile $this$findScriptCompilationConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$findScriptCompilationConfiguration, (String)"<this>");
        if (!($this$findScriptCompilationConfiguration instanceof KtFile)) {
            return null;
        }
        VirtualFile virtualFile = ((KtFile)$this$findScriptCompilationConfiguration).getVirtualFile();
        if (virtualFile == null) {
            virtualFile = ((KtFile)$this$findScriptCompilationConfiguration).getOriginalFile().getVirtualFile();
        }
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        if (DefinitionsKt.isNonScript(file)) {
            return null;
        }
        Project project = ((KtFile)$this$findScriptCompilationConfiguration).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        ScriptDependenciesProvider provider = ScriptDependenciesProvider.Companion.getInstance(project);
        Object object = provider;
        if (object == null || (object = ((ScriptDependenciesProvider)object).getScriptConfiguration((KtFile)$this$findScriptCompilationConfiguration)) == null || (object = ((ScriptCompilationConfigurationWrapper)object).getConfiguration()) == null) {
            ScriptDefinition scriptDefinition = DefinitionsKt.findScriptDefinition($this$findScriptCompilationConfiguration);
            object = scriptDefinition != null ? scriptDefinition.getCompilationConfiguration() : null;
        }
        return object;
    }

    private static final ScriptCompilationConfigurationWrapper valueOrError(ResultWithDiagnostics<? extends ScriptCompilationConfigurationWrapper> $this$valueOrError) {
        ResultWithDiagnostics<? extends ScriptCompilationConfigurationWrapper> $this$valueOr$iv = $this$valueOrError;
        boolean $i$f$valueOr = false;
        ResultWithDiagnostics<? extends ScriptCompilationConfigurationWrapper> resultWithDiagnostics = $this$valueOr$iv;
        if (!(resultWithDiagnostics instanceof ResultWithDiagnostics.Success)) {
            if (resultWithDiagnostics instanceof ResultWithDiagnostics.Failure) {
                Iterator iterator;
                String string;
                block7: {
                    Object v0;
                    ResultWithDiagnostics.Failure failure;
                    block6: {
                        failure = (ResultWithDiagnostics.Failure)$this$valueOr$iv;
                        boolean bl = false;
                        Iterable $this$singleOrNull$iv = failure.getReports();
                        boolean $i$f$singleOrNull = false;
                        Object single$iv = null;
                        boolean found$iv = false;
                        for (Object element$iv : $this$singleOrNull$iv) {
                            ScriptDiagnostic it = (ScriptDiagnostic)element$iv;
                            boolean bl2 = false;
                            if (!(it.getSeverity() == ScriptDiagnostic.Severity.ERROR)) continue;
                            if (found$iv) {
                                v0 = null;
                                break block6;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        v0 = !found$iv ? null : single$iv;
                    }
                    ScriptDiagnostic singleCause = v0;
                    if (singleCause != null) {
                        throw new IllegalStateException(singleCause.getMessage(), singleCause.getException());
                    }
                    Iterable iterable = failure.getReports();
                    string = "Error retrieving script compilation configuration: " + CollectionsKt.joinToString$default((Iterable)failure.getReports(), null, null, null, (int)0, null, (Function1)valueOrError.1.1.INSTANCE, (int)31, null);
                    Iterable iterable2 = iterable;
                    for (Iterator iterator2 : iterable2) {
                        ScriptDiagnostic it = (ScriptDiagnostic)iterator2;
                        boolean bl = false;
                        if (!(it.getException() != null)) continue;
                        iterator = iterator2;
                        break block7;
                    }
                    iterator = null;
                }
                ScriptDiagnostic scriptDiagnostic = (ScriptDiagnostic)iterator;
                Throwable throwable = scriptDiagnostic != null ? scriptDiagnostic.getException() : null;
                String string2 = string;
                throw new IllegalStateException(string2, throwable);
            }
            throw new NoWhenBranchMatchedException();
        }
        return (ScriptCompilationConfigurationWrapper)((ResultWithDiagnostics.Success)$this$valueOr$iv).getValue();
    }
}

