/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.BufferOverflowException;
import java.nio.CharBuffer;

final class StreamedText
implements CharSequence {
    private final Reader reader;
    private char[] buffer;
    private boolean expandableBuffer;
    private int bufferBegin = 0;
    private int readerPos = 0;
    private int minRequiredBufferBegin = 0;
    private int end = Integer.MAX_VALUE;
    private boolean atEndOfStream = false;
    public static final char END_OF_STREAM = '\uffff';
    public static int INITIAL_EXPANDABLE_BUFFER_SIZE = 8192;

    public StreamedText(Reader reader, char[] buffer) {
        this.reader = reader;
        this.setBuffer(buffer);
    }

    public StreamedText(Reader reader) {
        this(reader, null);
    }

    private StreamedText(char[] text, int length) {
        this.reader = null;
        this.buffer = text;
        this.expandableBuffer = false;
        this.end = length;
        this.readerPos = Integer.MAX_VALUE;
    }

    public StreamedText(char[] text) {
        this(text, text.length);
    }

    public StreamedText(CharBuffer text) {
        this(text.array(), text.length());
    }

    public StreamedText(CharSequence text) {
        this(StreamedText.toCharArray(text));
    }

    public StreamedText setBuffer(char[] buffer) {
        if (buffer != null) {
            this.buffer = buffer;
            this.expandableBuffer = false;
        } else {
            this.buffer = new char[INITIAL_EXPANDABLE_BUFFER_SIZE];
            this.expandableBuffer = true;
        }
        return this;
    }

    public boolean hasExpandableBuffer() {
        return this.expandableBuffer;
    }

    @Override
    public char charAt(int pos) {
        if (pos >= this.readerPos) {
            this.readToPosition(pos);
        }
        if (!this.checkPos(pos)) {
            this.atEndOfStream = true;
            return '\uffff';
        }
        return this.buffer[pos - this.bufferBegin];
    }

    public final boolean atEndOfStream() {
        if (this.atEndOfStream) {
            this.atEndOfStream = false;
            return true;
        }
        return false;
    }

    public void setMinRequiredBufferBegin(int minRequiredBufferBegin) {
        if (minRequiredBufferBegin < this.bufferBegin) {
            throw new IllegalArgumentException("Cannot set minimum required buffer begin to already discarded position " + minRequiredBufferBegin);
        }
        this.minRequiredBufferBegin = minRequiredBufferBegin;
    }

    public int getMinRequiredBufferBegin() {
        return this.minRequiredBufferBegin;
    }

    @Override
    public int length() {
        if (this.end == Integer.MAX_VALUE) {
            throw new IllegalStateException("Length of streamed text cannot be determined until end of file has been reached");
        }
        return this.end;
    }

    public int getEnd() {
        return this.end;
    }

    private boolean prepareBufferRange(int begin, int end) {
        int lastRequiredPos = end - 1;
        if (lastRequiredPos > this.readerPos) {
            this.readToPosition(lastRequiredPos);
        }
        return this.checkPos(begin) && end <= this.end;
    }

    public void writeTo(Writer writer, int begin, int end) throws IOException {
        if (!this.prepareBufferRange(begin, end)) {
            throw new IndexOutOfBoundsException();
        }
        writer.write(this.buffer, begin - this.bufferBegin, end - begin);
    }

    public String substring(int begin, int end) {
        int charCount;
        int n = charCount = this.prepareBufferRange(begin, end) ? end - begin : this.end - begin;
        if (!this.prepareBufferRange(begin, end)) {
            throw new IndexOutOfBoundsException();
        }
        return new String(this.buffer, begin - this.bufferBegin, end - begin);
    }

    @Override
    public CharSequence subSequence(int begin, int end) {
        return this.getCharBuffer(begin, end);
    }

    public CharBuffer getCharBuffer(int begin, int end) {
        if (!this.prepareBufferRange(begin, end)) {
            throw new IndexOutOfBoundsException();
        }
        return CharBuffer.wrap(this.buffer, begin - this.bufferBegin, end - begin);
    }

    @Override
    public String toString() {
        throw new UnsupportedOperationException("Streamed text can not be converted to a string");
    }

    public String getDebugInfo() {
        return "Buffer size: \"" + this.buffer.length + "\", bufferBegin=" + this.bufferBegin + ", minRequiredBufferBegin=" + this.minRequiredBufferBegin + ", readerPos=" + this.readerPos;
    }

    public char[] getBuffer() {
        return this.buffer;
    }

    public int getBufferBegin() {
        return this.bufferBegin;
    }

    private boolean checkPos(int pos) {
        if (pos < this.bufferBegin) {
            throw new IllegalStateException("StreamedText position " + pos + " has been discarded");
        }
        return pos < this.end;
    }

    public int getBufferOverflowPosition() {
        return this.minRequiredBufferBegin + this.buffer.length;
    }

    private void readToPosition(int pos) {
        try {
            if (pos >= this.bufferBegin + this.buffer.length) {
                if (pos >= this.minRequiredBufferBegin + this.buffer.length) {
                    if (!this.expandableBuffer) {
                        throw new BufferOverflowException();
                    }
                    this.expandBuffer(pos - this.minRequiredBufferBegin + 1);
                }
                this.discardUsedText();
                if (pos >= this.end) {
                    return;
                }
            }
            while (this.readerPos <= pos) {
                int charCount = this.reader.read(this.buffer, this.readerPos - this.bufferBegin, this.bufferBegin + this.buffer.length - this.readerPos);
                if (charCount == -1) {
                    this.end = this.readerPos;
                    return;
                }
                this.readerPos += charCount;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void expandBuffer(int minSize) throws IOException {
        int newSize = this.buffer.length * 2;
        if (newSize < minSize) {
            newSize = minSize;
        }
        char[] newBuffer = new char[newSize];
        this.shiftBuffer(this.buffer, newBuffer);
        this.buffer = newBuffer;
    }

    private void discardUsedText() throws IOException {
        if (this.minRequiredBufferBegin == this.bufferBegin) {
            return;
        }
        this.shiftBuffer(this.buffer, this.buffer);
    }

    private void shiftBuffer(char[] fromBuffer, char[] toBuffer) throws IOException {
        int shift = this.minRequiredBufferBegin - this.bufferBegin;
        int usedBufferLength = this.readerPos - this.bufferBegin;
        for (int i = shift; i < usedBufferLength; ++i) {
            toBuffer[i - shift] = fromBuffer[i];
        }
        this.bufferBegin = this.minRequiredBufferBegin;
        while (this.readerPos < this.bufferBegin) {
            long charCount = this.reader.skip(this.bufferBegin - this.readerPos);
            if (charCount == 0L) {
                this.end = this.readerPos;
                break;
            }
            this.readerPos = (int)((long)this.readerPos + charCount);
        }
    }

    String getCurrentBufferContent() {
        return this.substring(this.bufferBegin, Math.min(this.end, this.readerPos));
    }

    private static char[] toCharArray(CharSequence text) {
        if (text instanceof String) {
            return ((String)text).toCharArray();
        }
        char[] charArray = new char[text.length()];
        for (int i = 0; i < charArray.length; ++i) {
            charArray[i] = text.charAt(i);
        }
        return charArray;
    }
}

