/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class DeID
extends JFrame
implements ActionListener {
    public static final String BLANK = "";
    public static final String DEFPRETEXT = "dI";
    public static final String[] KEYCOLNAMES = new String[]{"$SRC", "SAMPLE ID", "CASE NUMBER", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
    public static final Dimension SIZE = new Dimension(170, 160);
    public static final int PRETEXTSIZE = 10;
    public static final int FOLDERSIZE = 22;
    public static final String FILEHINT = "Select or Create Folder";
    private KeywordSelector kSel;
    private Message msg;
    JButton bStart;
    JButton keySelect;
    JButton deleteSelect;
    JButton browseB;
    FileViewPanel fileView;
    Container mycp;
    DefaultListModel keyListModel;
    JList keyList;
    JTextField preTextA;
    JTextField folderA;
    FileDialog fd;
    JFileChooser fc;
    HelpBox helper;
    static final JMenuBar mainMenuBar = new JMenuBar();
    protected JMenu fileMenu;
    protected JMenu helpMenu;
    protected JMenuItem filei_1;
    protected JMenuItem helpi_1;
    private String[] keys;
    private String preText;
    private String outFolder;

    public DeID() {
        super("FCS file de-Identifier v2.0");
        this.setJMenuBar(mainMenuBar);
        this.fileMenu = new JMenu("File");
        mainMenuBar.add(this.fileMenu);
        this.fileMenu.addSeparator();
        this.filei_1 = new JMenuItem("Quit");
        this.filei_1.setActionCommand("File");
        this.filei_1.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.filei_1.addActionListener(this);
        this.fileMenu.add(this.filei_1);
        this.helpMenu = new JMenu("Help");
        mainMenuBar.add(this.helpMenu);
        this.helpi_1 = new JMenuItem("deID Help..");
        this.helpi_1.setActionCommand("Help");
        this.helpi_1.addActionListener(this);
        this.helpMenu.add(this.helpi_1);
        this.mycp = this.getContentPane();
        JPanel centre = new JPanel();
        centre.setLayout(new BoxLayout(centre, 0));
        this.fileView = new FileViewPanel();
        this.fileView.setAlignmentY(0.0f);
        centre.add(this.fileView);
        JPanel delPan = new JPanel();
        delPan.setBorder(BorderFactory.createEmptyBorder(50, 0, 0, 0));
        delPan.setAlignmentY(0.0f);
        URL deleteImageURL = DeID.class.getResource("images/delete.gif");
        this.deleteSelect = new JButton(new ImageIcon(deleteImageURL));
        this.deleteSelect.addActionListener(this);
        this.deleteSelect.setToolTipText("Delete the selected file from the list");
        this.deleteSelect.setAlignmentY(0.0f);
        delPan.add(this.deleteSelect);
        centre.add(delPan);
        centre.add(Box.createRigidArea(new Dimension(20, 0)));
        JPanel keyView = new JPanel();
        keyView.setLayout(new BoxLayout(keyView, 1));
        JLabel keyL = new JLabel("Keywords to be scrubbed:");
        keyL.setAlignmentX(0.0f);
        keyView.add(keyL);
        this.keys = new String[KEYCOLNAMES.length];
        this.setKeywords(KEYCOLNAMES);
        this.keyListModel = new DefaultListModel();
        this.setList();
        this.keyList = new JList(this.keyListModel);
        this.keyList.setSelectionMode(0);
        JScrollPane keyScroller = new JScrollPane(this.keyList);
        keyScroller.setMinimumSize(SIZE);
        keyScroller.setPreferredSize(SIZE);
        keyScroller.setAlignmentX(0.0f);
        keyView.add(keyScroller);
        this.keySelect = new JButton("Select keywords");
        this.keySelect.addActionListener(this);
        this.keySelect.setAlignmentX(0.0f);
        keyView.add(this.keySelect);
        keyView.setAlignmentY(0.0f);
        centre.add(keyView);
        centre.add(Box.createRigidArea(new Dimension(20, 0)));
        JPanel prependP = new JPanel();
        prependP.setLayout(new BoxLayout(prependP, 1));
        JLabel prependL = new JLabel("To prepend to scrubbed file name:");
        prependL.setAlignmentX(0.0f);
        prependP.add(prependL);
        this.preTextA = new JTextField(10);
        this.preTextA.setText(DEFPRETEXT);
        this.preTextA.setMaximumSize(this.preTextA.getPreferredSize());
        this.preTextA.setAlignmentX(0.0f);
        prependP.add(this.preTextA);
        prependP.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel folderL = new JLabel("Alternative folder to write scrubbed files:");
        folderL.setAlignmentX(0.0f);
        prependP.add(folderL);
        JPanel folderP = new JPanel();
        folderP.setLayout(new FlowLayout(0, 0, 0));
        this.folderA = new JTextField(22);
        this.folderA.setEditable(false);
        this.folderA.setMaximumSize(this.folderA.getPreferredSize());
        folderP.add(this.folderA);
        this.browseB = new JButton("Browse..");
        this.browseB.addActionListener(this);
        folderP.add(this.browseB);
        folderP.setAlignmentX(0.0f);
        prependP.add(folderP);
        prependP.add(Box.createVerticalGlue());
        prependP.setAlignmentY(0.0f);
        centre.add(prependP);
        centre.add(Box.createRigidArea(new Dimension(10, 0)));
        this.mycp.add((Component)centre, "Center");
        JPanel south = new JPanel();
        south.setLayout(new FlowLayout(0));
        this.bStart = new JButton("Proceed with de-identification");
        this.bStart.addActionListener(this);
        south.add(this.bStart);
        this.mycp.add((Component)south, "South");
        this.pack();
        this.setVisible(true);
        this.showMessage("Caution: It is good practice to back up all files before processing with DeID.");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        MessageOption option = null;
        boolean ok = true;
        Object target = evt.getSource();
        if (target instanceof JMenuItem) {
            JMenuItem mi = (JMenuItem)target;
            String menu_label = mi.getActionCommand();
            if (menu_label.compareTo("File") == 0) {
                if (mi.getText().compareTo("Quit") == 0) {
                    System.exit(0);
                }
            } else if (menu_label.compareTo("Help") == 0 && mi.getText().compareTo("deID Help..") == 0) {
                this.showHelp();
            }
        } else if (target == this.bStart) {
            File[] allFiles = this.fileView.getAllFiles();
            if (allFiles != null && this.keys != null && this.keys.length > 0) {
                ok = true;
                this.preText = this.preTextA.getText().trim();
                this.outFolder = this.folderA.getText().trim();
                if (this.outFolder != null && this.outFolder.length() == 0) {
                    this.outFolder = null;
                }
                if (this.preText == null || this.preText.length() == 0) {
                    if (this.outFolder == null) {
                        this.showMessage("If no text is prepended, files must be written to a new folder");
                        ok = false;
                    } else {
                        option = new MessageOption(this, "CAUTION! If no text is prepended, the new files will have the original names. If this is your intention, press 'Continue'", "Cancel", "Continue");
                        ok = option.ok();
                    }
                }
                if (ok && !this.wipeEm(allFiles)) {
                    this.showMessage("Not all files were processed. Output files must be have prepended names or be written to an accessible new folder");
                }
            }
        } else if (target == this.keySelect) {
            File selFile = this.fileView.getSingleSelectedFile();
            if (selFile != null) {
                String path = selFile.getPath();
                if (path != null) {
                    this.keys = this.selectKeywords(new FileSpec(path), this.keys, KEYCOLNAMES.length);
                    this.setList();
                }
            } else {
                this.showMessage("Select a single FCS file");
            }
        } else if (target == this.deleteSelect) {
            this.fileView.deleteSelectedFile();
        } else if (target == this.browseB) {
            String folder;
            File selFile;
            int returnVal;
            if (this.fc == null) {
                this.fc = new JFileChooser();
                this.fc.setFileSelectionMode(1);
            }
            if ((returnVal = this.fc.showSaveDialog(this)) == 0 && (selFile = this.fc.getSelectedFile()) != null && (folder = selFile.getPath()) != null) {
                this.folderA.setText(folder);
            }
        }
    }

    private void showHelp() {
        if (this.helper == null) {
            this.helper = new HelpBox();
        }
        this.helper.setVisible(true);
    }

    public void setKeywords(String[] inKeys) {
        if (inKeys != null) {
            int i = 0;
            while (i < inKeys.length) {
                if (i < this.keys.length) {
                    this.keys[i] = inKeys[i];
                }
                ++i;
            }
        }
    }

    private void setList() {
        int i = this.keyListModel.getSize();
        while (--i >= 0) {
            this.keyListModel.remove(i);
        }
        i = 0;
        while (i < this.keys.length) {
            if (this.keys[i] != null && this.keys[i].length() > 0) {
                this.keyListModel.addElement(this.keys[i]);
            }
            ++i;
        }
    }

    public String[] selectKeywords(FileSpec fs, String[] keys, int maxCount) {
        if (this.kSel == null) {
            this.kSel = new KeywordSelector(this);
        }
        this.kSel.set(fs, keys, maxCount);
        this.kSel.setVisible(true);
        return this.kSel.getKeysList();
    }

    private boolean wipeEm(File[] files) {
        boolean ok = true;
        int i = 0;
        while (i < files.length) {
            if (files[i].exists()) {
                boolean selected = this.fileView.selectFile(files[i]);
                FileSpec fs = new FileSpec(files[i].getPath());
                if (fs != null) {
                    if (fs.clearKeys(this.keys) && fs.writeNew(this.preText, this.outFolder)) {
                        if (selected) {
                            this.fileView.deleteSelectedFile();
                        }
                    } else {
                        ok = false;
                    }
                }
            }
            ++i;
        }
        return ok;
    }

    private void showMessage(String msgText) {
        this.msg = new Message(this, msgText);
    }

    public static void main(String[] args) {
        new DeID();
    }
}

