/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh;

import edsim51sh.MainPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UpdateFreqPanel
extends JPanel
implements ActionListener {
    private JComboBox updateFreqComboBox;
    private JLabel updateFreqLabel;
    private Integer[] instructionBatchSizes = new Integer[]{new Integer(50000), new Integer(10000), new Integer(1000), new Integer(100), new Integer(1)};
    private MainPanel sim;
    private boolean initComplete = false;

    public UpdateFreqPanel(MainPanel sim) {
        this.sim = sim;
        this.initComponents();
        this.updateFreqComboBox.addItem(this.instructionBatchSizes[0]);
        this.updateFreqComboBox.addItem(this.instructionBatchSizes[1]);
        this.updateFreqComboBox.addItem(this.instructionBatchSizes[2]);
        this.updateFreqComboBox.addItem(this.instructionBatchSizes[3]);
        this.updateFreqComboBox.addItem(this.instructionBatchSizes[4]);
        this.updateFreqComboBox.setEditable(true);
        this.updateFreqComboBox.setSelectedItem(new Integer(sim.settings.getInstructionBatchSize()));
        this.initComplete = true;
    }

    private void initComponents() {
        this.updateFreqLabel = new JLabel();
        this.updateFreqComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.setBackground(new Color(0, 0, 0));
        this.setToolTipText("Select or type the number of instructions to be executed between screen updates.");
        this.updateFreqLabel.setBackground(Color.BLACK);
        this.updateFreqLabel.setFont(new Font("Monospaced", 1, 12));
        this.updateFreqLabel.setForeground(Color.WHITE);
        this.updateFreqLabel.setText("Update Freq.");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 2);
        this.add((Component)this.updateFreqLabel, gbc);
        this.updateFreqComboBox.setFont(new Font("Monospaced", 1, 10));
        this.setUpdateFreqComboBoxSize(new Dimension(55, 18));
        this.updateFreqComboBox.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.updateFreqComboBox, gbc);
    }

    public void setUpdateFreqComboBoxSize(Dimension d) {
        this.updateFreqComboBox.setMaximumSize(d);
        this.updateFreqComboBox.setMinimumSize(d);
        this.updateFreqComboBox.setPreferredSize(d);
    }

    public void setMenuFont(Font font) {
        this.updateFreqComboBox.setFont(font);
    }

    public void setLabelFont(Font font) {
        this.updateFreqLabel.setFont(font);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.initComplete) {
            try {
                this.sim.settings.setInstructionBatchSize((Integer)this.updateFreqComboBox.getSelectedItem());
            }
            catch (ClassCastException ex) {
                this.updateFreqComboBox.setSelectedItem(new Integer(this.sim.settings.getInstructionBatchSize()));
            }
        }
    }
}

