/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Mapping;
import edsim51di.Peripheral;
import edsim51di.logicdiagram.LogicDiagramInterface;

class Keypad
extends Peripheral {
    private Mapping[] rowMappings;
    private Mapping[] columnMappings;
    private Mapping gateMapping;

    Keypad(Mapping[] mappings, int numberOfRows, Mapping gateMapping) {
        super("Keypad", true);
        int i;
        this.rowMappings = new Mapping[numberOfRows];
        this.columnMappings = new Mapping[mappings.length - numberOfRows];
        for (i = 0; i < numberOfRows; ++i) {
            this.rowMappings[i] = mappings[i];
        }
        for (i = 0; i < this.columnMappings.length; ++i) {
            this.columnMappings[i] = mappings[numberOfRows + i];
        }
        this.gateMapping = gateMapping;
    }

    @Override
    public LogicDiagramInterface[] getLogicDiagramInterfaces() {
        int i;
        LogicDiagramInterface[] interfaces = new LogicDiagramInterface[this.rowMappings.length + this.columnMappings.length + 1];
        int start = 165;
        int index = 0;
        for (i = 0; i < this.rowMappings.length; ++i) {
            interfaces[index] = new LogicDiagramInterface();
            interfaces[index].peripheralPin = start;
            interfaces[index].portNumber = this.rowMappings[i].portNumber;
            interfaces[index].pinNumber = this.rowMappings[i].pinNumber;
            start -= 20;
            ++index;
        }
        start = 93;
        for (i = 0; i < this.columnMappings.length; ++i) {
            interfaces[index] = new LogicDiagramInterface();
            interfaces[index].peripheralPin = start;
            interfaces[index].portNumber = this.columnMappings[i].portNumber;
            interfaces[index].pinNumber = this.columnMappings[i].pinNumber;
            start -= 11;
            ++index;
        }
        interfaces[index] = new LogicDiagramInterface();
        interfaces[index].peripheralPin = 25;
        interfaces[index].portNumber = this.gateMapping.portNumber;
        interfaces[index].pinNumber = this.gateMapping.pinNumber;
        return interfaces;
    }
}

