/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import com.itextpdf.awt.DefaultFontMapper;
import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Graphics;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.TreePanel;
import org.forester.phylogeny.Phylogeny;
import org.forester.util.ForesterUtil;

final class PdfExporter {
    private static final int HEIGHT_LIMIT = 100;
    private static final int WIDTH_LIMIT = 60;
    private static final int MARGIN_X = 20;
    private static final int MARGIN_Y = 10;

    private PdfExporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String writePhylogenyToPdf(String string, TreePanel treePanel, int n, int n2) throws IOException {
        int n3 = n2 < 100 ? 120 : n2 + 20;
        int n4 = n < 60 ? 100 : n + 40;
        Phylogeny phylogeny = treePanel.getPhylogeny();
        if (phylogeny == null || phylogeny.isEmpty()) {
            return "";
        }
        if (treePanel.getMainPanel().getTreeFontSet().getSmallFont().getSize() < 1) {
            throw new IOException("fonts are too small for PDF export");
        }
        if (treePanel.getMainPanel().getTreeFontSet().getLargeFont().getSize() < 1) {
            throw new IOException("fonts are too small for PDF export");
        }
        File file = new File(string);
        if (file.isDirectory()) {
            throw new IOException("[" + string + "] is a directory");
        }
        Document document = new Document();
        document.setPageSize(new Rectangle(n4, n3));
        document.setMargins(20.0f, 20.0f, 10.0f, 10.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(string));
        }
        catch (DocumentException documentException) {
            throw new IOException(documentException);
        }
        document.open();
        DefaultFontMapper defaultFontMapper = new DefaultFontMapper();
        FontFactory.registerDirectories();
        if (ForesterUtil.isWindows()) {
            defaultFontMapper.insertDirectory("c:/windows/fonts");
        } else if (ForesterUtil.isMac()) {
            defaultFontMapper.insertDirectory("/Library/Fonts/");
            defaultFontMapper.insertDirectory("/System/Library/Fonts/");
        } else {
            defaultFontMapper.insertDirectory("/usr/X/lib/X11/fonts/TrueType/");
            defaultFontMapper.insertDirectory("/usr/X/lib/X11/fonts/Type1/");
            defaultFontMapper.insertDirectory("/usr/share/fonts/default/TrueType/");
            defaultFontMapper.insertDirectory("/usr/share/fonts/default/Type1/");
        }
        PdfExporter.enableUnicode(defaultFontMapper);
        PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
        PdfGraphics2D pdfGraphics2D = new PdfGraphics2D(pdfContentByte, (float)n4, (float)n3, defaultFontMapper);
        try {
            treePanel.paintPhylogeny(pdfGraphics2D, true, false, n4, n3, 0, 0);
        }
        catch (Exception exception) {
            AptxUtil.unexpectedException(exception);
        }
        finally {
            try {
                ((Graphics)pdfGraphics2D).dispose();
                document.close();
            }
            catch (Exception exception) {}
        }
        String string2 = file.toString() + " [size: " + n4 + ", " + n3 + "]";
        return string2;
    }

    private static final void enableUnicode(DefaultFontMapper defaultFontMapper) {
        HashMap<String, DefaultFontMapper.BaseFontParameters> hashMap = defaultFontMapper.getMapper();
        for (String string : hashMap.keySet()) {
            String string2 = string.toLowerCase();
            if (!string2.contains("unicode") && !string2.equals("dialog")) continue;
            DefaultFontMapper.BaseFontParameters baseFontParameters = (DefaultFontMapper.BaseFontParameters)hashMap.get(string);
            try {
                baseFontParameters.encoding = "Identity-H";
                baseFontParameters.embedded = true;
            }
            catch (Exception exception) {}
        }
    }
}

